/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationType;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.ManagementEventListener;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.api.ServerListener;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.SctpXMLBinding;
import org.mobicents.protocols.sctp.SelectorThread;
import org.mobicents.protocols.sctp.ServerImpl;

public class ManagementImpl
implements Management {
    private static final Logger logger = Logger.getLogger(ManagementImpl.class);
    private static final String SCTP_PERSIST_DIR_KEY = "sctp.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sctp.xml";
    private static final String SERVERS = "servers";
    private static final String ASSOCIATIONS = "associations";
    private static final String CONNECT_DELAY_PROP = "connectdelay";
    private static final String SINGLE_THREAD_PROP = "singlethread";
    private static final String WORKER_THREADS_PROP = "workerthreads";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    protected static final SctpXMLBinding binding = new SctpXMLBinding();
    protected static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private final String name;
    protected String persistDir = null;
    protected FastList<Server> servers = new FastList();
    protected AssociationMap<String, Association> associations = new AssociationMap();
    private FastList<ChangeRequest> pendingChanges = new FastList();
    private Selector socketSelector = null;
    private SelectorThread selectorThread = null;
    static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private int workerThreads = DEFAULT_IO_THREADS;
    private boolean singleThread = true;
    private int workerThreadCount = 0;
    private int maxIOErrors = 3;
    private int connectDelay = 5000;
    private int bufferSize = 8192;
    private ExecutorService[] executorServices = null;
    private FastList<ManagementEventListener> managementEventListeners = new FastList();
    private ServerListener serverListener = null;
    private volatile boolean started = false;

    public ManagementImpl(String name) throws IOException {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(ServerImpl.class, "server");
        binding.setAlias(AssociationImpl.class, "association");
        binding.setAlias(String.class, "string");
        this.socketSelector = SelectorProvider.provider().openSelector();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public int getConnectDelay() {
        return this.connectDelay;
    }

    @Override
    public void setConnectDelay(int connectDelay) throws Exception {
        if (!this.started) {
            throw new Exception("ConnectDelay parameter can be updated only when SCTP stack is running");
        }
        this.connectDelay = connectDelay;
        this.store();
    }

    @Override
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    @Override
    public void setWorkerThreads(int workerThreads) throws Exception {
        if (this.started) {
            throw new Exception("WorkerThreads parameter can be updated only when SCTP stack is NOT running");
        }
        if (workerThreads < 1) {
            workerThreads = DEFAULT_IO_THREADS;
        }
        this.workerThreads = workerThreads;
    }

    public int getMaxIOErrors() {
        return this.maxIOErrors;
    }

    public void setMaxIOErrors(int maxIOErrors) {
        if (maxIOErrors < 1) {
            maxIOErrors = 1;
        }
        this.maxIOErrors = maxIOErrors;
    }

    @Override
    public boolean isSingleThread() {
        return this.singleThread;
    }

    @Override
    public void setSingleThread(boolean singleThread) throws Exception {
        if (this.started) {
            throw new Exception("SingleThread parameter can be updated only when SCTP stack is NOT running");
        }
        this.singleThread = singleThread;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int bufferSize) throws Exception {
        if (this.started) {
            throw new Exception("BufferSize parameter can be updated only when SCTP stack is NOT running");
        }
        if (bufferSize < 1000 || bufferSize > 1000000) {
            throw new Exception("BufferSize must be between 1000 and 1000000 bytes");
        }
        this.bufferSize = bufferSize;
    }

    @Override
    public ServerListener getServerListener() {
        return this.serverListener;
    }

    protected FastList<ManagementEventListener> getManagementEventListeners() {
        return this.managementEventListeners;
    }

    @Override
    public void setServerListener(ServerListener serverListener) {
        this.serverListener = serverListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManagementEventListener(ManagementEventListener listener) {
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            if (this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<ManagementEventListener> newManagementEventListeners = new FastList<ManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManagementEventListener(ManagementEventListener listener) {
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            if (!this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<ManagementEventListener> newManagementEventListeners = new FastList<ManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.started) {
            logger.warn(String.format("management=%s is already started", this.name));
            return;
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            this.persistFile.clear();
            if (this.persistDir != null) {
                this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
            } else {
                this.persistFile.append(System.getProperty(SCTP_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
            }
            logger.info(String.format("SCTP configuration file path %s", this.persistFile.toString()));
            try {
                this.load();
            }
            catch (FileNotFoundException e) {
                logger.warn(String.format("Failed to load the SCTP configuration file. \n%s", e.getMessage()));
            }
            if (!this.singleThread) {
                this.executorServices = new ExecutorService[this.workerThreads];
                for (int i = 0; i < this.workerThreads; ++i) {
                    this.executorServices[i] = Executors.newSingleThreadExecutor();
                }
            }
            this.selectorThread = new SelectorThread(this.socketSelector, this);
            this.selectorThread.setStarted(true);
            new Thread(this.selectorThread).start();
            this.started = true;
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Started SCTP Management=%s WorkerThreads=%d SingleThread=%s", this.name, this.singleThread ? 0 : this.workerThreads, this.singleThread));
            }
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServiceStarted();
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServiceStarted", ee);
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (!this.started) {
            logger.warn(String.format("management=%s is already stopped", this.name));
            return;
        }
        for (ManagementEventListener lstr : this.managementEventListeners) {
            try {
                lstr.onServiceStopped();
            }
            catch (Throwable ee) {
                logger.error("Exception while invoking onServiceStopped", ee);
            }
        }
        this.store();
        AssociationMap<String, Association> associationsTemp = this.associations;
        FastCollection.Record n = associationsTemp.head();
        FastMap.Entry end = associationsTemp.tail();
        while ((n = ((FastMap.Entry)n).getNext()) != end) {
            Association associationTemp = (Association)((FastMap.Entry)n).getValue();
            if (!associationTemp.isStarted()) continue;
            ((AssociationImpl)associationTemp).stop();
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n2 = tempServers.head();
        FastCollection.Record end2 = tempServers.tail();
        while ((n2 = ((FastList.Node)n2).getNext()) != end2) {
            Server serverTemp = (Server)((FastList.Node)n2).getValue();
            if (!serverTemp.isStarted()) continue;
            try {
                ((ServerImpl)serverTemp).stop();
            }
            catch (Exception e) {
                logger.error(String.format("Exception while stopping the Server=%s", serverTemp.getName()), e);
            }
        }
        if (this.executorServices != null) {
            for (int i = 0; i < this.executorServices.length; ++i) {
                this.executorServices[i].shutdown();
            }
        }
        this.selectorThread.setStarted(false);
        this.socketSelector.wakeup();
        for (int i1 = 0; i1 < 20; ++i1) {
            boolean assConnected = false;
            FastCollection.Record n3 = this.associations.head();
            FastMap.Entry end3 = this.associations.tail();
            while ((n3 = ((FastMap.Entry)n3).getNext()) != end3) {
                Association associationTemp = (Association)((FastMap.Entry)n3).getValue();
                if (!associationTemp.isConnected()) continue;
                assConnected = true;
                break;
            }
            if (!assConnected) break;
            Thread.sleep(100L);
        }
        if (this.executorServices != null) {
            for (int i = 0; i < this.executorServices.length; ++i) {
                if (this.executorServices[i].isTerminated()) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("Waiting for worker thread to die gracefully ....");
                }
                try {
                    this.executorServices[i].awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            try {
                this.connectDelay = reader.read(CONNECT_DELAY_PROP, Integer.class);
                Integer vali = reader.read(WORKER_THREADS_PROP, Integer.class);
                Boolean bl = reader.read(SINGLE_THREAD_PROP, Boolean.class);
            }
            catch (NullPointerException vali) {
                // empty catch block
            }
            this.servers = reader.read(SERVERS, FastList.class);
            FastCollection.Record n = this.servers.head();
            FastMap.Entry end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Server serverTemp = (Server)((FastList.Node)n).getValue();
                ((ServerImpl)serverTemp).setManagement(this);
                if (!serverTemp.isStarted()) continue;
                try {
                    ((ServerImpl)serverTemp).start();
                }
                catch (Exception e) {
                    logger.error(String.format("Error while initiating Server=%s", serverTemp.getName()), e);
                }
            }
            this.associations = reader.read(ASSOCIATIONS, AssociationMap.class);
            n = this.associations.head();
            end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                AssociationImpl associationTemp = (AssociationImpl)((FastMap.Entry)n).getValue();
                associationTemp.setManagement(this);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.connectDelay, CONNECT_DELAY_PROP, Integer.class);
            writer.write(this.servers, SERVERS, FastList.class);
            writer.write(this.associations, ASSOCIATIONS, AssociationMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error while persisting the Rule state in file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllResourses() throws Exception {
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            if (!this.started) {
                throw new Exception(String.format("Management=%s not started", this.name));
            }
            if (this.associations.size() == 0 && this.servers.size() == 0) {
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Removing allocated resources: Servers=%d, Associations=%d", this.servers.size(), this.associations.size()));
            }
            ManagementImpl managementImpl2 = this;
            synchronized (managementImpl2) {
                ArrayList<Object> lst = new ArrayList<Object>();
                FastCollection.Record n = this.associations.head();
                FastMap.Entry entry = this.associations.tail();
                while ((n = ((FastMap.Entry)n).getNext()) != entry) {
                    lst.add(((FastMap.Entry)n).getKey());
                }
                for (String string : lst) {
                    this.stopAssociation(string);
                    this.removeAssociation(string);
                }
                lst.clear();
                n = this.servers.head();
                FastCollection.Record record = this.servers.tail();
                while ((n = ((FastList.Node)n).getNext()) != record) {
                    lst.add(((Server)((FastList.Node)n).getValue()).getName());
                }
                for (String string : lst) {
                    this.stopServer(string);
                    this.removeServer(string);
                }
                this.store();
            }
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onRemoveAllResources();
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onRemoveAllResources", ee);
                }
            }
        }
    }

    @Override
    public ServerImpl addServer(String serverName, String hostAddress, int port) throws Exception {
        return this.addServer(serverName, hostAddress, port, IpChannelType.SCTP, false, 0, null);
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        return this.addServer(serverName, hostAddress, port, ipChannelType, false, 0, extraHostAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String[] extraHostAddresses) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (hostAddress == null) {
            throw new Exception("Server host address cannot be null");
        }
        if (port < 1) {
            throw new Exception("Server host port cannot be less than 1");
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            FastCollection.Record n = this.servers.head();
            FastCollection.Record end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Server serverTemp = (Server)((FastList.Node)n).getValue();
                if (serverName.equals(serverTemp.getName())) {
                    throw new Exception(String.format("Server name=%s already exist", serverName));
                }
                if (!hostAddress.equals(serverTemp.getHostAddress()) || port != serverTemp.getHostport()) continue;
                throw new Exception(String.format("Server name=%s is already bound to %s:%d", serverTemp.getName(), serverTemp.getHostAddress(), serverTemp.getHostport()));
            }
            ServerImpl server = new ServerImpl(serverName, hostAddress, port, ipChannelType, acceptAnonymousConnections, maxConcurrentConnectionsCount, extraHostAddresses);
            server.setManagement(this);
            FastList<Server> newServers = new FastList<Server>();
            newServers.addAll(this.servers);
            newServers.add(server);
            this.servers = newServers;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServerAdded(server);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServerAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Created Server=%s", server.getName()));
            }
            return server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            ServerImpl removeServer = null;
            FastCollection.Record n = this.servers.head();
            FastCollection.Record end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                ServerImpl serverTemp = (ServerImpl)((FastList.Node)n).getValue();
                if (!serverName.equals(serverTemp.getName())) continue;
                if (serverTemp.isStarted()) {
                    throw new Exception(String.format("Server=%s is started. Stop the server before removing", serverName));
                }
                if (serverTemp.anonymAssociations.size() != 0 || serverTemp.associations.size() != 0) {
                    throw new Exception(String.format("Server=%s has Associations. Remove all those Associations before removing Server", serverName));
                }
                removeServer = serverTemp;
                break;
            }
            if (removeServer == null) {
                throw new Exception(String.format("No Server found with name=%s", serverName));
            }
            FastList<Server> newServers = new FastList<Server>();
            newServers.addAll(this.servers);
            newServers.remove(removeServer);
            this.servers = newServers;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServerRemoved(removeServer);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServerRemoved", ee);
                }
            }
        }
    }

    @Override
    public void startServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (this.name == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n = tempServers.head();
        FastCollection.Record end = tempServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            Server serverTemp = (Server)((FastList.Node)n).getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            if (serverTemp.isStarted()) {
                throw new Exception(String.format("Server=%s is already started", serverName));
            }
            ((ServerImpl)serverTemp).start();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server foubd with name=%s", serverName));
    }

    @Override
    public void stopServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n = tempServers.head();
        FastCollection.Record end = tempServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            Server serverTemp = (Server)((FastList.Node)n).getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            ((ServerImpl)serverTemp).stop();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server found with name=%s", serverName));
    }

    @Override
    public AssociationImpl addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName) throws Exception {
        return this.addServerAssociation(peerAddress, peerPort, serverName, assocName, IpChannelType.SCTP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociationImpl addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName, IpChannelType ipChannelType) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            if (this.associations.get(assocName) != null) {
                throw new Exception(String.format("Already has association=%s", assocName));
            }
            Server server = null;
            FastCollection.Record n = this.servers.head();
            FastMap.Entry end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Server serverTemp = (Server)((FastList.Node)n).getValue();
                if (!serverTemp.getName().equals(serverName)) continue;
                server = serverTemp;
            }
            if (server == null) {
                throw new Exception(String.format("No Server found for name=%s", serverName));
            }
            n = this.associations.head();
            end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (!peerAddress.equals(associationTemp.getPeerAddress()) || associationTemp.getPeerPort() != peerPort) continue;
                throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
            }
            if (server.getIpChannelType() != ipChannelType) {
                throw new Exception(String.format("Server and Accociation has different IP channel type", new Object[0]));
            }
            AssociationImpl association = new AssociationImpl(peerAddress, peerPort, serverName, assocName, ipChannelType);
            association.setManagement(this);
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.put(assocName, association);
            this.associations = newAssociations;
            FastList<String> newAssociations2 = new FastList<String>();
            newAssociations2.addAll(((ServerImpl)server).associations);
            newAssociations2.add(assocName);
            ((ServerImpl)server).associations = newAssociations2;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationAdded(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getAssociationType()}));
            }
            return association;
        }
    }

    @Override
    public AssociationImpl addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName) throws Exception {
        return this.addAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName, IpChannelType.SCTP, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociationImpl addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (hostAddress == null) {
            throw new Exception("Host address cannot be null");
        }
        if (hostPort < 0) {
            throw new Exception("Host port cannot be less than 0");
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            FastCollection.Record n = this.associations.head();
            FastMap.Entry end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (assocName.equals(associationTemp.getName())) {
                    throw new Exception(String.format("Already has association=%s", associationTemp.getName()));
                }
                if (peerAddress.equals(associationTemp.getPeerAddress()) && associationTemp.getPeerPort() == peerPort) {
                    throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
                }
                if (!hostAddress.equals(associationTemp.getHostAddress()) || associationTemp.getHostPort() != hostPort) continue;
                throw new Exception(String.format("Already has association=%s with same host address=%s and port=%d", associationTemp.getName(), hostAddress, hostPort));
            }
            AssociationImpl association = new AssociationImpl(hostAddress, hostPort, peerAddress, peerPort, assocName, ipChannelType, extraHostAddresses);
            association.setManagement(this);
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.put(assocName, association);
            this.associations = newAssociations;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationAdded(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getAssociationType()}));
            }
            return association;
        }
    }

    @Override
    public Association getAssociation(String assocName) throws Exception {
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        return associationTemp;
    }

    @Override
    public Map<String, Association> getAssociations() {
        HashMap<String, Association> routeTmp = new HashMap<String, Association>();
        routeTmp.putAll(this.associations);
        return routeTmp;
    }

    @Override
    public void startAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        if (associationTemp.isStarted()) {
            throw new Exception(String.format("Association=%s is already started", assocName));
        }
        ((AssociationImpl)associationTemp).start();
        this.store();
    }

    @Override
    public void stopAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association association = (Association)this.associations.get(assocName);
        if (association == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        ((AssociationImpl)association).stop();
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        ManagementImpl managementImpl = this;
        synchronized (managementImpl) {
            Association association = (Association)this.associations.get(assocName);
            if (association == null) {
                throw new Exception(String.format("No Association found for name=%s", assocName));
            }
            if (association.isStarted()) {
                throw new Exception(String.format("Association name=%s is started. Stop before removing", assocName));
            }
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.remove(assocName);
            this.associations = newAssociations;
            if (((AssociationImpl)association).getAssociationType() == AssociationType.SERVER) {
                FastCollection.Record n = this.servers.head();
                FastCollection.Record end = this.servers.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    Server serverTemp = (Server)((FastList.Node)n).getValue();
                    if (!serverTemp.getName().equals(association.getServerName())) continue;
                    FastList<String> newAssociations2 = new FastList<String>();
                    newAssociations2.addAll(((ServerImpl)serverTemp).associations);
                    newAssociations2.remove(assocName);
                    ((ServerImpl)serverTemp).associations = newAssociations2;
                    break;
                }
            }
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationRemoved(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationRemoved", ee);
                }
            }
        }
    }

    @Override
    public List<Server> getServers() {
        return this.servers.unmodifiable();
    }

    protected FastList<ChangeRequest> getPendingChanges() {
        return this.pendingChanges;
    }

    protected Selector getSocketSelector() {
        return this.socketSelector;
    }

    protected void populateWorkerThread(int[] workerThreadTable) {
        for (int count = 0; count < workerThreadTable.length; ++count) {
            if (this.workerThreadCount == this.workerThreads) {
                this.workerThreadCount = 0;
            }
            workerThreadTable[count] = this.workerThreadCount++;
        }
    }

    protected ExecutorService getExecutorService(int index) {
        return this.executorServices[index];
    }
}

