/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;

public class TCContinueMessageImpl
implements TCContinueMessage {
    private static final String _OCTET_STRING_ENCODE = "US-ASCII";
    private byte[] originatingTransactionId;
    private byte[] destinationTransactionId;
    private DialogPortion dp;
    private Component[] component;

    public Component[] getComponent() {
        return this.component;
    }

    public byte[] getDestinationTransactionId() {
        return this.destinationTransactionId;
    }

    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    public byte[] getOriginatingTransactionId() {
        return this.originatingTransactionId;
    }

    public void setComponent(Component[] c) {
        this.component = c;
    }

    public void setDestinationTransactionId(byte[] t) {
        this.destinationTransactionId = t;
    }

    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
    }

    public void setOriginatingTransactionId(byte[] t) {
        this.originatingTransactionId = t;
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 8 || localAis.getTagClass() != 1) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Continue: Expected OriginatingTransactionId, found tag: " + tag);
            }
            this.originatingTransactionId = localAis.readOctetString();
            tag = localAis.readTag();
            if (tag != 9 || localAis.getTagClass() != 1) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Continue: Expected DestinationTransactionId, found tag: " + tag);
            }
            this.destinationTransactionId = localAis.readOctetString();
            if (localAis.available() == 0) {
                return;
            }
            block7: while (true) {
                if (localAis.available() == 0) {
                    return;
                }
                tag = localAis.readTag();
                if (localAis.isTagPrimitive() || localAis.getTagClass() != 1) {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Continue: DialogPortion and Component portion must be constructive and has tag class CLASS_APPLICATION");
                }
                switch (tag) {
                    case 11: {
                        this.dp = TcapFactory.createDialogPortion(localAis);
                        continue block7;
                    }
                    case 12: {
                        Component c;
                        AsnInputStream compAis = localAis.readSequenceStream();
                        ArrayList<Component> cps = new ArrayList<Component>();
                        while (compAis.available() > 0 && (c = TcapFactory.createComponent(compAis)) != null) {
                            cps.add(c);
                        }
                        this.component = new Component[cps.size()];
                        this.component = cps.toArray(this.component);
                        continue block7;
                    }
                }
                break;
            }
            throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Continue: DialogPortion and Componebt parsing: bad tag - " + tag);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding TC-Continue: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding TC-Continue: " + e.getMessage(), e);
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            aos.writeTag(1, false, 5);
            int pos = aos.StartContentDefiniteLength();
            aos.writeOctetString(1, 8, this.originatingTransactionId);
            aos.writeOctetString(1, 9, this.destinationTransactionId);
            if (this.dp != null) {
                this.dp.encode(aos);
            }
            if (this.component != null) {
                aos.writeTag(1, false, 12);
                int pos2 = aos.StartContentDefiniteLength();
                for (Component c : this.component) {
                    c.encode(aos);
                }
                aos.FinalizeContent(pos2);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding TC-Continue: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding TC-Continue: " + e.getMessage(), e);
        }
    }
}

