/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.LocationNumber;

public class LocationNumberImpl
extends AbstractNAINumber
implements LocationNumber {
    private static final String NUMBERING_PLAN_INDICATOR = "numberingPlanIndicator";
    private static final String INTERNAL_NETWORK_NUMBER_INDICATOR = "internalNetworkNumberIndicator";
    private static final String ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = "addressRepresentationRestrictedIndicator";
    private static final String SCREENING_INDICATOR = "screeningIndicator";
    private static final int DEFAULT_NUMBERING_PLAN_INDICATOR = 0;
    private static final int DEFAULT_INTERNAL_NETWORK_NUMBER_INDICATOR = 0;
    private static final int DEFAULT_ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = 0;
    private static final int DEFAULT_SCREENING_INDICATOR = 0;
    protected int numberingPlanIndicator;
    protected int internalNetworkNumberIndicator;
    protected int addressRepresentationRestrictedIndicator;
    protected int screeningIndicator;
    protected static final XMLFormat<LocationNumberImpl> ISUP_LOCATION_NUMBER_XML = new XMLFormat<LocationNumberImpl>(LocationNumberImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, LocationNumberImpl locationNumber) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.read(xml, locationNumber);
            locationNumber.numberingPlanIndicator = xml.getAttribute(LocationNumberImpl.NUMBERING_PLAN_INDICATOR, 0);
            locationNumber.internalNetworkNumberIndicator = xml.getAttribute(LocationNumberImpl.INTERNAL_NETWORK_NUMBER_INDICATOR, 0);
            locationNumber.addressRepresentationRestrictedIndicator = xml.getAttribute(LocationNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, 0);
            locationNumber.screeningIndicator = xml.getAttribute(LocationNumberImpl.SCREENING_INDICATOR, 0);
        }

        @Override
        public void write(LocationNumberImpl locationNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.write(locationNumber, xml);
            xml.setAttribute(LocationNumberImpl.NUMBERING_PLAN_INDICATOR, locationNumber.numberingPlanIndicator);
            xml.setAttribute(LocationNumberImpl.INTERNAL_NETWORK_NUMBER_INDICATOR, locationNumber.internalNetworkNumberIndicator);
            xml.setAttribute(LocationNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, locationNumber.addressRepresentationRestrictedIndicator);
            xml.setAttribute(LocationNumberImpl.SCREENING_INDICATOR, locationNumber.screeningIndicator);
        }
    };

    public LocationNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int internalNetworkNumberIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    public LocationNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public LocationNumberImpl() {
    }

    public LocationNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.internalNetworkNumberIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationRestrictedIndicator != 2) {
            return;
        }
        this.oddFlag = 0;
        this.natureOfAddresIndicator = 0;
        this.numberingPlanIndicator = 0;
        this.internalNetworkNumberIndicator = 0;
        this.screeningIndicator = 3;
        this.setAddress("");
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.internalNetworkNumberIndicator << 7;
        c |= this.addressRepresentationRestrictedIndicator << 2;
        bos.write(c |= this.screeningIndicator);
        return 1;
    }

    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() != 0) {
            return super.decodeDigits(bis);
        }
        this.setAddress("");
        return 0;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getInternalNetworkNumberIndicator() {
        return this.internalNetworkNumberIndicator;
    }

    public void setInternalNetworkNumberIndicator(int internalNetworkNumberIndicator) {
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 63;
    }

    public String toString() {
        return "LocationNumber [numberingPlanIndicator=" + this.numberingPlanIndicator + ", internalNetworkNumberIndicator=" + this.internalNetworkNumberIndicator + ", addressRepresentationRestrictedIndicator=" + this.addressRepresentationRestrictedIndicator + ", screeningIndicator=" + this.screeningIndicator + ", natureOfAddresIndicator=" + this.natureOfAddresIndicator + ", oddFlag=" + this.oddFlag + ", address=" + this.address + "]";
    }
}

