/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.CalledPartyBCDNumber;
import org.mobicents.protocols.ss7.cap.api.primitives.TimeAndTimezone;
import org.mobicents.protocols.ss7.cap.api.service.sms.InitialDPSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.EventTypeSMS;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.SMSAddressString;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.TPDataCodingScheme;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.TPProtocolIdentifier;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.TPShortMessageSpecificInfo;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.TPValidityPeriod;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.CalledPartyBCDNumberImpl;
import org.mobicents.protocols.ss7.cap.primitives.TimeAndTimezoneImpl;
import org.mobicents.protocols.ss7.cap.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.SMSAddressStringImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.TPDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.TPProtocolIdentifierImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.TPShortMessageSpecificInfoImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.TPValidityPeriodImpl;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.callhandling.CallReferenceNumber;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.GPRSMSClass;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.LocationInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.LocationInformationGPRS;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.MSClassmark2;
import org.mobicents.protocols.ss7.map.primitives.IMEIImpl;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.CallReferenceNumberImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.GPRSMSClassImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.LocationInformationGPRSImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.LocationInformationImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.MSClassmark2Impl;

public class InitialDPSMSRequestImpl
extends SmsMessageImpl
implements InitialDPSMSRequest {
    public static final String _PrimitiveName = "InitialDPSMSRequest";
    public static final int _ID_serviceKey = 0;
    public static final int _ID_destinationSubscriberNumber = 1;
    public static final int _ID_callingPartyNumber = 2;
    public static final int _ID_eventTypeSMS = 3;
    public static final int _ID_imsi = 4;
    public static final int _ID_locationInformationMSC = 5;
    public static final int _ID_locationInformationGPRS = 6;
    public static final int _ID_smscCAddress = 7;
    public static final int _ID_timeAndTimezone = 8;
    public static final int _ID_tPShortMessageSpecificInfo = 9;
    public static final int _ID_tPProtocolIdentifier = 10;
    public static final int _ID_tPDataCodingScheme = 11;
    public static final int _ID_tPValidityPeriod = 12;
    public static final int _ID_extensions = 13;
    public static final int _ID_smsReferenceNumber = 14;
    public static final int _ID_mscAddress = 15;
    public static final int _ID_sgsnNumber = 16;
    public static final int _ID_mSClassmark2 = 17;
    public static final int _ID_gprsMSClass = 18;
    public static final int _ID_imei = 19;
    public static final int _ID_calledPartyNumber = 20;
    private int serviceKey;
    private CalledPartyBCDNumber destinationSubscriberNumber;
    private SMSAddressString callingPartyNumber;
    private EventTypeSMS eventTypeSMS;
    private IMSI imsi;
    private LocationInformation locationInformationMSC;
    private LocationInformationGPRS locationInformationGPRS;
    private ISDNAddressString smscCAddress;
    private TimeAndTimezone timeAndTimezone;
    private TPShortMessageSpecificInfo tPShortMessageSpecificInfo;
    private TPProtocolIdentifier tPProtocolIdentifier;
    private TPDataCodingScheme tPDataCodingScheme;
    private TPValidityPeriod tPValidityPeriod;
    private CAPExtensions extensions;
    private CallReferenceNumber smsReferenceNumber;
    private ISDNAddressString mscAddress;
    private ISDNAddressString sgsnNumber;
    private MSClassmark2 mSClassmark2;
    private GPRSMSClass gprsMSClass;
    private IMEI imei;
    private ISDNAddressString calledPartyNumber;

    public InitialDPSMSRequestImpl() {
        this.serviceKey = -1;
    }

    public InitialDPSMSRequestImpl(int serviceKey, CalledPartyBCDNumber destinationSubscriberNumber, SMSAddressString callingPartyNumber, EventTypeSMS eventTypeSMS, IMSI imsi, LocationInformation locationInformationMSC, LocationInformationGPRS locationInformationGPRS, ISDNAddressString smscCAddress, TimeAndTimezone timeAndTimezone, TPShortMessageSpecificInfo tPShortMessageSpecificInfo, TPProtocolIdentifier tPProtocolIdentifier, TPDataCodingScheme tPDataCodingScheme, TPValidityPeriod tPValidityPeriod, CAPExtensions extensions, CallReferenceNumber smsReferenceNumber, ISDNAddressString mscAddress, ISDNAddressString sgsnNumber, MSClassmark2 mSClassmark2, GPRSMSClass gprsMSClass, IMEI imei, ISDNAddressString calledPartyNumber) {
        this.serviceKey = serviceKey;
        this.destinationSubscriberNumber = destinationSubscriberNumber;
        this.callingPartyNumber = callingPartyNumber;
        this.eventTypeSMS = eventTypeSMS;
        this.imsi = imsi;
        this.locationInformationMSC = locationInformationMSC;
        this.locationInformationGPRS = locationInformationGPRS;
        this.smscCAddress = smscCAddress;
        this.timeAndTimezone = timeAndTimezone;
        this.tPShortMessageSpecificInfo = tPShortMessageSpecificInfo;
        this.tPProtocolIdentifier = tPProtocolIdentifier;
        this.tPDataCodingScheme = tPDataCodingScheme;
        this.tPValidityPeriod = tPValidityPeriod;
        this.extensions = extensions;
        this.smsReferenceNumber = smsReferenceNumber;
        this.mscAddress = mscAddress;
        this.sgsnNumber = sgsnNumber;
        this.mSClassmark2 = mSClassmark2;
        this.gprsMSClass = gprsMSClass;
        this.imei = imei;
        this.calledPartyNumber = calledPartyNumber;
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    public CalledPartyBCDNumber getDestinationSubscriberNumber() {
        return this.destinationSubscriberNumber;
    }

    public SMSAddressString getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public EventTypeSMS getEventTypeSMS() {
        return this.eventTypeSMS;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public LocationInformation getLocationInformationMSC() {
        return this.locationInformationMSC;
    }

    public LocationInformationGPRS getLocationInformationGPRS() {
        return this.locationInformationGPRS;
    }

    public ISDNAddressString getSMSCAddress() {
        return this.smscCAddress;
    }

    public TimeAndTimezone getTimeAndTimezone() {
        return this.timeAndTimezone;
    }

    public TPShortMessageSpecificInfo getTPShortMessageSpecificInfo() {
        return this.tPShortMessageSpecificInfo;
    }

    public TPProtocolIdentifier getTPProtocolIdentifier() {
        return this.tPProtocolIdentifier;
    }

    public TPDataCodingScheme getTPDataCodingScheme() {
        return this.tPDataCodingScheme;
    }

    public TPValidityPeriod getTPValidityPeriod() {
        return this.tPValidityPeriod;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public CallReferenceNumber getSmsReferenceNumber() {
        return this.smsReferenceNumber;
    }

    public ISDNAddressString getMscAddress() {
        return this.mscAddress;
    }

    public ISDNAddressString getSgsnNumber() {
        return this.sgsnNumber;
    }

    public MSClassmark2 getMSClassmark2() {
        return this.mSClassmark2;
    }

    public GPRSMSClass getGPRSMSClass() {
        return this.gprsMSClass;
    }

    public IMEI getImei() {
        return this.imei;
    }

    public ISDNAddressString getCalledPartyNumber() {
        return this.calledPartyNumber;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.initialDPSMS_Request;
    }

    public int getOperationCode() {
        return 60;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding InitialDPSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.serviceKey = -1;
        this.destinationSubscriberNumber = null;
        this.callingPartyNumber = null;
        this.eventTypeSMS = null;
        this.imsi = null;
        this.locationInformationMSC = null;
        this.locationInformationGPRS = null;
        this.smscCAddress = null;
        this.timeAndTimezone = null;
        this.tPShortMessageSpecificInfo = null;
        this.tPProtocolIdentifier = null;
        this.tPDataCodingScheme = null;
        this.tPValidityPeriod = null;
        this.extensions = null;
        this.smsReferenceNumber = null;
        this.mscAddress = null;
        this.sgsnNumber = null;
        this.mSClassmark2 = null;
        this.gprsMSClass = null;
        this.imei = null;
        this.calledPartyNumber = null;
        boolean isServiceKeyFound = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.serviceKey: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.serviceKey = (int)ais.readInteger();
                        isServiceKeyFound = true;
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.destinationSubscriberNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.destinationSubscriberNumber = new CalledPartyBCDNumberImpl();
                        ((CalledPartyBCDNumberImpl)this.destinationSubscriberNumber).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.callingPartyNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.callingPartyNumber = new SMSAddressStringImpl();
                        ((SMSAddressStringImpl)this.callingPartyNumber).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.eventTypeSMS: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.eventTypeSMS = EventTypeSMS.getInstance(i1);
                        break;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.imsi: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        break;
                    }
                    case 5: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.locationInformationMSC: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.locationInformationMSC = new LocationInformationImpl();
                        ((LocationInformationImpl)this.locationInformationMSC).decodeAll(ais);
                        break;
                    }
                    case 6: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.locationInformationGPRS: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.locationInformationGPRS = new LocationInformationGPRSImpl();
                        ((LocationInformationGPRSImpl)this.locationInformationGPRS).decodeAll(ais);
                        break;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.smscCAddress: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.smscCAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.smscCAddress).decodeAll(ais);
                        break;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.timeAndTimezone: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.timeAndTimezone = new TimeAndTimezoneImpl();
                        ((TimeAndTimezoneImpl)this.timeAndTimezone).decodeAll(ais);
                        break;
                    }
                    case 9: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.tPShortMessageSpecificInfo: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.tPShortMessageSpecificInfo = new TPShortMessageSpecificInfoImpl();
                        ((TPShortMessageSpecificInfoImpl)this.tPShortMessageSpecificInfo).decodeAll(ais);
                        break;
                    }
                    case 10: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.tPProtocolIdentifier: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.tPProtocolIdentifier = new TPProtocolIdentifierImpl();
                        ((TPProtocolIdentifierImpl)this.tPProtocolIdentifier).decodeAll(ais);
                        break;
                    }
                    case 11: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.tPDataCodingScheme: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.tPDataCodingScheme = new TPDataCodingSchemeImpl();
                        ((TPDataCodingSchemeImpl)this.tPDataCodingScheme).decodeAll(ais);
                        break;
                    }
                    case 12: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.tPValidityPeriod: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.tPValidityPeriod = new TPValidityPeriodImpl();
                        ((TPValidityPeriodImpl)this.tPValidityPeriod).decodeAll(ais);
                        break;
                    }
                    case 13: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.extensions: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 14: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.smsReferenceNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.smsReferenceNumber = new CallReferenceNumberImpl();
                        ((CallReferenceNumberImpl)this.smsReferenceNumber).decodeAll(ais);
                        break;
                    }
                    case 15: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.mscAddress: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mscAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.mscAddress).decodeAll(ais);
                        break;
                    }
                    case 16: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.sgsnNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.sgsnNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.sgsnNumber).decodeAll(ais);
                        break;
                    }
                    case 17: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.mSClassmark2: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mSClassmark2 = new MSClassmark2Impl();
                        ((MSClassmark2Impl)this.mSClassmark2).decodeAll(ais);
                        break;
                    }
                    case 18: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.gprsMSClass: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.gprsMSClass = new GPRSMSClassImpl();
                        ((GPRSMSClassImpl)this.gprsMSClass).decodeAll(ais);
                        break;
                    }
                    case 19: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.imei: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imei = new IMEIImpl();
                        ((IMEIImpl)this.imei).decodeAll(ais);
                        break;
                    }
                    case 20: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest.calledPartyNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.calledPartyNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.calledPartyNumber).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (!isServiceKeyFound) {
            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest: parameter ServiceKey is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding InitialDPSMSRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            asnOs.writeInteger(2, 0, this.serviceKey);
            if (this.destinationSubscriberNumber != null) {
                ((CalledPartyBCDNumberImpl)this.destinationSubscriberNumber).encodeAll(asnOs, 2, 1);
            }
            if (this.callingPartyNumber != null) {
                ((SMSAddressStringImpl)this.callingPartyNumber).encodeAll(asnOs, 2, 2);
            }
            if (this.eventTypeSMS != null) {
                asnOs.writeInteger(2, 3, this.eventTypeSMS.getCode());
            }
            if (this.imsi != null) {
                ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 4);
            }
            if (this.locationInformationMSC != null) {
                ((LocationInformationImpl)this.locationInformationMSC).encodeAll(asnOs, 2, 5);
            }
            if (this.locationInformationGPRS != null) {
                ((LocationInformationGPRSImpl)this.locationInformationGPRS).encodeAll(asnOs, 2, 6);
            }
            if (this.smscCAddress != null) {
                ((ISDNAddressStringImpl)this.smscCAddress).encodeAll(asnOs, 2, 7);
            }
            if (this.timeAndTimezone != null) {
                ((TimeAndTimezoneImpl)this.timeAndTimezone).encodeAll(asnOs, 2, 8);
            }
            if (this.tPShortMessageSpecificInfo != null) {
                ((TPShortMessageSpecificInfoImpl)this.tPShortMessageSpecificInfo).encodeAll(asnOs, 2, 9);
            }
            if (this.tPProtocolIdentifier != null) {
                ((TPProtocolIdentifierImpl)this.tPProtocolIdentifier).encodeAll(asnOs, 2, 10);
            }
            if (this.tPDataCodingScheme != null) {
                ((TPDataCodingSchemeImpl)this.tPDataCodingScheme).encodeAll(asnOs, 2, 11);
            }
            if (this.tPValidityPeriod != null) {
                ((TPValidityPeriodImpl)this.tPValidityPeriod).encodeAll(asnOs, 2, 12);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(asnOs, 2, 13);
            }
            if (this.smsReferenceNumber != null) {
                ((CallReferenceNumberImpl)this.smsReferenceNumber).encodeAll(asnOs, 2, 14);
            }
            if (this.mscAddress != null) {
                ((ISDNAddressStringImpl)this.mscAddress).encodeAll(asnOs, 2, 15);
            }
            if (this.sgsnNumber != null) {
                ((ISDNAddressStringImpl)this.sgsnNumber).encodeAll(asnOs, 2, 16);
            }
            if (this.mSClassmark2 != null) {
                ((MSClassmark2Impl)this.mSClassmark2).encodeAll(asnOs, 2, 17);
            }
            if (this.locationInformationGPRS != null) {
                ((LocationInformationGPRSImpl)this.locationInformationGPRS).encodeAll(asnOs, 2, 6);
            }
            if (this.gprsMSClass != null) {
                ((GPRSMSClassImpl)this.gprsMSClass).encodeAll(asnOs, 2, 18);
            }
            if (this.imei != null) {
                ((IMEIImpl)this.imei).encodeAll(asnOs, 2, 19);
            }
            if (this.calledPartyNumber != null) {
                ((ISDNAddressStringImpl)this.calledPartyNumber).encodeAll(asnOs, 2, 20);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding InitialDPSMSRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding InitialDPSMSRequest: " + e.getMessage(), e);
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding InitialDPSMSRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        sb.append(", serviceKey=");
        sb.append(this.serviceKey);
        if (this.destinationSubscriberNumber != null) {
            sb.append(", destinationSubscriberNumber=");
            sb.append(this.destinationSubscriberNumber.toString());
        }
        if (this.callingPartyNumber != null) {
            sb.append(", callingPartyNumber=");
            sb.append(this.callingPartyNumber.toString());
        }
        if (this.eventTypeSMS != null) {
            sb.append(", eventTypeSMS=");
            sb.append(this.eventTypeSMS.toString());
        }
        if (this.imsi != null) {
            sb.append(", imsi=");
            sb.append(this.imsi.toString());
        }
        if (this.locationInformationMSC != null) {
            sb.append(", locationInformationMSC=");
            sb.append(this.locationInformationMSC.toString());
        }
        if (this.locationInformationGPRS != null) {
            sb.append(", locationInformationGPRS=");
            sb.append(this.locationInformationGPRS.toString());
        }
        if (this.smscCAddress != null) {
            sb.append(", smscCAddress=");
            sb.append(this.smscCAddress.toString());
        }
        if (this.timeAndTimezone != null) {
            sb.append(", timeAndTimezone=");
            sb.append(this.timeAndTimezone.toString());
        }
        if (this.tPShortMessageSpecificInfo != null) {
            sb.append(", tPShortMessageSpecificInfo=");
            sb.append(this.tPShortMessageSpecificInfo.toString());
        }
        if (this.tPProtocolIdentifier != null) {
            sb.append(", tPProtocolIdentifier=");
            sb.append(this.tPProtocolIdentifier.toString());
        }
        if (this.tPDataCodingScheme != null) {
            sb.append(", tPDataCodingScheme=");
            sb.append(this.tPDataCodingScheme.toString());
        }
        if (this.tPValidityPeriod != null) {
            sb.append(", tPValidityPeriod=");
            sb.append(this.tPValidityPeriod.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.smsReferenceNumber != null) {
            sb.append(", smsReferenceNumber=");
            sb.append(this.smsReferenceNumber.toString());
        }
        if (this.mscAddress != null) {
            sb.append(", mscAddress=");
            sb.append(this.mscAddress.toString());
        }
        if (this.sgsnNumber != null) {
            sb.append(", sgsnNumber=");
            sb.append(this.sgsnNumber.toString());
        }
        if (this.mSClassmark2 != null) {
            sb.append(", mSClassmark2=");
            sb.append(this.mSClassmark2.toString());
        }
        if (this.gprsMSClass != null) {
            sb.append(", gprsMSClass=");
            sb.append(this.gprsMSClass.toString());
        }
        if (this.imei != null) {
            sb.append(", imei=");
            sb.append(this.imei.toString());
        }
        if (this.calledPartyNumber != null) {
            sb.append(", calledPartyNumber=");
            sb.append(this.calledPartyNumber.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

