/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import java.util.ArrayList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.MessageID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.MessageIDText;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariableMessage;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.MessageIDTextImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.VariableMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.ArrayListSerializingBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageIDImpl
implements MessageID,
CAPAsnPrimitive {
    public static final int _ID_elementaryMessageID = 0;
    public static final int _ID_text = 1;
    public static final int _ID_elementaryMessageIDs = 29;
    public static final int _ID_variableMessage = 30;
    public static final String _PrimitiveName = "MessageID";
    private static final String ELEMENTARY_MESSAGE_ID = "elementaryMessageID";
    private static final String TEXT = "text";
    private static final String ELEMENTARY_MESSAGE_IDS = "elementaryMessageIDs";
    private static final String VARIABLE_MESSAGE = "variableMessage";
    private Integer elementaryMessageID;
    private MessageIDText text;
    private ArrayList<Integer> elementaryMessageIDs;
    private VariableMessage variableMessage;
    protected static final XMLFormat<MessageIDImpl> MESSAGE_ID_XML = new XMLFormat<MessageIDImpl>(MessageIDImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, MessageIDImpl messageID) throws XMLStreamException {
            messageID.elementaryMessageID = xml.get(MessageIDImpl.ELEMENTARY_MESSAGE_ID, Integer.class);
            messageID.text = xml.get(MessageIDImpl.TEXT, MessageIDTextImpl.class);
            MessageID_ElementaryMessageIDs al = xml.get(MessageIDImpl.ELEMENTARY_MESSAGE_IDS, MessageID_ElementaryMessageIDs.class);
            if (al != null) {
                messageID.elementaryMessageIDs = al.getData();
            }
            messageID.variableMessage = xml.get(MessageIDImpl.VARIABLE_MESSAGE, VariableMessageImpl.class);
            int choiceCount = 0;
            if (messageID.elementaryMessageID != null) {
                ++choiceCount;
            }
            if (messageID.text != null) {
                ++choiceCount;
            }
            if (messageID.elementaryMessageIDs != null) {
                ++choiceCount;
            }
            if (messageID.variableMessage != null) {
                ++choiceCount;
            }
            if (choiceCount != 1) {
                throw new XMLStreamException("MessageID decoding error: there must be one choice selected, found: " + choiceCount);
            }
        }

        @Override
        public void write(MessageIDImpl messageID, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (messageID.elementaryMessageID != null) {
                xml.add(messageID.elementaryMessageID, MessageIDImpl.ELEMENTARY_MESSAGE_ID, Integer.class);
            }
            if (messageID.text != null) {
                xml.add((MessageIDTextImpl)messageID.text, MessageIDImpl.TEXT, MessageIDTextImpl.class);
            }
            if (messageID.elementaryMessageIDs != null) {
                MessageID_ElementaryMessageIDs al = new MessageID_ElementaryMessageIDs(messageID.elementaryMessageIDs);
                xml.add(al, MessageIDImpl.ELEMENTARY_MESSAGE_IDS, MessageID_ElementaryMessageIDs.class);
            }
            if (messageID.variableMessage != null) {
                xml.add((VariableMessageImpl)messageID.variableMessage, MessageIDImpl.VARIABLE_MESSAGE, VariableMessageImpl.class);
            }
        }
    };

    public MessageIDImpl() {
    }

    public MessageIDImpl(Integer elementaryMessageID) {
        this.elementaryMessageID = elementaryMessageID;
    }

    public MessageIDImpl(MessageIDText text) {
        this.text = text;
    }

    public MessageIDImpl(ArrayList<Integer> elementaryMessageIDs) {
        this.elementaryMessageIDs = elementaryMessageIDs;
    }

    public MessageIDImpl(VariableMessage variableMessage) {
        this.variableMessage = variableMessage;
    }

    @Override
    public Integer getElementaryMessageID() {
        return this.elementaryMessageID;
    }

    @Override
    public MessageIDText getText() {
        return this.text;
    }

    @Override
    public ArrayList<Integer> getElementaryMessageIDs() {
        return this.elementaryMessageIDs;
    }

    @Override
    public VariableMessage getVariableMessage() {
        return this.variableMessage;
    }

    @Override
    public int getTag() throws CAPException {
        if (this.elementaryMessageID != null) {
            return 0;
        }
        if (this.text != null) {
            return 1;
        }
        if (this.elementaryMessageIDs != null) {
            return 29;
        }
        if (this.variableMessage != null) {
            return 30;
        }
        throw new CAPException("Error while encoding MessageID: no of choices has been definite");
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.elementaryMessageID != null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding MessageID: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding MessageID: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding MessageID: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding MessageID: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.elementaryMessageID = null;
        this.text = null;
        this.elementaryMessageIDs = null;
        this.variableMessage = null;
        if (ais.getTagClass() != 2) {
            throw new CAPParsingComponentException("Error while decoding MessageID: bad tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.elementaryMessageID = (int)ais.readIntegerData(length);
                break;
            }
            case 1: {
                this.text = new MessageIDTextImpl();
                ((MessageIDTextImpl)this.text).decodeData(ais, length);
                break;
            }
            case 29: {
                this.elementaryMessageIDs = new ArrayList();
                AsnInputStream ais2 = ais.readSequenceStreamData(length);
                while (ais2.available() != 0) {
                    int tag2 = ais2.readTag();
                    if (ais2.getTagClass() != 0 || tag2 != 2 || !ais2.isTagPrimitive()) {
                        throw new CAPParsingComponentException("Error while decoding MessageID: bad tagClass or tag or is not primitive when decoding an elementaryMessageIDs SEQUENCE", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    Integer val = (int)ais2.readInteger();
                    this.elementaryMessageIDs.add(val);
                }
                break;
            }
            case 30: {
                this.variableMessage = new VariableMessageImpl();
                ((VariableMessageImpl)this.variableMessage).decodeData(ais, length);
                break;
            }
            default: {
                throw new CAPParsingComponentException("Error while decoding MessageID: bad tag: " + ais.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding MessageID: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        int choiceCnt = 0;
        if (this.elementaryMessageID != null) {
            ++choiceCnt;
        }
        if (this.text != null) {
            ++choiceCnt;
        }
        if (this.elementaryMessageIDs != null) {
            ++choiceCnt;
        }
        if (this.variableMessage != null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding MessageID: only one choice must be definite, found: " + choiceCnt);
        }
        try {
            if (this.elementaryMessageID != null) {
                asnOs.writeIntegerData(this.elementaryMessageID.intValue());
            }
            if (this.text != null) {
                ((MessageIDTextImpl)this.text).encodeData(asnOs);
            }
            if (this.elementaryMessageIDs != null) {
                if (this.elementaryMessageIDs.size() < 1 || this.elementaryMessageIDs.size() > 16) {
                    throw new CAPException("Error while encoding MessageID: elementaryMessageIDs count must be from 1 to 16, found: " + this.elementaryMessageIDs.size());
                }
                for (Integer val : this.elementaryMessageIDs) {
                    if (val == null) {
                        throw new CAPException("Error while encoding MessageID: the elementaryMessageIDs array has null values");
                    }
                    asnOs.writeInteger(val.intValue());
                }
            }
            if (this.variableMessage != null) {
                ((VariableMessageImpl)this.variableMessage).encodeData(asnOs);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding MessageID: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding MessageID: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.elementaryMessageID != null) {
            sb.append("elementaryMessageID=");
            sb.append(this.elementaryMessageID);
        }
        if (this.text != null) {
            sb.append(" text=");
            sb.append(this.text.toString());
        }
        if (this.elementaryMessageIDs != null) {
            sb.append(" elementaryMessageIDs=[");
            for (Integer val : this.elementaryMessageIDs) {
                if (val == null) continue;
                sb.append(val);
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.variableMessage != null) {
            sb.append(" variableMessage=");
            sb.append(this.variableMessage.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageID_ElementaryMessageIDs
    extends ArrayListSerializingBase<Integer> {
        public MessageID_ElementaryMessageIDs() {
            super(MessageIDImpl.ELEMENTARY_MESSAGE_ID, Integer.class);
        }

        public MessageID_ElementaryMessageIDs(ArrayList<Integer> data) {
            super(MessageIDImpl.ELEMENTARY_MESSAGE_ID, Integer.class, data);
        }
    }
}

