/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.SpecializedResourceReportRequest;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;

public class SpecializedResourceReportRequestImpl
extends CircuitSwitchedCallMessageImpl
implements SpecializedResourceReportRequest {
    public static final int _ID_allAnnouncementsComplete = 50;
    public static final int _ID_firstAnnouncementStarted = 51;
    public static final String _PrimitiveName = "SpecializedResourceReportRequestIndication";
    private Long linkedId;
    private Invoke linkedInvoke;
    private boolean isAllAnnouncementsComplete;
    private boolean isFirstAnnouncementStarted;
    private boolean isCAPVersion4orLater;

    public SpecializedResourceReportRequestImpl(boolean isCAPVersion4orLater) {
        this.isCAPVersion4orLater = isCAPVersion4orLater;
    }

    public SpecializedResourceReportRequestImpl(boolean isAllAnnouncementsComplete, boolean isFirstAnnouncementStarted, boolean isCAPVersion4orLater) {
        this.isAllAnnouncementsComplete = isAllAnnouncementsComplete;
        this.isFirstAnnouncementStarted = isFirstAnnouncementStarted;
        this.isCAPVersion4orLater = isCAPVersion4orLater;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.specializedResourceReport_Request;
    }

    public int getOperationCode() {
        return 49;
    }

    public Long getLinkedId() {
        return this.linkedId;
    }

    public void setLinkedId(Long val) {
        this.linkedId = val;
    }

    public Invoke getLinkedInvoke() {
        return this.linkedInvoke;
    }

    public void setLinkedInvoke(Invoke val) {
        this.linkedInvoke = val;
    }

    public boolean getAllAnnouncementsComplete() {
        return this.isAllAnnouncementsComplete;
    }

    public boolean getFirstAnnouncementStarted() {
        return this.isFirstAnnouncementStarted;
    }

    public int getTag() throws CAPException {
        if (this.isCAPVersion4orLater) {
            if (this.isAllAnnouncementsComplete) {
                return 50;
            }
            return 51;
        }
        return 5;
    }

    public int getTagClass() {
        if (this.isCAPVersion4orLater) {
            return 2;
        }
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding SpecializedResourceReportRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding SpecializedResourceReportRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding SpecializedResourceReportRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding SpecializedResourceReportRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        block6: {
            block5: {
                this.isAllAnnouncementsComplete = false;
                this.isFirstAnnouncementStarted = false;
                if (!this.isCAPVersion4orLater) break block5;
                switch (ansIS.getTag()) {
                    case 50: {
                        this.isAllAnnouncementsComplete = true;
                        break block6;
                    }
                    case 51: {
                        this.isFirstAnnouncementStarted = true;
                        break block6;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding SpecializedResourceReportRequestIndication: bad tag for CAP V4 or later.", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            if (ansIS.getTagClass() != 0) {
                throw new CAPParsingComponentException("Error while decoding SpecializedResourceReportRequestIndication: bad tag class for CAP V2 or V3. It must must be UNIVERSAL", CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
        ansIS.readNullData(length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding SpecializedResourceReportRequestIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.isCAPVersion4orLater && (this.isAllAnnouncementsComplete && this.isFirstAnnouncementStarted || !this.isAllAnnouncementsComplete && !this.isFirstAnnouncementStarted)) {
            throw new CAPException("Error while encoding SpecializedResourceReportRequestIndication: only one of choice must be selected when CAP V4 or later");
        }
        asnOs.writeNullData();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.linkedId != null) {
            sb.append(", linkedId=");
            sb.append(this.linkedId);
            sb.append(", ");
        }
        if (this.isAllAnnouncementsComplete) {
            sb.append(", isAllAnnouncementsComplete");
        }
        if (this.isFirstAnnouncementStarted) {
            sb.append(", isFirstAnnouncementStarted");
        }
        sb.append("]");
        return sb.toString();
    }
}

