/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.AssistRequestInstructionsRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.IPSSPCapabilities;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.IPSSPCapabilitiesImpl;

public class AssistRequestInstructionsRequestImpl
extends CircuitSwitchedCallMessageImpl
implements AssistRequestInstructionsRequest {
    public static final int _ID_correlationID = 0;
    public static final int _ID_iPSSPCapabilities = 2;
    public static final int _ID_extensions = 3;
    public static final String _PrimitiveName = "AssistRequestInstructionsRequestIndication";
    private Digits correlationID;
    private IPSSPCapabilities iPSSPCapabilities;
    private CAPExtensions extensions;

    public AssistRequestInstructionsRequestImpl() {
    }

    public AssistRequestInstructionsRequestImpl(Digits correlationID, IPSSPCapabilities ipSSPCapabilities, CAPExtensions extensions) {
        this.correlationID = correlationID;
        this.iPSSPCapabilities = ipSSPCapabilities;
        this.extensions = extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.assistRequestInstructions_Request;
    }

    public int getOperationCode() {
        return 16;
    }

    public Digits getCorrelationID() {
        return this.correlationID;
    }

    public IPSSPCapabilities getIPSSPCapabilities() {
        return this.iPSSPCapabilities;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AssistRequestInstructionsRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AssistRequestInstructionsRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AssistRequestInstructionsRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AssistRequestInstructionsRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.correlationID = null;
        this.iPSSPCapabilities = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block5: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.correlationID = new DigitsImpl();
                        ((DigitsImpl)this.correlationID).decodeAll(ais);
                        this.correlationID.setIsGenericNumber();
                        continue block5;
                    }
                    case 2: {
                        this.iPSSPCapabilities = new IPSSPCapabilitiesImpl();
                        ((IPSSPCapabilitiesImpl)this.iPSSPCapabilities).decodeAll(ais);
                        continue block5;
                    }
                    case 3: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        continue block5;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.correlationID == null || this.iPSSPCapabilities == null) {
            throw new CAPParsingComponentException("Error while decoding AssistRequestInstructionsRequestIndication: parameters correlationID and iPSSPCapabilities are mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding AssistRequestInstructionsRequestIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.correlationID == null || this.iPSSPCapabilities == null) {
            throw new CAPException("Error while encoding AssistRequestInstructionsRequestIndication: correlationID and iPSSPCapabilities must not be null");
        }
        ((DigitsImpl)this.correlationID).encodeAll(aos, 2, 0);
        ((IPSSPCapabilitiesImpl)this.iPSSPCapabilities).encodeAll(aos, 2, 2);
        if (this.extensions != null) {
            ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 3);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.correlationID != null) {
            sb.append(", correlationID=");
            sb.append(this.correlationID.toString());
        }
        if (this.iPSSPCapabilities != null) {
            sb.append(", iPSSPCapabilities=");
            sb.append(this.iPSSPCapabilities.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

