/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.Burst;
import org.mobicents.protocols.ss7.cap.api.primitives.BurstList;
import org.mobicents.protocols.ss7.cap.primitives.BurstImpl;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class BurstListImpl
extends SequenceBase
implements BurstList {
    public static final int _ID_warningPeriod = 0;
    public static final int _ID_bursts = 1;
    private static final String WARNING_PERIOD = "warningPeriod";
    private static final String BURSTS = "bursts";
    private Integer warningPeriod;
    private Burst bursts;
    protected static final XMLFormat<BurstListImpl> BURST_LIST_XML = new XMLFormat<BurstListImpl>(BurstListImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, BurstListImpl burstList) throws XMLStreamException {
            burstList.warningPeriod = xml.get(BurstListImpl.WARNING_PERIOD, Integer.class);
            burstList.bursts = xml.get(BurstListImpl.BURSTS, BurstImpl.class);
        }

        @Override
        public void write(BurstListImpl burstList, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (burstList.warningPeriod != null) {
                xml.add(burstList.warningPeriod, BurstListImpl.WARNING_PERIOD, Integer.class);
            }
            if (burstList.bursts != null) {
                xml.add((BurstImpl)burstList.bursts, BurstListImpl.BURSTS, BurstImpl.class);
            }
        }
    };

    public BurstListImpl() {
        super("BurstList");
    }

    public BurstListImpl(Integer warningPeriod, Burst burst) {
        super("BurstList");
        this.warningPeriod = warningPeriod;
        this.bursts = burst;
    }

    public Integer getWarningPeriod() {
        return this.warningPeriod;
    }

    public Burst getBursts() {
        return this.bursts;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException, INAPParsingComponentException {
        this.warningPeriod = null;
        this.bursts = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.warningPeriod = (int)ais.readInteger();
                        if (this.warningPeriod >= 1 && this.warningPeriod <= 1200) continue block4;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": warningPeriod must be 1..1200, received: " + this.warningPeriod, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 1: {
                        this.bursts = new BurstImpl();
                        ((BurstImpl)this.bursts).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.bursts == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bursts is mandatory but not found ", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.warningPeriod != null && (this.warningPeriod < 1 || this.warningPeriod > 1200)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": warningPeriod must be 1..1200, supplied: " + this.warningPeriod);
        }
        if (this.bursts == null) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": bursts parameter is mandatory but is not set supplied: ");
        }
        try {
            if (this.warningPeriod != null) {
                aos.writeInteger(2, 0, this.warningPeriod.intValue());
            }
            ((BurstImpl)this.bursts).encodeAll(aos, 2, 1);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.warningPeriod != null) {
            sb.append("warningPeriod=");
            sb.append(this.warningPeriod);
            sb.append(", ");
        }
        if (this.bursts != null) {
            sb.append("bursts=");
            sb.append(this.bursts);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

