/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.SctpServerChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.List;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.ManagementImpl;

public class ServerImpl
implements Server {
    private static final Logger logger = Logger.getLogger(ServerImpl.class.getName());
    private static final String COMMA = ", ";
    private static final String NAME = "name";
    private static final String HOST_ADDRESS = "hostAddress";
    private static final String HOST_PORT = "hostPort";
    private static final String IPCHANNEL_TYPE = "ipChannelType";
    private static final String ASSOCIATIONS = "associations";
    private static final String EXTRA_HOST_ADDRESS = "extraHostAddress";
    private static final String ACCEPT_ANONYMOUS_CONNECTIONS = "acceptAnonymousConnections";
    private static final String MAX_CONCURRENT_CONNECTIONS_COUNT = "maxConcurrentConnectionsCount";
    private static final String STARTED = "started";
    private static final String EXTRA_HOST_ADDRESS_SIZE = "extraHostAddresseSize";
    private String name;
    private String hostAddress;
    private int hostport;
    private volatile boolean started = false;
    private IpChannelType ipChannelType;
    private boolean acceptAnonymousConnections;
    private int maxConcurrentConnectionsCount;
    private String[] extraHostAddresses;
    private ManagementImpl management = null;
    protected FastList<String> associations = new FastList();
    protected FastList<Association> anonymAssociations = new FastList();
    private SctpServerChannel serverChannelSctp;
    private ServerSocketChannel serverChannelTcp;
    protected static final XMLFormat<ServerImpl> SERVER_XML = new XMLFormat<ServerImpl>(ServerImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ServerImpl server) throws XMLStreamException {
            server.name = xml.getAttribute(ServerImpl.NAME, "");
            server.started = xml.getAttribute(ServerImpl.STARTED, false);
            server.hostAddress = xml.getAttribute(ServerImpl.HOST_ADDRESS, "");
            server.hostport = xml.getAttribute(ServerImpl.HOST_PORT, 0);
            server.ipChannelType = IpChannelType.getInstance(xml.getAttribute(ServerImpl.IPCHANNEL_TYPE, IpChannelType.SCTP.getCode()));
            if (server.ipChannelType == null) {
                throw new XMLStreamException("Bad value for server.ipChannelType");
            }
            server.acceptAnonymousConnections = xml.getAttribute(ServerImpl.ACCEPT_ANONYMOUS_CONNECTIONS, false);
            server.maxConcurrentConnectionsCount = xml.getAttribute(ServerImpl.MAX_CONCURRENT_CONNECTIONS_COUNT, 0);
            int extraHostAddressesSize = xml.getAttribute(ServerImpl.EXTRA_HOST_ADDRESS_SIZE, 0);
            ServerImpl.access$702(server, new String[extraHostAddressesSize]);
            for (int i = 0; i < extraHostAddressesSize; ++i) {
                ((ServerImpl)server).extraHostAddresses[i] = xml.get(ServerImpl.EXTRA_HOST_ADDRESS, String.class);
            }
            server.associations = xml.get(ServerImpl.ASSOCIATIONS, FastList.class);
        }

        @Override
        public void write(ServerImpl server, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ServerImpl.NAME, server.name);
            xml.setAttribute(ServerImpl.STARTED, server.started);
            xml.setAttribute(ServerImpl.HOST_ADDRESS, server.hostAddress);
            xml.setAttribute(ServerImpl.HOST_PORT, server.hostport);
            xml.setAttribute(ServerImpl.IPCHANNEL_TYPE, server.ipChannelType.getCode());
            xml.setAttribute(ServerImpl.ACCEPT_ANONYMOUS_CONNECTIONS, server.acceptAnonymousConnections);
            xml.setAttribute(ServerImpl.MAX_CONCURRENT_CONNECTIONS_COUNT, server.maxConcurrentConnectionsCount);
            xml.setAttribute(ServerImpl.EXTRA_HOST_ADDRESS_SIZE, server.extraHostAddresses != null ? server.extraHostAddresses.length : 0);
            if (server.extraHostAddresses != null) {
                for (String s : server.extraHostAddresses) {
                    xml.add(s, ServerImpl.EXTRA_HOST_ADDRESS, String.class);
                }
            }
            xml.add(server.associations, ServerImpl.ASSOCIATIONS, FastList.class);
        }
    };

    public ServerImpl() {
    }

    public ServerImpl(String name, String hostAddress, int hostport, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String[] extraHostAddresses) throws IOException {
        this.name = name;
        this.hostAddress = hostAddress;
        this.hostport = hostport;
        this.ipChannelType = ipChannelType;
        this.acceptAnonymousConnections = acceptAnonymousConnections;
        this.maxConcurrentConnectionsCount = maxConcurrentConnectionsCount;
        this.extraHostAddresses = extraHostAddresses;
    }

    protected void start() throws Exception {
        this.initSocket();
        this.started = true;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Started Server=%s", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws Exception {
        FastList<String> tempAssociations = this.associations;
        Object n = tempAssociations.head();
        FastCollection.Record end = tempAssociations.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            String assocName = (String)((FastList.Node)n).getValue();
            Association associationTemp = this.management.getAssociation(assocName);
            if (!associationTemp.isStarted()) continue;
            throw new Exception(String.format("Stop all the associations first. Association=%s is still started", associationTemp.getName()));
        }
        n = this.anonymAssociations;
        synchronized (n) {
            for (Association ass : this.anonymAssociations) {
                ass.stopAnonymousAssociation();
            }
            this.anonymAssociations.clear();
        }
        if (this.getIpChannel() != null) {
            try {
                this.getIpChannel().close();
            }
            catch (Exception e) {
                logger.warn(String.format("Error while stopping the Server=%s", this.name), e);
            }
        }
        this.started = false;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Stoped Server=%s", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSocket() throws IOException {
        FastList<ChangeRequest> pendingChanges;
        if (this.ipChannelType == IpChannelType.SCTP) {
            this.doInitSocketSctp();
        } else {
            this.doInitSocketTcp();
        }
        FastList<ChangeRequest> fastList = pendingChanges = this.management.getPendingChanges();
        synchronized (fastList) {
            pendingChanges.add(new ChangeRequest(this.getIpChannel(), null, 1, 16));
        }
        this.management.getSocketSelector().wakeup();
    }

    private void doInitSocketSctp() throws IOException {
        this.serverChannelSctp = SctpServerChannel.open();
        this.serverChannelSctp.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.hostAddress, this.hostport);
        this.serverChannelSctp.bind(isa);
        if (this.extraHostAddresses != null) {
            for (String s : this.extraHostAddresses) {
                this.serverChannelSctp.bindAddress(InetAddress.getByName(s));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("SctpServerChannel bound to=%s ", this.serverChannelSctp.getAllLocalAddresses()));
        }
    }

    private void doInitSocketTcp() throws IOException {
        this.serverChannelTcp = ServerSocketChannel.open();
        this.serverChannelTcp.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.hostAddress, this.hostport);
        this.serverChannelTcp.bind(isa);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("ServerSocketChannel bound to=%s ", this.serverChannelTcp.getLocalAddress()));
        }
    }

    @Override
    public IpChannelType getIpChannelType() {
        return this.ipChannelType;
    }

    @Override
    public boolean isAcceptAnonymousConnections() {
        return this.acceptAnonymousConnections;
    }

    @Override
    public int getMaxConcurrentConnectionsCount() {
        return this.maxConcurrentConnectionsCount;
    }

    @Override
    public void setMaxConcurrentConnectionsCount(int val) {
        this.maxConcurrentConnectionsCount = val;
    }

    @Override
    public List<Association> getAnonymAssociations() {
        return this.anonymAssociations.unmodifiable();
    }

    protected AbstractSelectableChannel getIpChannel() {
        if (this.ipChannelType == IpChannelType.SCTP) {
            return this.serverChannelSctp;
        }
        return this.serverChannelTcp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public int getHostport() {
        return this.hostport;
    }

    @Override
    public String[] getExtraHostAddresses() {
        return this.extraHostAddresses;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void setManagement(ManagementImpl management) {
        this.management = management;
    }

    @Override
    public List<String> getAssociations() {
        return this.associations.unmodifiable();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Server [name=").append(this.name).append(", started=").append(this.started).append(", hostAddress=").append(this.hostAddress).append(", hostPort=").append(this.hostport).append(", ipChannelType=").append((Object)this.ipChannelType).append(", acceptAnonymousConnections=").append(this.acceptAnonymousConnections).append(", maxConcurrentConnectionsCount=").append(this.maxConcurrentConnectionsCount).append(", associations(anonymous does not included)=[");
        FastCollection.Record n = this.associations.head();
        FastCollection.Record end = this.associations.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            sb.append((String)((FastList.Node)n).getValue());
            sb.append(COMMA);
        }
        sb.append("], extraHostAddress=[");
        if (this.extraHostAddresses != null) {
            for (int i = 0; i < this.extraHostAddresses.length; ++i) {
                String extraHostAddress = this.extraHostAddresses[i];
                sb.append(extraHostAddress);
                sb.append(COMMA);
            }
        }
        sb.append("]]");
        return sb.toString();
    }

    static /* synthetic */ String[] access$702(ServerImpl x0, String[] x1) {
        x0.extraHostAddresses = x1;
        return x1;
    }
}

