/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dahdi;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.SelectorProvider;
import org.mobicents.protocols.stream.api.StreamSelector;
import org.mobicents.ss7.hardware.dahdi.Selector;

public class Channel
implements Mtp1 {
    private static final String LIB_NAME = "mobicents-dahdi-linux";
    private int span;
    private int channelID;
    private int code;
    private String linkName;
    private int ioBufferSize = 32;
    protected int fd;
    private Object link;
    protected SelectorKey selectorKey;

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public void setChannelID(int channelID) {
        this.channelID = channelID;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public int getIOBufferSize() {
        return this.ioBufferSize;
    }

    public void setIOBufferSize(int bufferSize) {
        this.ioBufferSize = bufferSize;
    }

    public void open() {
        int zapid = 31 * (this.span - 1) + this.channelID;
        this.fd = this.openChannel(zapid, this.ioBufferSize);
    }

    public native int openChannel(int var1, int var2);

    public int read(byte[] buffer) throws IOException {
        int result = this.readData(this.fd, buffer, this.ioBufferSize);
        if (result == -1) {
            this.doUnregister(this.fd);
            this.close();
            int zapid = 31 * (this.span - 1) + this.channelID;
            this.fd = this.openChannel(zapid, this.ioBufferSize);
            this.doRegister(this.fd);
            return 0;
        }
        return result;
    }

    public native int readData(int var1, byte[] var2, int var3);

    public int write(byte[] buffer) throws IOException {
        this.writeData(this.fd, buffer, buffer.length);
        return buffer.length;
    }

    public native void writeData(int var1, byte[] var2, int var3);

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public void close() {
        this.closeChannel(this.fd);
    }

    public native void closeChannel(int var1);

    public String toString() {
        return Integer.toString(this.channelID);
    }

    public void setLink(Object link) {
        this.link = link;
    }

    public Object getLink() {
        return this.link;
    }

    protected void doRegister(StreamSelector selector) {
        this.doRegister(this.fd);
    }

    protected void doUnregister(StreamSelector selector) {
        this.doUnregister(this.fd);
    }

    public boolean isReadable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWriteable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SelectorProvider provider() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SelectorKey register(StreamSelector selector) throws IOException {
        return ((Selector)selector).register(this);
    }

    public void write(byte[] data, int len) throws IOException {
        this.writeData(this.fd, data, len);
    }

    public int read(ByteBuffer arg0) throws IOException {
        return 0;
    }

    public int write(ByteBuffer arg0) throws IOException {
        return 0;
    }

    static {
        try {
            System.loadLibrary(LIB_NAME);
            System.out.println("Loaded library mobicents-dahdi-linux");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

