/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.ADDInfo;
import org.mobicents.protocols.ss7.map.primitives.IMEIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class ADDInfoImpl
implements ADDInfo,
MAPAsnPrimitive {
    public static final int _TAG_imeisv = 0;
    public static final int _TAG_skipSubscriberDataUpdate = 1;
    public static final String _PrimitiveName = "ADDInfo";
    private IMEI imeisv;
    private boolean skipSubscriberDataUpdate;

    public ADDInfoImpl() {
    }

    public ADDInfoImpl(IMEI imeisv, boolean skipSubscriberDataUpdate) {
        this.imeisv = imeisv;
        this.skipSubscriberDataUpdate = skipSubscriberDataUpdate;
    }

    public IMEI getImeisv() {
        return this.imeisv;
    }

    public boolean getSkipSubscriberDataUpdate() {
        return this.skipSubscriberDataUpdate;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ADDInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ADDInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ADDInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ADDInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imeisv = null;
        this.skipSubscriberDataUpdate = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
                        throw new MAPParsingComponentException("Error while decoding ADDInfo.imeisv: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imeisv = new IMEIImpl();
                    ((IMEIImpl)this.imeisv).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ADDInfo.skipSubscriberDataUpdate: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.skipSubscriberDataUpdate = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new MAPParsingComponentException("Error while decoding ADDInfo: Needs at least 1 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ADDInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imeisv == null) {
                throw new MAPException("imeisv parameter must not be null");
            }
            ((IMEIImpl)this.imeisv).encodeAll(asnOs, 2, 0);
            if (this.skipSubscriberDataUpdate) {
                asnOs.writeNull(2, 1);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ADDInfo: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ADDInfo: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imeisv != null) {
            sb.append("imeisv=");
            sb.append(this.imeisv.toString());
            sb.append(", ");
        }
        if (this.skipSubscriberDataUpdate) {
            sb.append("skipSubscriberDataUpdate, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

