/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.dialog;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextNameImpl;

public class MAPRefuseInfoImpl
implements MAPAsnPrimitive {
    public static final int MAP_REFUSE_INFO_TAG = 3;
    protected static final int REFUSE_TAG_CLASS = 2;
    protected static final boolean REFUSE_TAG_PC_CONSTRUCTED = false;
    protected static final boolean REFUSE_TAG_PC_PRIMITIVE = true;
    private Reason reason;
    private MAPExtensionContainer extensionContainer;
    private ApplicationContextName alternativeAcn;

    public Reason getReason() {
        return this.reason;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public ApplicationContextName getAlternativeAcn() {
        return this.alternativeAcn;
    }

    public void setReason(Reason reason) {
        this.reason = reason;
    }

    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    public void setAlternativeAcn(ApplicationContextName alternativeAcn) {
        this.alternativeAcn = alternativeAcn;
    }

    public int getTag() throws MAPException {
        return 3;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAP-RefuseInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAP-RefuseInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAP-RefuseInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAP-RefuseInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.reason = null;
        this.alternativeAcn = null;
        this.extensionContainer = null;
        AsnInputStream localAis = ais.readSequenceStreamData(length);
        int tag = localAis.readTag();
        if (tag != 10 || localAis.getTagClass() != 0) {
            throw new MAPParsingComponentException("Error decoding MAP-RefuseInfo.Reason: bad tag or tagClass", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int reasonCode = (int)localAis.readInteger();
        this.reason = Reason.getReason(reasonCode);
        block7: while (localAis.available() > 0) {
            tag = localAis.readTag();
            switch (localAis.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(localAis);
                            continue block7;
                        }
                        case 6: {
                            this.alternativeAcn = new ApplicationContextNameImpl();
                            long[] oid = localAis.readObjectIdentifier();
                            this.alternativeAcn.setOid(oid);
                            continue block7;
                        }
                    }
                    localAis.advanceElement();
                    continue block7;
                }
            }
            localAis.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, 3);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPRefuseInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOS) throws MAPException {
        if (this.reason == null) {
            throw new MAPException("Error decoding MAP-RefuseInfo: Reason field must not be empty");
        }
        try {
            asnOS.writeInteger(0, 10, this.reason.getCode());
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOS);
            }
            if (this.alternativeAcn != null) {
                asnOS.writeObjectIdentifier(this.alternativeAcn.getOid());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPRefuseInfo: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPRefuseInfo: " + e.getMessage(), e);
        }
    }
}

