/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AsStateListener;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsInactToAct
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsInactToAct.class);
    private AsImpl asImpl = null;
    private FSM fsm;
    private int lbCount = 0;

    public THLocalAsInactToAct(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            AspState aspState;
            FSM aspPeerFSM;
            AspImpl remAspImpl;
            FastCollection.Record end;
            FastCollection.Record n;
            if (this.asImpl.getTrafficModeType().getMode() == 3) {
                return false;
            }
            if (this.asImpl.getTrafficModeType().getMode() == 2) {
                this.lbCount = this.asImpl.getMinAspActiveForLb();
                n = this.asImpl.appServerProcs.head();
                end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    aspPeerFSM = remAspImpl.getPeerFSM();
                    aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.ACTIVE) continue;
                    --this.lbCount;
                }
                if (this.lbCount > 0) {
                    return false;
                }
            }
            if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                n = this.asImpl.appServerProcs.head();
                end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    aspPeerFSM = remAspImpl.getPeerFSM();
                    aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.INACTIVE && aspState != AspState.ACTIVE) continue;
                    Notify msg = this.createNotify(remAspImpl);
                    remAspImpl.getAspFactory().write(msg);
                }
            }
            if (this.asImpl.getExchangeType() == ExchangeType.SE) {
                FastSet<AsStateListener> asStateListeners = this.asImpl.getAsStateListeners();
                FastCollection.Record r = asStateListeners.head();
                FastCollection.Record end2 = asStateListeners.tail();
                while ((r = r.getNext()) != end2) {
                    AsStateListener asAsStateListener = asStateListeners.valueOf(r);
                    try {
                        asAsStateListener.onAsActive(this.asImpl);
                    }
                    catch (Exception e) {
                        logger.error(String.format("Error while calling AsStateListener=%s onAsActive method for As=%s", asAsStateListener, this.asImpl));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to INACTIVE. %s", this.fsm.toString()), e);
            return false;
        }
    }

    private Notify createNotify(AspImpl remAsp) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(1, 3);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

