/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractInformationImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.RedirectReasonImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.InformationType;
import org.mobicents.protocols.ss7.isup.message.parameter.PerformingRedirectIndicator;
import org.mobicents.protocols.ss7.isup.message.parameter.RedirectReason;

public class PerformingRedirectIndicatorImpl
extends AbstractInformationImpl
implements PerformingRedirectIndicator {
    private List<RedirectReason> reasons = new ArrayList<RedirectReason>();

    public PerformingRedirectIndicatorImpl() {
        super(InformationType.PerformingRedirectIndicator);
        this.tag = 3;
    }

    public void setReason(RedirectReason ... reasons) {
        this.reasons.clear();
        if (reasons == null) {
            return;
        }
        for (RedirectReason pr : reasons) {
            if (pr == null) continue;
            this.reasons.add(pr);
        }
    }

    public RedirectReason[] getReason() {
        return this.reasons.toArray(new RedirectReason[this.reasons.size()]);
    }

    byte[] encode() throws ParameterException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (RedirectReason pr : this.reasons) {
            RedirectReasonImpl ai = (RedirectReasonImpl)pr;
            try {
                baos.write(ai.encode());
            }
            catch (IOException e) {
                throw new ParameterException(e);
            }
        }
        return baos.toByteArray();
    }

    void decode(byte[] data) throws ParameterException {
        for (int index = 0; index < data.length; ++index) {
            byte b = data[index];
            RedirectReasonImpl pr = new RedirectReasonImpl();
            pr.setRedirectReason((byte)(b & 0x7F));
            if ((b & 0x80) == 0) {
                if (index + 1 == data.length) {
                    throw new ParameterException("Extension bit incicates more bytes, but we ran out of them!");
                }
                b = data[++index];
                pr.setRedirectPossibleAtPerformingExchange((byte)(b & 7));
            }
            this.reasons.add(pr);
        }
    }
}

