/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.Encodable;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInstructionIndicators;

public class ParameterCompatibilityInstructionIndicatorsImpl
implements ParameterCompatibilityInstructionIndicators,
Encodable {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private byte parameterCode;
    private boolean transitAtIntermediateExchangeIndicator;
    private boolean releaseCallindicator;
    private boolean sendNotificationIndicator;
    private boolean discardMessageIndicator;
    private boolean discardParameterIndicator;
    private int passOnNotPossibleIndicator;
    private int bandInterworkingIndicator;
    private boolean secondOctetPresenet;
    private byte[] raw;
    private boolean useAsRaw;

    public ParameterCompatibilityInstructionIndicatorsImpl(byte code, byte[] b) throws ParameterException {
        this.parameterCode = code;
        this.decode(b);
    }

    public ParameterCompatibilityInstructionIndicatorsImpl() {
    }

    public ParameterCompatibilityInstructionIndicatorsImpl(byte code, byte[] b, boolean userAsRaw) throws ParameterException {
        this.parameterCode = code;
        this.raw = b;
        this.useAsRaw = userAsRaw;
        if (!userAsRaw) {
            this.decode(b);
        }
    }

    public ParameterCompatibilityInstructionIndicatorsImpl(boolean transitAtIntermediateExchangeIndicator, boolean releaseCallindicator, boolean sendNotificationIndicator, boolean discardMessageIndicator, boolean discardParameterIndicator, int passOnNotPossibleIndicator, boolean secondOctetPresenet) {
        this.transitAtIntermediateExchangeIndicator = transitAtIntermediateExchangeIndicator;
        this.releaseCallindicator = releaseCallindicator;
        this.sendNotificationIndicator = sendNotificationIndicator;
        this.discardMessageIndicator = discardMessageIndicator;
        this.discardParameterIndicator = discardParameterIndicator;
        this.setPassOnNotPossibleIndicator(passOnNotPossibleIndicator);
        this.secondOctetPresenet = secondOctetPresenet;
    }

    public ParameterCompatibilityInstructionIndicatorsImpl(boolean transitAtIntermediateExchangeIndicator, boolean releaseCallindicator, boolean sendNotificationIndicator, boolean discardMessageIndicator, boolean discardParameterIndicator, int passOnNotPossibleIndicator, int bandInterworkingIndicator) {
        this.transitAtIntermediateExchangeIndicator = transitAtIntermediateExchangeIndicator;
        this.releaseCallindicator = releaseCallindicator;
        this.sendNotificationIndicator = sendNotificationIndicator;
        this.discardMessageIndicator = discardMessageIndicator;
        this.discardParameterIndicator = discardParameterIndicator;
        this.setPassOnNotPossibleIndicator(passOnNotPossibleIndicator);
        this.setBandInterworkingIndicator(bandInterworkingIndicator);
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 1) {
            throw new ParameterException("byte[] must  not be null and length must  be greater than  0");
        }
        int index = 0;
        byte v = b[index];
        try {
            do {
                v = b[index];
                if (index == 0) {
                    this.transitAtIntermediateExchangeIndicator = (v & 1) == 1;
                    this.releaseCallindicator = (v >> 1 & 1) == 1;
                    this.sendNotificationIndicator = (v >> 2 & 1) == 1;
                    this.discardMessageIndicator = (v >> 3 & 1) == 1;
                    this.discardParameterIndicator = (v >> 4 & 1) == 1;
                    this.passOnNotPossibleIndicator = v >> 5 & 3;
                } else {
                    if (index != 1) break;
                    this.setBandInterworkingIndicator(v & 3);
                }
                ++index;
            } while ((v >> 7 & 1) != 0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            aioobe.printStackTrace();
            throw new ParameterException("Failed to parse passed value due to wrong encoding.", aioobe);
        }
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        if (this.useAsRaw) {
            return this.raw;
        }
        byte[] b = null;
        if (this.secondOctetPresenet) {
            b = new byte[2];
            b[1] = (byte)(this.bandInterworkingIndicator & 3);
            b[0] = -128;
        } else {
            b = new byte[]{(byte)(b[0] | (this.transitAtIntermediateExchangeIndicator ? (byte)1 : 0))};
        }
        b[0] = (byte)(b[0] | (this.releaseCallindicator ? 1 : 0) << 1);
        b[0] = (byte)(b[0] | (this.sendNotificationIndicator ? 1 : 0) << 2);
        b[0] = (byte)(b[0] | (this.discardMessageIndicator ? 1 : 0) << 3);
        b[0] = (byte)(b[0] | (this.discardParameterIndicator ? 1 : 0) << 4);
        b[0] = (byte)(b[0] | this.passOnNotPossibleIndicator << 5);
        return b;
    }

    public void setParamerterCode(byte code) {
        this.parameterCode = code;
    }

    public byte getParameterCode() {
        return this.parameterCode;
    }

    public boolean isTransitAtIntermediateExchangeIndicator() {
        return this.transitAtIntermediateExchangeIndicator;
    }

    public void setTransitAtIntermediateExchangeIndicator(boolean transitAtIntermediateExchangeIndicator) {
        this.transitAtIntermediateExchangeIndicator = transitAtIntermediateExchangeIndicator;
    }

    public boolean isReleaseCallIndicator() {
        return this.releaseCallindicator;
    }

    public void setReleaseCallIndicator(boolean releaseCallindicator) {
        this.releaseCallindicator = releaseCallindicator;
    }

    public boolean isSendNotificationIndicator() {
        return this.sendNotificationIndicator;
    }

    public void setSendNotificationIndicator(boolean sendNotificationIndicator) {
        this.sendNotificationIndicator = sendNotificationIndicator;
    }

    public boolean isDiscardMessageIndicator() {
        return this.discardMessageIndicator;
    }

    public void setDiscardMessageIndicator(boolean discardMessageIndicator) {
        this.discardMessageIndicator = discardMessageIndicator;
    }

    public boolean isDiscardParameterIndicator() {
        return this.discardParameterIndicator;
    }

    public void setDiscardParameterIndicator(boolean discardParameterIndicator) {
        this.discardParameterIndicator = discardParameterIndicator;
    }

    public int getPassOnNotPossibleIndicator() {
        return this.passOnNotPossibleIndicator;
    }

    public void setPassOnNotPossibleIndicator(int passOnNotPossibleIndicator2) {
        this.passOnNotPossibleIndicator = passOnNotPossibleIndicator2;
    }

    public int getBandInterworkingIndicator() {
        return this.bandInterworkingIndicator;
    }

    public void setBandInterworkingIndicator(int bandInterworkingIndicator) {
        this.bandInterworkingIndicator = bandInterworkingIndicator;
        this.secondOctetPresenet = true;
    }

    public boolean isSecondOctetPresent() {
        return this.secondOctetPresenet;
    }

    public void setSecondOctetPresent(boolean secondOctetPresenet) {
        this.secondOctetPresenet = secondOctetPresenet;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public boolean isUseAsRaw() {
        return this.useAsRaw;
    }

    public void setUseAsRaw(boolean useAsRaw) {
        this.useAsRaw = useAsRaw;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParameterCompatibilityInstructionIndicators [");
        sb.append("parameterCode=");
        sb.append(this.parameterCode);
        sb.append(", ");
        sb.append("transitAtIntermediateExchangeIndicator=");
        sb.append(this.transitAtIntermediateExchangeIndicator);
        sb.append(", ");
        sb.append("releaseCallindicator=");
        sb.append(this.releaseCallindicator);
        sb.append(", ");
        sb.append("sendNotificationIndicator=");
        sb.append(this.sendNotificationIndicator);
        sb.append(", ");
        sb.append("discardMessageIndicator=");
        sb.append(this.discardMessageIndicator);
        sb.append(", ");
        sb.append("discardParameterIndicator=");
        sb.append(this.discardParameterIndicator);
        sb.append(", ");
        sb.append("passOnNotPossibleIndicator=");
        sb.append(this.passOnNotPossibleIndicator);
        sb.append(", ");
        sb.append("bandInterworkingIndicator=");
        sb.append(this.bandInterworkingIndicator);
        sb.append(", ");
        sb.append("secondOctetPresenet=");
        sb.append(this.secondOctetPresenet);
        sb.append(", ");
        sb.append("useAsRaw=");
        sb.append(this.useAsRaw);
        if (this.raw != null) {
            sb.append(", ");
            sb.append("raw=");
            for (int i1 = 1; i1 < this.raw.length; ++i1) {
                sb.append(this.raw[i1]);
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

