/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.NAINumber;

public abstract class AbstractNAINumber
extends AbstractNumber
implements NAINumber {
    private static final String NATURE_OF_ADDRESS_INDICATOR = "natureOfAddresIndicator";
    private static final int DEFAULT_NATURE_OF_ADDRESS_INDICATOR = 0;
    protected int natureOfAddresIndicator;
    protected static final XMLFormat<AbstractNAINumber> ISUP_ABSTRACT_NAI_NUMBER_XML = new XMLFormat<AbstractNAINumber>(AbstractNAINumber.class){

        @Override
        public void read(XMLFormat.InputElement xml, AbstractNAINumber abstractNAINumber) throws XMLStreamException {
            AbstractNumber.ISUP_ABSTRACT_NUMBER_XML.read(xml, abstractNAINumber);
            abstractNAINumber.natureOfAddresIndicator = xml.getAttribute(AbstractNAINumber.NATURE_OF_ADDRESS_INDICATOR, 0);
        }

        @Override
        public void write(AbstractNAINumber abstractNAINumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractNumber.ISUP_ABSTRACT_NUMBER_XML.write(abstractNAINumber, xml);
            xml.setAttribute(AbstractNAINumber.NATURE_OF_ADDRESS_INDICATOR, abstractNAINumber.natureOfAddresIndicator);
        }
    };

    public AbstractNAINumber(byte[] representation) throws ParameterException {
        super(representation);
    }

    public AbstractNAINumber(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public AbstractNAINumber(int natureOfAddresIndicator, String address) {
        super(address);
        this.natureOfAddresIndicator = natureOfAddresIndicator;
    }

    public AbstractNAINumber() {
    }

    public int decode(byte[] b) throws ParameterException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        return this.decode(bis);
    }

    public int getNatureOfAddressIndicator() {
        return this.natureOfAddresIndicator;
    }

    public void setNatureOfAddresIndicator(int natureOfAddresIndicator) {
        this.natureOfAddresIndicator = natureOfAddresIndicator;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = this.natureOfAddresIndicator & 0x7F;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b);
        return 1;
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.natureOfAddresIndicator = b & 0x7F;
        return 1;
    }
}

