/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dahdi.oam;

import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.ss7.hardware.dahdi.oam.DahdiLink;
import org.mobicents.ss7.hardware.dahdi.oam.DahdiLinkset;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetFactory;

public class DahdiLinksetFactory
extends LinksetFactory {
    private static final String NAME = "dahdi";
    private static final String LINKSET_NAME = "dahdilinkset";
    private static final String LINK_NAME = "dahdilink";
    private Scheduler scheduler;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public String getName() {
        return NAME;
    }

    public Linkset createLinkset(String[] options) throws Exception {
        if (options.length != 10) {
            throw new Exception("Invalid Command");
        }
        String option = options[3];
        if (option.compareTo("opc") != 0) {
            return null;
        }
        int opc = Integer.parseInt(options[4]);
        if (options[5].compareTo("apc") != 0) {
            throw new Exception("Invalid Command");
        }
        int dpc = Integer.parseInt(options[6]);
        if (options[7].compareTo("ni") != 0) {
            throw new Exception("Invalid Command");
        }
        int ni = Integer.parseInt(options[8]);
        String name = options[9];
        if (name == null) {
            throw new Exception("Invalid Command");
        }
        DahdiLinkset currLinkSet = new DahdiLinkset(name, opc, dpc, ni);
        currLinkSet.setScheduler(this.scheduler);
        return currLinkSet;
    }

    public String getLinksetName() {
        return LINKSET_NAME;
    }

    public Class getLinksetClass() {
        return DahdiLinkset.class;
    }

    public String getLinkName() {
        return LINK_NAME;
    }

    public Class getLinkClass() {
        return DahdiLink.class;
    }
}

