/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.mtp.util;

public class MTPUtility {
    public static void copyBackRouteHeader(byte[] source, byte[] dest) {
        int thisPointCode = MTPUtility.getFromSif_DPC(source, 1);
        int remotePointCode = MTPUtility.getFromSif_OPC(source, 1);
        int sls = MTPUtility.getFromSif_SLS(source, 1);
        int si = MTPUtility.getFromSif_SI(source);
        int ssi = MTPUtility.getFromSif_SSI(source);
        MTPUtility.writeRoutingLabel(dest, si, ssi, sls, remotePointCode, thisPointCode);
    }

    public static final int getFromSif_DPC(byte[] sif, int shift) {
        int dpc = sif[0 + shift] & 0xFF | (sif[1 + shift] & 0x3F) << 8;
        return dpc;
    }

    public static final int getFromSif_OPC(byte[] sif, int shift) {
        int opc = (sif[1 + shift] & 0xC0) >> 6 | (sif[2 + shift] & 0xFF) << 2 | (sif[3 + shift] & 0xF) << 10;
        return opc;
    }

    public static final int getFromSif_SLS(byte[] sif, int shift) {
        int sls = (sif[3 + shift] & 0xF0) >>> 4;
        return sls;
    }

    public static final int getFromSif_SI(byte[] data) {
        int serviceIndicator = data[0] & 0xF;
        return serviceIndicator;
    }

    public static final int getFromSif_SSI(byte[] data) {
        int subserviceIndicator = data[0] >> 4 & 0xF;
        return subserviceIndicator;
    }

    public static void writeRoutingLabel(byte[] destination, int si, int ssi, int sls, int dpc, int opc) {
        destination[0] = (byte)((ssi & 0xF) << 4 | si & 0xF);
        destination[1] = (byte)dpc;
        destination[2] = (byte)(dpc >> 8 & 0x3F | (opc & 3) << 6);
        destination[3] = (byte)(opc >> 2);
        destination[4] = (byte)(opc >> 10 & 0xF | (sls & 0xF) << 4);
    }
}

