/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.PDPContext;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APNOIReplacement;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.GPRSSubscriptionData;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.PDPContextImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNOIReplacementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPRSSubscriptionDataImpl
extends SequenceBase
implements GPRSSubscriptionData {
    protected static final int _TAG_gprsDataList = 1;
    protected static final int _TAG_extContainer = 2;
    protected static final int _TAG_apnOiReplacement = 3;
    private boolean completeDataListIncluded = false;
    private ArrayList<PDPContext> gprsDataList = null;
    private MAPExtensionContainer extensionContainer = null;
    private APNOIReplacement apnOiReplacement = null;

    public GPRSSubscriptionDataImpl() {
        super("GPRSSubscriptionData");
    }

    public GPRSSubscriptionDataImpl(boolean completeDataListIncluded, ArrayList<PDPContext> gprsDataList, MAPExtensionContainer extensionContainer, APNOIReplacement apnOiReplacement) {
        super("GPRSSubscriptionData");
        this.completeDataListIncluded = completeDataListIncluded;
        this.gprsDataList = gprsDataList;
        this.extensionContainer = extensionContainer;
        this.apnOiReplacement = apnOiReplacement;
    }

    @Override
    public boolean getCompleteDataListIncluded() {
        return this.completeDataListIncluded;
    }

    @Override
    public ArrayList<PDPContext> getGPRSDataList() {
        return this.gprsDataList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public APNOIReplacement getApnOiReplacement() {
        return this.apnOiReplacement;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        PDPContextImpl pdpContext = null;
        this.completeDataListIncluded = false;
        this.gprsDataList = null;
        this.extensionContainer = null;
        this.apnOiReplacement = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block12: while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gprsDataList: parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.gprsDataList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad gprsDataList element tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                pdpContext = new PDPContextImpl();
                                pdpContext.decodeAll(ais2);
                                this.gprsDataList.add(pdpContext);
                            }
                            if (this.gprsDataList.size() <= 50 && this.gprsDataList.size() >= 1) continue block12;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter gprsDataList size must be from 1 to 50, found: " + this.gprsDataList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break;
                        }
                        case 3: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".apnOiReplacement: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.apnOiReplacement = new APNOIReplacementImpl();
                            ((APNOIReplacementImpl)this.apnOiReplacement).decodeAll(ais);
                            break;
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                    continue block12;
                }
                case 0: {
                    switch (tag) {
                        case 5: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".completeDataListIncluded: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.completeDataListIncluded = true;
                            break block0;
                        }
                    }
                    ais.advanceElement();
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
        }
        if (this.gprsDataList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": gprsDataList parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.gprsDataList == null || this.gprsDataList.size() > 50 || this.gprsDataList.size() < 1) {
            throw new MAPException("gprsDataList size must not be null and must be from 1 to 50, found: " + this.gprsDataList.size());
        }
        if (this.completeDataListIncluded) {
            try {
                asnOs.writeNull();
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding " + this._PrimitiveName + ".completeDataListIncluded: " + e.getMessage(), e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding " + this._PrimitiveName + ".completeDataListIncluded: " + e.getMessage(), e);
            }
        }
        try {
            asnOs.writeTag(2, false, 1);
            int pos = asnOs.StartContentDefiniteLength();
            for (PDPContext pdpContext : this.gprsDataList) {
                ((PDPContextImpl)pdpContext).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
        if (this.apnOiReplacement != null) {
            ((APNOIReplacementImpl)this.apnOiReplacement).encodeAll(asnOs, 2, 3);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GPRSSubscriptionData [");
        if (this.getCompleteDataListIncluded()) {
            sb.append("completeDataListIncluded, ");
        }
        if (this.gprsDataList != null) {
            sb.append("gprsDataList=[");
            boolean firstItem = true;
            for (PDPContext be : this.gprsDataList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.apnOiReplacement != null) {
            sb.append("apnOiReplacement=");
            sb.append(this.apnOiReplacement.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

