/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public abstract class OctetStringLength1Base
implements CAPAsnPrimitive {
    protected int data;
    protected String _PrimitiveName;

    public OctetStringLength1Base(String _PrimitiveName) {
        this._PrimitiveName = _PrimitiveName;
    }

    public OctetStringLength1Base(String _PrimitiveName, int data) {
        this(_PrimitiveName);
        this.data = data;
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException {
        if (length != 1) {
            throw new CAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain 1 octet. Contains: " + length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.data = ansIS.read();
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        asnOs.write(this.data);
    }

    public int hashCode() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringLength1Base other = (OctetStringLength1Base)obj;
        return this.data == other.data;
    }

    public String toString() {
        return this._PrimitiveName + " [Data=" + this.data + "]";
    }
}

