/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.mtp;

import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.FastHDLC;
import org.mobicents.protocols.ss7.mtp.HdlcState;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.ss7.mtp.Mtp2Buffer;
import org.mobicents.protocols.ss7.mtp.Mtp2Listener;
import org.mobicents.protocols.ss7.mtp.Mtp3;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.protocols.ss7.scheduler.Task;

public class Mtp2 {
    static final int MTP2_OUT_OF_SERVICE = 0;
    static final int MTP2_NOT_ALIGNED = 1;
    static final int MTP2_ALIGNED = 2;
    static final int MTP2_PROVING = 3;
    static final int MTP2_ALIGNED_READY = 4;
    static final int MTP2_INSERVICE = 5;
    private static final int T2_TIMEOUT = 50;
    private static final int T3_TIMEOUT = 10;
    private static final int T4_TIMEOUT_NORMAL = 82;
    private static final int T4_TIMEOUT_EMERGENCY = 5;
    private int T4_TIMEOUT = 82;
    private int T7_TIMEOUT = 20;
    private static final int T17_TIMEOUT = 15;
    private static final int[] fcstab = new int[]{0, 4489, 8978, 12955, 17956, 22445, 25910, 29887, 35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735, 4225, 264, 13203, 8730, 22181, 18220, 30135, 25662, 40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510, 8450, 12427, 528, 5017, 26406, 30383, 17460, 21949, 44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797, 12675, 8202, 4753, 792, 30631, 26158, 21685, 17724, 48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572, 16900, 21389, 24854, 28831, 1056, 5545, 10034, 14011, 52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859, 21125, 17164, 29079, 24606, 5281, 1320, 14259, 9786, 57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634, 25350, 29327, 16404, 20893, 9506, 13483, 1584, 6073, 61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921, 29575, 25102, 20629, 16668, 13731, 9258, 5809, 1848, 65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696, 33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623, 2112, 6601, 11090, 15067, 20068, 24557, 28022, 31999, 38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398, 6337, 2376, 15315, 10842, 24293, 20332, 32247, 27774, 42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685, 10562, 14539, 2640, 7129, 28518, 32495, 19572, 24061, 46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460, 14787, 10314, 6865, 2904, 32743, 28270, 23797, 19836, 50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747, 19012, 23501, 26966, 30943, 3168, 7657, 12146, 16123, 54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522, 23237, 19276, 31191, 26718, 7393, 3432, 16371, 11898, 59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809, 27462, 31439, 18516, 23005, 11618, 15595, 3696, 8185, 63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584, 31687, 27214, 22741, 18780, 15843, 11370, 7921, 3960};
    private static final int FRAME_STATUS_INDICATION_O = 0;
    private static final int FRAME_STATUS_INDICATION_N = 1;
    private static final int FRAME_STATUS_INDICATION_E = 2;
    private static final int FRAME_STATUS_INDICATION_OS = 3;
    private static final int FRAME_STATUS_INDICATION_PO = 4;
    private static final int FRAME_STATUS_INDICATION_B = 5;
    private static final int FRAME_FISU = 6;
    private static final String[] FRAME_NAMES = new String[]{"SIO", "SIN", "SIE", "SIOS", "SIPO", "SIPB", "FISU"};
    public static final int AERM_THRESHOLD_NORMAL = 4;
    public static final int AERM_THRESHOLD_EMERGENCY = 1;
    private static final String[] STATE_NAMES = new String[]{"OUT_OF_SERVICE", "NOT_ALIGNED", "ALIGNED", "PROVING", "ALIGNED_READY", "IN_SERVICE"};
    protected Mtp3.SLTMTest sltmTest;
    private Mtp1 channel;
    private int ioBufferSize;
    private int state;
    protected Mtp3 mtp3;
    private volatile boolean started;
    private FastHDLC hdlc = new FastHDLC();
    private HdlcState rxState = new HdlcState();
    private HdlcState txState = new HdlcState();
    private byte[] txBuffer;
    private byte[] rxBuffer;
    private Mtp2Buffer rxFrame = new Mtp2Buffer();
    private Mtp2Buffer txFrame;
    private Mtp2Buffer stateFrame = new Mtp2Buffer();
    private Mtp2Buffer nextStateFrame = new Mtp2Buffer();
    private boolean pendingLSSU = false;
    private int doCRC = 0;
    private int rxCRC = 65535;
    private int txCRC = 65535;
    private Mtp2Buffer[] transmissionBuffer = new Mtp2Buffer[128];
    private static final int _OFF_RTR = -1;
    private int retransmissionFSN = -1;
    private int retransmissionFSN_LastAcked = 0;
    private int retransmissionFSN_LastSent = 0;
    private int sendFIB;
    private int sendBSN;
    private int sendBIB;
    private int bsnErrors = 0;
    protected String name;
    private static final int PROVING_ATTEMPTS_THRESHOLD = 5;
    private int aermThreshold;
    private boolean aermEnabled;
    private boolean emergency = false;
    private int provingAttempts;
    private boolean futureProving;
    private int nCount;
    private int dCount;
    private int eCount;
    protected int sls = -1;
    protected Mtp2Listener mtp2Listener = null;
    private static final Logger ROOT_LOGGER = Logger.getLogger(Mtp2.class);
    private final Logger logger;
    private Scheduler scheduler;
    private T2Action t2Action;
    private T3Action t3Action;
    private T4Action t4Action;
    private T7Action t7Action;
    private T17Action t17Action;

    public Mtp2(String name, Mtp1 channel, Scheduler scheduler) {
        this.name = name;
        this.logger = Logger.getLogger(name);
        this.channel = channel;
        channel.setLink(this);
        this.sls = channel.getCode();
        this.scheduler = scheduler;
        if (scheduler != null) {
            this.t2Action = new T2Action(scheduler);
            this.t3Action = new T3Action(scheduler);
            this.t4Action = new T4Action(scheduler);
            this.t7Action = new T7Action(scheduler);
            this.t17Action = new T17Action(scheduler);
        }
        this.hdlc.fasthdlc_precalc();
        this.hdlc.fasthdlc_init(this.rxState);
        this.hdlc.fasthdlc_init(this.txState);
        this.aermThreshold = 4;
        for (int i = 0; i < this.transmissionBuffer.length; ++i) {
            this.transmissionBuffer[i] = new Mtp2Buffer();
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        if (this.t2Action == null && scheduler != null) {
            this.t2Action = new T2Action(scheduler);
            this.t3Action = new T3Action(scheduler);
            this.t4Action = new T4Action(scheduler);
            this.t7Action = new T7Action(scheduler);
            this.t17Action = new T17Action(scheduler);
        }
    }

    public Mtp2Listener getMtp2Listener() {
        return this.mtp2Listener;
    }

    public void setMtp2Listener(Mtp2Listener mtp2Listener) {
        this.mtp2Listener = mtp2Listener;
    }

    public boolean isEmergency() {
        return this.emergency;
    }

    public void setEmergency(boolean emergency) {
        this.emergency = emergency;
    }

    public int getState() {
        return this.state;
    }

    public void setLayer1(Mtp1 layer1) {
        this.channel = layer1;
    }

    public Mtp1 getLayer1() {
        return this.channel;
    }

    public String getName() {
        return this.name;
    }

    public int getSls() {
        return this.sls;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSls(int sls) {
        this.sls = sls;
    }

    public void start() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("Layer1 is not set in Layer2!");
        }
        if (this.mtp3 == null) {
            throw new IllegalStateException("Layer3 is not set in Layer2!");
        }
        if (this.started) {
            throw new IllegalStateException("Link already running");
        }
        this.ioBufferSize = this.channel.getIOBufferSize();
        this.rxBuffer = new byte[this.ioBufferSize];
        this.txBuffer = new byte[this.ioBufferSize];
        this.channel.open();
        this.mtp3.registerLink(this);
        this.started = true;
        this.reset();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Is out of service now. Starting.");
        }
        this.txFrame = this.stateFrame;
        this.setState(0);
        this.queueLSSU(3);
        this.processTx(this.ioBufferSize);
        this.startInitialAlignment();
    }

    public void stop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stopping link.");
        }
        this.mtp3.unregisterLink(this);
        this.started = false;
        this.reset();
        this.channel.close();
    }

    private void startInitialAlignment() {
        this.startInitialAlignment(true);
    }

    protected void startInitialAlignment(boolean resetTxOffset) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("(%s) Starting initial alignment", this.name));
        }
        if (resetTxOffset) {
            this.txFrame.offset = 3;
        }
        this.reset();
        this.setState(1);
        this.start_T2();
    }

    private void setState(int newState) {
        if (this.state == newState) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("State changed in link. " + STATE_NAMES[this.state] + " --> " + STATE_NAMES[newState]);
        }
        this.state = newState;
    }

    private void reset() {
        this.nCount = 0;
        this.eCount = 0;
        this.dCount = 0;
        this.sendFIB = 1;
        this.sendBSN = 127;
        this.sendBIB = 1;
        this.retransmissionFSN = -1;
        this.retransmissionFSN_LastAcked = 127;
        this.retransmissionFSN_LastSent = 127;
    }

    public void fail() {
        this.cleanupTimers();
        this.reset();
        this.setState(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("(%s) Link Out of service", this.name));
        }
        this.start_T17();
    }

    public boolean send(byte[] msg, int len) {
        if (this.state != 5) {
            return false;
        }
        int possibleFSN = Mtp2.NEXT_FSN(this.retransmissionFSN_LastSent);
        if (possibleFSN == this.retransmissionFSN_LastAcked) {
            return false;
        }
        this.transmissionBuffer[possibleFSN].frame[0] = 0;
        this.transmissionBuffer[possibleFSN].frame[1] = 0;
        this.transmissionBuffer[possibleFSN].frame[2] = (byte)(len >= 63 ? 63 : len);
        System.arraycopy(msg, 0, this.transmissionBuffer[possibleFSN].frame, 3, len);
        this.transmissionBuffer[possibleFSN].len = 3 + len;
        this.retransmissionFSN_LastSent = possibleFSN;
        if (this.retransmissionFSN == -1) {
            this.retransmissionFSN = possibleFSN;
        }
        this.start_T7();
        return true;
    }

    private void queueLSSU(int indicator) {
        if (this.txFrame != null && this.txFrame.len != this.txFrame.offset) {
            this.fillLSSUBuffer(this.nextStateFrame, indicator);
            this.pendingLSSU = true;
        } else {
            this.txFrame = this.stateFrame;
            this.fillLSSUBuffer(this.txFrame, indicator);
        }
    }

    private void fillLSSUBuffer(Mtp2Buffer b, int indicator) {
        b.len = 4;
        b.offset = 0;
        b.frame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
        b.frame[1] = (byte)(this.retransmissionFSN_LastSent | this.sendFIB << 7);
        b.frame[2] = 1;
        b.frame[3] = (byte)indicator;
    }

    private void queueFISU() {
        this.txFrame.len = 3;
        this.txFrame = this.stateFrame;
        this.txFrame.frame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
        this.txFrame.frame[1] = (byte)(this.retransmissionFSN_LastSent | this.sendFIB << 7);
        this.txFrame.frame[2] = 0;
        this.txFrame.offset = 0;
    }

    private void queueNextFrame() {
        if (this.state != 5 && this.pendingLSSU) {
            this.txFrame = this.nextStateFrame;
            this.pendingLSSU = false;
        } else {
            switch (this.state) {
                case 0: {
                    this.queueLSSU(3);
                    break;
                }
                case 1: {
                    this.queueLSSU(0);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.emergency) {
                        this.queueLSSU(2);
                        break;
                    }
                    this.queueLSSU(1);
                    break;
                }
                default: {
                    if (this.retransmissionFSN != -1) {
                        Mtp2Buffer buffer;
                        this.txFrame = buffer = this.transmissionBuffer[this.retransmissionFSN];
                        this.txFrame.offset = 0;
                        this.txFrame.frame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
                        this.txFrame.frame[1] = (byte)(this.retransmissionFSN | this.sendFIB << 7);
                        this.retransmissionFSN = this.retransmissionFSN == this.retransmissionFSN_LastSent ? -1 : Mtp2.NEXT_FSN(this.retransmissionFSN);
                        return;
                    }
                    this.queueFISU();
                }
            }
        }
    }

    public static final int PPP_FCS(int fcs, int c) {
        return fcs >> 8 ^ fcstab[(fcs ^ c) & 0xFF];
    }

    private void processLssu() {
        int type = this.rxFrame.frame[3] & 7;
        block0 : switch (this.state) {
            case 1: {
                switch (type) {
                    case 0: 
                    case 1: {
                        this.stop_T2();
                        if (this.emergency) {
                            this.T4_TIMEOUT = 5;
                            this.queueLSSU(2);
                        } else {
                            this.T4_TIMEOUT = 82;
                            this.queueLSSU(1);
                        }
                        this.start_T3();
                        this.setState(2);
                        break block0;
                    }
                    case 2: {
                        this.stop_T2();
                        this.T4_TIMEOUT = 5;
                        if (this.emergency) {
                            this.queueLSSU(2);
                        } else {
                            this.queueLSSU(1);
                        }
                        this.start_T3();
                        this.setState(2);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (type) {
                    case 2: {
                        this.T4_TIMEOUT = 5;
                    }
                    case 1: {
                        this.stop_T3();
                        if (this.T4_TIMEOUT == 5) {
                            this.aermThreshold = 1;
                        }
                        this.startAERM();
                        this.start_T4();
                        this.provingAttempts = 0;
                        this.futureProving = false;
                        this.setState(3);
                        break block0;
                    }
                    case 3: {
                        this.stop_T3();
                        this.alignmentNotPossible("Receievd SIOS in state ALIGNED");
                        this.emergency = false;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (type) {
                    case 0: {
                        this.stop_T4();
                        this.stopAERM();
                        this.start_T3();
                        this.setState(2);
                        break block0;
                    }
                    case 2: {
                        if (this.T4_TIMEOUT == 5) {
                            return;
                        }
                        this.stop_T4();
                        this.stopAERM();
                        this.aermThreshold = 1;
                        this.startAERM();
                        this.futureProving = false;
                        this.start_T4();
                        break block0;
                    }
                    case 3: {
                        this.stop_T4();
                        this.alignmentNotPossible("Received SIOS in state PROVING");
                        this.stopAERM();
                        this.emergency = false;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (type) {
                    case 0: {
                        this.alignmentNotPossible("Received SIO in state ALIGNED_READY");
                        break;
                    }
                    case 3: {
                        this.alignmentNotPossible("Received SIOS in state ALIGNED_READY");
                    }
                }
                break;
            }
            case 5: {
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.alignmentNotPossible("Received " + FRAME_NAMES[type] + " in state IN_SERVICE");
                        break;
                    }
                    case 3: {
                        this.alignmentNotPossible("Received SIOS in state IN_SERVICE");
                    }
                }
                break;
            }
        }
    }

    private void processMSU(int len) {
        if (this.mtp3 != null) {
            this.mtp3.onMessage(this.rxFrame, this);
        }
    }

    private void processFrame() {
        int bsn = this.rxFrame.frame[0] & 0x7F;
        int bib = this.rxFrame.frame[0] >> 7 & 1;
        int fsn = this.rxFrame.frame[1] & 0x7F;
        int fib = this.rxFrame.frame[1] >> 7 & 1;
        int li = this.rxFrame.frame[2] & 0x3F;
        if (li + 3 > this.rxFrame.len) {
            return;
        }
        if (li == 1 || li == 2) {
            this.processLssu();
            return;
        }
        if (this.state != 5) {
            switch (this.state) {
                case 3: {
                    if (!this.futureProving) break;
                    this.startAERM();
                    this.futureProving = false;
                    this.start_T4();
                    break;
                }
                case 4: {
                    this.eCount = 0;
                    this.dCount = 0;
                    this.stop_T7();
                    this.sendFIB = bib;
                    this.sendBSN = fsn;
                    this.sendBIB = fib;
                    this.retransmissionFSN_LastAcked = bsn;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("(%s) MTP now IN_SERVICE, Notifing layer 3", this.name));
                    }
                    this.setState(5);
                    this.mtp3.linkInService(this);
                }
            }
        }
        if (this.retransmissionFSN_LastAcked <= this.retransmissionFSN_LastSent && (bsn < this.retransmissionFSN_LastAcked || bsn > this.retransmissionFSN_LastSent) || this.retransmissionFSN_LastAcked > this.retransmissionFSN_LastSent && bsn < this.retransmissionFSN_LastAcked && bsn > this.retransmissionFSN_LastSent) {
            ++this.bsnErrors;
            if (this.bsnErrors > 2) {
                this.bsnErrors = 0;
                this.mtp3.linkFailed(this);
                this.alignmentBroken("Broken BSN constrains: fsn_lasAcked = " + this.retransmissionFSN_LastAcked + ", fsn_LastSent = " + this.retransmissionFSN_LastSent + ", bsn = " + bsn);
            }
            return;
        }
        this.bsnErrors = 0;
        if (bib == this.sendFIB) {
            if (bsn != this.retransmissionFSN_LastAcked) {
                this.stop_T7();
                this.retransmissionFSN_LastAcked = bsn;
                if (this.retransmissionFSN_LastAcked != this.retransmissionFSN_LastSent) {
                    this.start_T7();
                }
            }
        } else {
            this.sendFIB = bib;
            this.retransmissionFSN = bsn == this.retransmissionFSN_LastSent ? -1 : Mtp2.NEXT_FSN(bsn);
        }
        if (li == 0) {
            if (fsn != this.sendBSN && fib == this.sendBIB) {
                this.sendBIB = Mtp2.NEXT_INDICATOR(this.sendBIB);
            }
        } else {
            if (fsn == this.sendBSN) {
                return;
            }
            if (fsn == Mtp2.NEXT_FSN(this.sendBSN)) {
                if (fib != this.sendBIB) {
                    return;
                }
            } else {
                if (fib == this.sendBIB) {
                    this.sendBIB = Mtp2.NEXT_INDICATOR(this.sendBIB);
                }
                return;
            }
            this.sendBSN = fsn;
            this.processMSU(li);
        }
    }

    private void processRx(byte[] buff, int len) {
        int i = 0;
        block5: while (i < len) {
            while (this.rxState.bits <= 24 && i < len) {
                int b = buff[i++] & 0xFF;
                this.hdlc.fasthdlc_rx_load_nocheck(this.rxState, b);
                if (this.rxState.state != 0) continue;
                this.nCount = (this.nCount + 1) % 16;
                if (this.nCount != 0) continue;
                this.countError("on receive");
            }
            int res = this.hdlc.fasthdlc_rx_run(this.rxState);
            switch (res) {
                case 4096: {
                    this.countFrame();
                    if (this.rxFrame.len != 0) {
                        if (this.rxFrame.len < 5) {
                            this.countError("hdlc error, frame LI<5");
                        } else if (this.rxCRC == 61624) {
                            this.processFrame();
                        } else {
                            this.countError("hdlc complete, wrong terms.");
                        }
                    }
                    this.rxFrame.len = 0;
                    this.rxCRC = 65535;
                    continue block5;
                }
                case 8192: {
                    this.rxCRC = 65535;
                    this.rxFrame.len = 0;
                    this.countFrame();
                    this.countError("hdlc discard.");
                    continue block5;
                }
                case 16384: {
                    this.rxFrame.len = 0;
                    continue block5;
                }
            }
            if (this.rxFrame.len > 279) {
                this.rxState.state = 0;
                this.rxFrame.len = 0;
                this.rxCRC = 65535;
                this.eCount = 0;
                this.countFrame();
                this.countError("Overlong MTP frame, entering octet mode on link '" + this.name + "'");
                continue;
            }
            this.rxFrame.frame[this.rxFrame.len++] = (byte)res;
            this.rxCRC = Mtp2.PPP_FCS(this.rxCRC, res & 0xFF);
        }
    }

    private void processTx(int bytesRead) throws IOException {
        for (int i = 0; i < bytesRead && i < this.ioBufferSize; ++i) {
            if (this.txState.bits < 8) {
                if (this.doCRC == 0 && this.txFrame.offset < this.txFrame.len) {
                    int data = this.txFrame.frame[this.txFrame.offset++] & 0xFF;
                    this.hdlc.fasthdlc_tx_load(this.txState, data);
                    this.txCRC = Mtp2.PPP_FCS(this.txCRC, data);
                    if (this.txFrame.offset == this.txFrame.len) {
                        this.doCRC = 1;
                        this.txCRC ^= 0xFFFF;
                    }
                } else if (this.doCRC == 1) {
                    this.hdlc.fasthdlc_tx_load_nocheck(this.txState, this.txCRC & 0xFF);
                    this.doCRC = 2;
                } else if (this.doCRC == 2) {
                    this.hdlc.fasthdlc_tx_load_nocheck(this.txState, this.txCRC >> 8 & 0xFF);
                    this.doCRC = 0;
                } else {
                    this.queueNextFrame();
                    this.txFrame.offset = 0;
                    this.txCRC = 65535;
                    this.hdlc.fasthdlc_tx_frame_nocheck(this.txState);
                }
            }
            this.txBuffer[i] = (byte)this.hdlc.fasthdlc_tx_run_nocheck(this.txState);
        }
    }

    public void doRead() {
        if (this.started) {
            try {
                int bytesRead = this.channel.read(this.rxBuffer);
                if (bytesRead > 0) {
                    this.processRx(this.rxBuffer, bytesRead);
                }
            }
            catch (Exception e) {
                if (this.logger.isEnabledFor(Level.ERROR)) {
                    this.logger.error(String.format("(%s) Can not read data from channel", this.name), e);
                }
                this.setState(0);
                this.mtp3.linkFailed(this);
            }
        }
    }

    public void doWrite() {
        if (!this.started) {
            return;
        }
        try {
            this.processTx(this.ioBufferSize);
            this.channel.write(this.txBuffer, this.ioBufferSize);
        }
        catch (Exception e) {
            if (this.logger.isEnabledFor(Level.ERROR)) {
                this.logger.error(String.format("(%s) Can not write data to channel", this.name), e);
            }
            this.setState(0);
            this.mtp3.linkFailed(this);
        }
    }

    private void stopAERM() {
        this.aermEnabled = false;
    }

    private void startAERM() {
        this.eCount = 0;
        this.nCount = 0;
        this.aermEnabled = true;
    }

    private void alignmentNotPossible(String cause) {
        this.cleanupTimers();
        this.reset();
        if (this.state == 5 && this.mtp3 != null) {
            this.mtp3.linkFailed(this);
        }
        this.setState(0);
        this.start_T17();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("(%s) Alignment not possible, initiating T17 for restart. Cause: %s", this.name, cause));
        }
    }

    private void alignmentBroken(String cause) {
        this.cleanupTimers();
        this.reset();
        if (this.state == 5 && this.mtp3 != null) {
            this.mtp3.linkFailed(this);
        }
        this.setState(0);
        this.start_T17();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Alignment broken, initiating T17 for restart. Cause: " + cause);
        }
    }

    private void cleanupTimers() {
        this.stop_T2();
        this.stop_T3();
        this.stop_T4();
        this.stop_T7();
        this.stop_T17();
    }

    private void alignmentComplete() {
        this.stop_T2();
        this.stop_T3();
        this.stop_T4();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("(%s) Aligned ready", this.name));
        }
        this.setState(4);
    }

    private void countError(String info) {
        ++this.eCount;
        switch (this.state) {
            case 4: 
            case 5: {
                if (this.eCount < 64) break;
                if (this.mtp3 != null) {
                    this.mtp3.linkFailed(this);
                }
                this.setState(0);
                break;
            }
            case 3: {
                if (!this.aermEnabled || this.eCount < this.aermThreshold) break;
                ++this.provingAttempts;
                if (this.provingAttempts < 5) {
                    this.futureProving = true;
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn("Exceeded AERM threshold[ " + this.aermThreshold + " ] errors[ " + this.eCount + " ], proving attempts[ " + this.provingAttempts + " ], continue...");
                    }
                    return;
                }
                this.alignmentNotPossible("Exceeded AERM threshold[" + this.aermThreshold + "] errors[" + this.eCount + "], proving attempts[" + this.provingAttempts + "]");
                this.stop_T3();
                this.emergency = false;
                this.stopAERM();
            }
        }
    }

    private void countFrame() {
        if (this.state == 4 || this.state == 5) {
            this.dCount = (this.dCount + 1) % 256;
            if (this.dCount == 0 && this.eCount > 0) {
                --this.eCount;
            }
        }
    }

    private void start_T2() {
        this.stop_T2();
        this.t2Action.start();
    }

    private void stop_T2() {
        this.t2Action.cancel();
    }

    private void start_T3() {
        this.stop_T3();
        this.t3Action.start();
    }

    private void stop_T3() {
        this.t3Action.cancel();
    }

    private void start_T4() {
        this.stop_T4();
        this.t4Action.start();
    }

    private void stop_T4() {
        this.t4Action.cancel();
    }

    private void start_T7() {
        this.stop_T7();
        this.t7Action.start();
    }

    private void stop_T7() {
        this.t7Action.cancel();
    }

    public void start_T17() {
        this.stop_T17();
        this.t17Action.start();
    }

    public void stop_T17() {
        this.t17Action.cancel();
    }

    public boolean isT17() {
        return this.t17Action.isActive();
    }

    private static int NEXT_FSN(int x) {
        return ((x & 0x7F) + 1) % 128;
    }

    private static int NEXT_INDICATOR(int x) {
        return (x + 1) % 2;
    }

    private class T17Action
    extends Task {
        private int ttl;
        private boolean initial;

        public T17Action(Scheduler scheduler) {
            super(scheduler);
            this.initial = true;
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = 15;
            this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            Mtp2.this.logger.info(String.format("(%s) Restarting initial alignment", Mtp2.this.name));
            Mtp2.this.stop_T17();
            if (Mtp2.this.state == 0) {
                Mtp2.this.startInitialAlignment(this.initial);
            }
            if (this.initial) {
                this.initial = false;
            }
            return 0L;
        }
    }

    private class T7Action
    extends Task {
        private int ttl;

        public T7Action(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = Mtp2.this.T7_TIMEOUT;
            this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            Mtp2.this.stop_T7();
            return 0L;
        }
    }

    private class T4Action
    extends Task {
        private int ttl;

        public T4Action(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = Mtp2.this.T4_TIMEOUT;
            this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            Mtp2.this.stop_T4();
            int tmpState = Mtp2.this.state;
            if (tmpState == 3) {
                if (Mtp2.this.futureProving) {
                    Mtp2.this.startAERM();
                    Mtp2.this.futureProving = false;
                    Mtp2.this.start_T4();
                } else {
                    Mtp2.this.alignmentComplete();
                }
            } else if (Mtp2.this.logger.isEnabledFor(Level.WARN)) {
                Mtp2.this.logger.warn("T4 fired in state[ " + STATE_NAMES[tmpState] + " ]");
            }
            return 0L;
        }
    }

    private class T3Action
    extends Task {
        private int ttl;

        public T3Action(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = 10;
            this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            Mtp2.this.stop_T3();
            int tmpState = Mtp2.this.state;
            if (tmpState == 2) {
                Mtp2.this.alignmentNotPossible("T3 Expired.");
                Mtp2.this.emergency = false;
                if (Mtp2.this.logger.isEnabledFor(Level.WARN)) {
                    Mtp2.this.logger.warn("Timer T3 has expired, Alignment not possible. ");
                }
            } else if (Mtp2.this.logger.isEnabledFor(Level.WARN)) {
                Mtp2.this.logger.warn("T3 fired in state[ " + STATE_NAMES[tmpState] + " ]");
            }
            return 0L;
        }
    }

    private class T2Action
    extends Task {
        private int ttl;

        public T2Action(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = 50;
            this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            Mtp2.this.stop_T2();
            int tmpState = Mtp2.this.state;
            if (tmpState == 1) {
                Mtp2.this.alignmentNotPossible("T2 Expired.");
                Mtp2.this.emergency = false;
                if (Mtp2.this.logger.isEnabledFor(Level.WARN)) {
                    Mtp2.this.logger.warn("Timer T2 has expired, Alignment not possible. ");
                }
            } else if (Mtp2.this.logger.isEnabledFor(Level.WARN)) {
                Mtp2.this.logger.warn("T2 fired in state[ " + STATE_NAMES[tmpState] + " ]");
            }
            return 0L;
        }
    }
}

