/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.sccp.RemoteSccpStatus;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.SignallingPointStatus;
import org.mobicents.protocols.ss7.sccp.message.MessageFactory;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.PrevewDialogData;
import org.mobicents.protocols.ss7.tcap.SlsRangeType;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.ComponentPrimitiveFactory;
import org.mobicents.protocols.ss7.tcap.api.DialogPrimitiveFactory;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.TRPseudoState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.DraftParsedMessage;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDUImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.ResultType;
import org.mobicents.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCNoticeIndicationImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCUnidentifiedMessage;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.Utils;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCUniMessage;
import org.mobicents.protocols.ss7.tcap.tc.component.ComponentPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.DialogPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.DraftParsedMessageImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCBeginIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCContinueIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCEndIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCPAbortIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUniIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUserAbortIndicationImpl;

public class TCAPProviderImpl
implements TCAPProvider,
SccpListener {
    private static final Logger logger = Logger.getLogger(TCAPProviderImpl.class);
    private transient List<TCListener> tcListeners = new CopyOnWriteArrayList<TCListener>();
    protected transient ScheduledExecutorService _EXECUTOR;
    private transient ComponentPrimitiveFactory componentPrimitiveFactory;
    private transient DialogPrimitiveFactory dialogPrimitiveFactory;
    private transient SccpProvider sccpProvider;
    private transient MessageFactory messageFactory;
    private transient ParameterFactory parameterFactory;
    private transient TCAPStackImpl stack;
    private transient FastMap<Long, DialogImpl> dialogs = new FastMap();
    protected transient FastMap<PrevewDialogDataKey, PrevewDialogData> dialogPreviewList = new FastMap();
    private int seqControl = 0;
    private int ssn;
    private long curDialogId = 0L;

    protected TCAPProviderImpl(SccpProvider sccpProvider, TCAPStackImpl stack, int ssn) {
        this.sccpProvider = sccpProvider;
        this.ssn = ssn;
        this.messageFactory = sccpProvider.getMessageFactory();
        this.parameterFactory = sccpProvider.getParameterFactory();
        this.stack = stack;
        this.componentPrimitiveFactory = new ComponentPrimitiveFactoryImpl(this);
        this.dialogPrimitiveFactory = new DialogPrimitiveFactoryImpl(this.componentPrimitiveFactory);
    }

    public boolean getPreviewMode() {
        return this.stack.getPreviewMode();
    }

    public void addTCListener(TCListener lst) {
        if (!this.tcListeners.contains(lst)) {
            this.tcListeners.add(lst);
        }
    }

    public void removeTCListener(TCListener lst) {
        this.tcListeners.remove(lst);
    }

    private boolean checkAvailableTxId(Long id) {
        return !this.dialogs.containsKey(id);
    }

    private Long getAvailableTxId() throws TCAPException {
        Long id;
        if (this.dialogs.size() >= this.stack.getMaxDialogs()) {
            throw new TCAPException("Current dialog count exceeds its maximum value");
        }
        do {
            if (this.curDialogId < this.stack.getDialogIdRangeStart()) {
                this.curDialogId = this.stack.getDialogIdRangeStart() - 1L;
            }
            if (++this.curDialogId <= this.stack.getDialogIdRangeEnd()) continue;
            this.curDialogId = this.stack.getDialogIdRangeStart();
        } while (!this.checkAvailableTxId(id = Long.valueOf(this.curDialogId)));
        return id;
    }

    private synchronized int getNextSeqControl() {
        ++this.seqControl;
        if (this.seqControl > 255) {
            this.seqControl = 0;
        }
        if (this.stack.getSlsRangeType() == SlsRangeType.Odd) {
            if (this.seqControl % 2 == 0) {
                ++this.seqControl;
            }
        } else if (this.stack.getSlsRangeType() == SlsRangeType.Even && this.seqControl % 2 != 0) {
            ++this.seqControl;
        }
        return this.seqControl;
    }

    public ComponentPrimitiveFactory getComponentPrimitiveFactory() {
        return this.componentPrimitiveFactory;
    }

    public DialogPrimitiveFactory getDialogPrimitiveFactory() {
        return this.dialogPrimitiveFactory;
    }

    public Dialog getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        DialogImpl res = this.getNewDialog(localAddress, remoteAddress, this.getNextSeqControl(), null);
        if (this.stack.getStatisticsEnabled()) {
            this.stack.getCounterProviderImpl().updateAllLocalEstablishedDialogsCount();
            this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
        }
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    public Dialog getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress, Long id) throws TCAPException {
        DialogImpl res = this.getNewDialog(localAddress, remoteAddress, this.getNextSeqControl(), id);
        if (this.stack.getStatisticsEnabled()) {
            this.stack.getCounterProviderImpl().updateAllLocalEstablishedDialogsCount();
            this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
        }
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    public Dialog getNewUnstructuredDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        DialogImpl res = this._getDialog(localAddress, remoteAddress, false, this.getNextSeqControl(), null);
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    private DialogImpl getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress, int seqControl, Long id) throws TCAPException {
        return this._getDialog(localAddress, remoteAddress, true, seqControl, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DialogImpl _getDialog(SccpAddress localAddress, SccpAddress remoteAddress, boolean structured, int seqControl, Long id) throws TCAPException {
        if (this.stack.getPreviewMode()) {
            throw new TCAPException("Can not create a Dialog in a PreviewMode");
        }
        if (localAddress == null) {
            throw new NullPointerException("LocalAddress must not be null");
        }
        FastMap<Long, DialogImpl> fastMap = this.dialogs;
        synchronized (fastMap) {
            if (id == null) {
                id = this.getAvailableTxId();
            } else if (!this.checkAvailableTxId(id)) {
                throw new TCAPException("Suggested local TransactionId is already present in system: " + id);
            }
            if (structured) {
                DialogImpl di = new DialogImpl(localAddress, remoteAddress, id, structured, this._EXECUTOR, this, seqControl, this.stack.getPreviewMode());
                this.dialogs.put(id, di);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateMinDialogsCount(this.dialogs.size());
                    this.stack.getCounterProviderImpl().updateMaxDialogsCount(this.dialogs.size());
                }
                return di;
            }
            DialogImpl di = new DialogImpl(localAddress, remoteAddress, id, structured, this._EXECUTOR, this, seqControl, this.stack.getPreviewMode());
            return di;
        }
    }

    private void setSsnToDialog(DialogImpl di, int ssn) {
        if (!(ssn == this.ssn || ssn > 0 && this.stack.isExtraSsnPresent(ssn))) {
            ssn = this.ssn;
        }
        di.setLocalSsn(ssn);
    }

    public int getCurrentDialogsCount() {
        return this.dialogs.size();
    }

    public void send(byte[] data, boolean returnMessageOnError, SccpAddress destinationAddress, SccpAddress originatingAddress, int seqControl, int networkId, int localSsn) throws IOException {
        if (this.stack.getPreviewMode()) {
            return;
        }
        SccpDataMessage msg = this.messageFactory.createDataMessageClass1(destinationAddress, originatingAddress, data, seqControl, localSsn, returnMessageOnError, null, null);
        msg.setNetworkId(networkId);
        this.sccpProvider.send(msg);
    }

    public int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        return this.sccpProvider.getMaxUserDataLength(calledPartyAddress, callingPartyAddress, msgNetworkId);
    }

    public void deliver(DialogImpl dialogImpl, TCBeginIndicationImpl msg) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcBeginReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCBegin(msg);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCContinueIndicationImpl tcContinueIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcContinueReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCContinue(tcContinueIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCEndIndicationImpl tcEndIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcEndReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCEnd(tcEndIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCPAbortIndicationImpl tcAbortIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcPAbortReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCPAbort(tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUserAbortIndicationImpl tcAbortIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcUserAbortReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCUserAbort(tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUniIndicationImpl tcUniIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcUniReceivedCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCUni(tcUniIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCNoticeIndicationImpl tcNoticeIndication) {
        block3: {
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCNotice(tcNoticeIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block3;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DialogImpl d) {
        Long did = d.getLocalDialogId();
        if (!d.getPreviewMode()) {
            FastMap<Long, DialogImpl> fastMap = this.dialogs;
            synchronized (fastMap) {
                this.dialogs.remove(did);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateMinDialogsCount(this.dialogs.size());
                    this.stack.getCounterProviderImpl().updateMaxDialogsCount(this.dialogs.size());
                }
            }
            this.doRelease(d);
        }
    }

    private void doRelease(DialogImpl d) {
        block4: {
            if (d.isStructured() && this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateDialogReleaseCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onDialogReleased(d);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering dialog release.", e);
            }
        }
    }

    public void timeout(DialogImpl d) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateDialogTimeoutCount();
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onDialogTimeout(d);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering dialog release.", e);
            }
        }
    }

    public TCAPStackImpl getStack() {
        return this.stack;
    }

    public Future createOperationTimer(Runnable operationTimerTask, long invokeTimeout) {
        return this._EXECUTOR.schedule(operationTimerTask, invokeTimeout, TimeUnit.MILLISECONDS);
    }

    public void operationTimedOut(InvokeImpl tcInvokeRequestImpl) {
        block3: {
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onInvokeTimeout(tcInvokeRequestImpl);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block3;
                logger.error("Received exception while delivering Begin.", e);
            }
        }
    }

    void start() {
        logger.info("Starting TCAP Provider");
        this._EXECUTOR = Executors.newScheduledThreadPool(4);
        this.sccpProvider.registerSccpListener(this.ssn, this);
        logger.info("Registered SCCP listener with ssn " + this.ssn);
        List<Integer> extraSsns = this.stack.getExtraSsns();
        if (extraSsns != null) {
            for (Integer I1 : extraSsns) {
                if (I1 == null) continue;
                int extraSsn = I1;
                this.sccpProvider.registerSccpListener(extraSsn, this);
                logger.info("Registered SCCP listener with extra ssn " + extraSsn);
            }
        }
    }

    void stop() {
        this._EXECUTOR.shutdown();
        this.sccpProvider.deregisterSccpListener(this.ssn);
        List<Integer> extraSsns = this.stack.getExtraSsns();
        if (extraSsns != null) {
            for (Integer I1 : extraSsns) {
                if (I1 == null) continue;
                int extraSsn = I1;
                this.sccpProvider.deregisterSccpListener(extraSsn);
            }
        }
        this.dialogs.clear();
        this.dialogPreviewList.clear();
    }

    protected void sendProviderAbort(PAbortCauseType pAbortCause, byte[] remoteTransactionId, SccpAddress remoteAddress, SccpAddress localAddress, int seqControl, int networkId) {
        block4: {
            if (this.stack.getPreviewMode()) {
                return;
            }
            TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
            msg.setDestinationTransactionId(remoteTransactionId);
            msg.setPAbortCause(pAbortCause);
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateTcPAbortSentCount();
                }
                this.send(aos.toByteArray(), false, remoteAddress, localAddress, seqControl, networkId, localAddress.getSubsystemNumber());
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Failed to send message: ", e);
            }
        }
    }

    protected void sendProviderAbort(DialogServiceProviderType pt, byte[] remoteTransactionId, SccpAddress remoteAddress, SccpAddress localAddress, int seqControl, ApplicationContextName acn, int networkId) {
        block4: {
            if (this.stack.getPreviewMode()) {
                return;
            }
            DialogPortion dp = TcapFactory.createDialogPortion();
            dp.setUnidirectional(false);
            DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
            apdu.setDoNotSendProtocolVersion(this.getStack().getDoNotSendProtocolVersion());
            Result res = TcapFactory.createResult();
            res.setResultType(ResultType.RejectedPermanent);
            ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
            rsd.setDialogServiceProviderType(pt);
            apdu.setResultSourceDiagnostic(rsd);
            apdu.setResult(res);
            apdu.setApplicationContextName(acn);
            dp.setDialogAPDU(apdu);
            TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
            msg.setDestinationTransactionId(remoteTransactionId);
            msg.setDialogPortion(dp);
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateTcPAbortSentCount();
                }
                this.send(aos.toByteArray(), false, remoteAddress, localAddress, seqControl, networkId, localAddress.getSubsystemNumber());
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Failed to send message: ", e);
            }
        }
    }

    public void onCoordRequest(int arg0, int arg1, int arg2) {
    }

    public void onCoordResponse(int arg0, int arg1, int arg2) {
    }

    public void onMessage(SccpDataMessage message) {
        try {
            byte[] data = message.getData();
            SccpAddress localAddress = message.getCalledPartyAddress();
            SccpAddress remoteAddress = message.getCallingPartyAddress();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            if (ais.getTagClass() != 1) {
                this.unrecognizedPackageType(message, localAddress, remoteAddress, ais, tag, message.getNetworkId());
                return;
            }
            switch (tag) {
                case 5: {
                    DialogImpl di;
                    TCContinueMessage tcm = null;
                    try {
                        tcm = TcapFactory.createTCContinueMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCContinueMessage: " + e.toString(), e);
                        ais = new AsnInputStream(data);
                        tag = ais.readTag();
                        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
                        tcUnidentified.decode(ais);
                        if (tcUnidentified.getOriginatingTransactionId() != null) {
                            if (e.getPAbortCauseType() != null) {
                                this.sendProviderAbort(e.getPAbortCauseType(), tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            } else {
                                this.sendProviderAbort(PAbortCauseType.BadlyFormattedTxPortion, tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            }
                        }
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(tcm.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        PrevewDialogDataKey ky1 = new PrevewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dialogId);
                        long dId = Utils.decodeTransactionId(tcm.getOriginatingTransactionId());
                        PrevewDialogDataKey ky2 = new PrevewDialogDataKey(message.getIncomingOpc(), message.getCallingPartyAddress().getGlobalTitle() != null ? message.getCallingPartyAddress().getGlobalTitle().getDigits() : null, message.getCallingPartyAddress().getSubsystemNumber(), dId);
                        di = (DialogImpl)this.getPreviewDialog(ky1, ky2, localAddress, remoteAddress, this.seqControl);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-CONTINUE: No dialog/transaction for id: " + dialogId);
                        this.sendProviderAbort(PAbortCauseType.UnrecognizedTxID, tcm.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        break;
                    }
                    di.processContinue(tcm, localAddress, remoteAddress);
                    break;
                }
                case 2: {
                    DialogRequestAPDUImpl dlg;
                    TCBeginMessage tcb = null;
                    try {
                        tcb = TcapFactory.createTCBeginMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCBeginMessage: " + e.toString(), e);
                        ais = new AsnInputStream(data);
                        tag = ais.readTag();
                        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
                        tcUnidentified.decode(ais);
                        if (tcUnidentified.getOriginatingTransactionId() != null) {
                            if (e.getPAbortCauseType() != null) {
                                this.sendProviderAbort(e.getPAbortCauseType(), tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            } else {
                                this.sendProviderAbort(PAbortCauseType.BadlyFormattedTxPortion, tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            }
                        }
                        return;
                    }
                    if (tcb.getDialogPortion() != null && tcb.getDialogPortion().getDialogAPDU() != null && tcb.getDialogPortion().getDialogAPDU() instanceof DialogRequestAPDUImpl && !(dlg = (DialogRequestAPDUImpl)tcb.getDialogPortion().getDialogAPDU()).getProtocolVersion().isSupportedVersion()) {
                        logger.error("Unsupported protocol version of  has been received when parsing TCBeginMessage");
                        this.sendProviderAbort(DialogServiceProviderType.NoCommonDialogPortion, tcb.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), dlg.getApplicationContextName(), message.getNetworkId());
                        return;
                    }
                    DialogImpl di = null;
                    try {
                        if (this.stack.getPreviewMode()) {
                            long dId = Utils.decodeTransactionId(tcb.getOriginatingTransactionId());
                            PrevewDialogDataKey ky = new PrevewDialogDataKey(message.getIncomingOpc(), message.getCallingPartyAddress().getGlobalTitle() != null ? message.getCallingPartyAddress().getGlobalTitle().getDigits() : null, message.getCallingPartyAddress().getSubsystemNumber(), dId);
                            di = (DialogImpl)this.createPreviewDialog(ky, localAddress, remoteAddress, this.seqControl);
                            this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                        } else {
                            di = this.getNewDialog(localAddress, remoteAddress, message.getSls(), null);
                            this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                        }
                    }
                    catch (TCAPException e) {
                        this.sendProviderAbort(PAbortCauseType.ResourceLimitation, tcb.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        logger.error("Can not add a new dialog when receiving TCBeginMessage: " + e.getMessage(), e);
                        return;
                    }
                    if (this.stack.getStatisticsEnabled()) {
                        this.stack.getCounterProviderImpl().updateAllRemoteEstablishedDialogsCount();
                        this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
                    }
                    di.setNetworkId(message.getNetworkId());
                    di.processBegin(tcb, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        di.getPrevewDialogData().setLastACN(di.getApplicationContextName());
                        di.getPrevewDialogData().setOperationsSentB(di.operationsSent);
                        di.getPrevewDialogData().setOperationsSentA(di.operationsSentA);
                    }
                    break;
                }
                case 4: {
                    DialogImpl di;
                    TCEndMessage teb = null;
                    try {
                        teb = TcapFactory.createTCEndMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCEndMessage: " + e.toString(), e);
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(teb.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        PrevewDialogDataKey ky = new PrevewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dialogId);
                        di = (DialogImpl)this.getPreviewDialog(ky, null, localAddress, remoteAddress, this.seqControl);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-END: No dialog/transaction for id: " + dialogId);
                        break;
                    }
                    di.processEnd(teb, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        this.removePreviewDialog(di);
                    }
                    break;
                }
                case 7: {
                    DialogImpl di;
                    TCAbortMessage tub = null;
                    try {
                        tub = TcapFactory.createTCAbortMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCAbortMessage: " + e.toString(), e);
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(tub.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        long dId = Utils.decodeTransactionId(tub.getDestinationTransactionId());
                        PrevewDialogDataKey ky = new PrevewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dId);
                        di = (DialogImpl)this.getPreviewDialog(ky, null, localAddress, remoteAddress, this.seqControl);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-ABORT: No dialog/transaction for id: " + dialogId);
                        break;
                    }
                    di.processAbort(tub, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        this.removePreviewDialog(di);
                    }
                    break;
                }
                case 1: {
                    TCUniMessage tcuni;
                    try {
                        tcuni = TcapFactory.createTCUniMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCUniMessage: " + e.toString(), e);
                        return;
                    }
                    DialogImpl uniDialog = (DialogImpl)this.getNewUnstructuredDialog(localAddress, remoteAddress);
                    this.setSsnToDialog(uniDialog, message.getCalledPartyAddress().getSubsystemNumber());
                    uniDialog.processUni(tcuni, localAddress, remoteAddress);
                    break;
                }
                default: {
                    this.unrecognizedPackageType(message, localAddress, remoteAddress, ais, tag, message.getNetworkId());
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(String.format("Error while decoding Rx SccpMessage=%s", message), e);
        }
    }

    private void unrecognizedPackageType(SccpDataMessage message, SccpAddress localAddress, SccpAddress remoteAddress, AsnInputStream ais, int tag, int networkId) throws ParseException {
        if (this.stack.getPreviewMode()) {
            return;
        }
        logger.error(String.format("Rx unidentified tag=%s, tagClass=. SccpMessage=%s", tag, ais.getTagClass(), message));
        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
        tcUnidentified.decode(ais);
        if (tcUnidentified.getOriginatingTransactionId() != null) {
            byte[] otid = tcUnidentified.getOriginatingTransactionId();
            if (tcUnidentified.getDestinationTransactionId() != null) {
                Long dtid = Utils.decodeTransactionId(tcUnidentified.getDestinationTransactionId());
                this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, otid, remoteAddress, localAddress, message.getSls(), networkId);
            } else {
                this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, otid, remoteAddress, localAddress, message.getSls(), networkId);
            }
        } else {
            this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, new byte[0], remoteAddress, localAddress, message.getSls(), networkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onNotice(SccpNoticeMessage msg) {
        if (this.stack.getPreviewMode()) {
            return;
        }
        DialogImpl dialog = null;
        try {
            byte[] data = msg.getData();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
            tcUnidentified.decode(ais);
            if (tcUnidentified.getOriginatingTransactionId() != null) {
                long otid = Utils.decodeTransactionId(tcUnidentified.getOriginatingTransactionId());
                dialog = this.dialogs.get(otid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(String.format("Error while decoding Rx SccpNoticeMessage=%s", msg), e);
        }
        TCNoticeIndicationImpl ind = new TCNoticeIndicationImpl();
        ind.setRemoteAddress(msg.getCallingPartyAddress());
        ind.setLocalAddress(msg.getCalledPartyAddress());
        ind.setDialog(dialog);
        ind.setReportCause(msg.getReturnCause().getValue());
        if (dialog != null) {
            try {
                dialog.dialogLock.lock();
                this.deliver(dialog, ind);
                if (dialog.getState() == TRPseudoState.Active) return;
                dialog.release();
                return;
            }
            finally {
                dialog.dialogLock.unlock();
            }
        } else {
            this.deliver(dialog, ind);
        }
    }

    public void onPcState(int arg0, SignallingPointStatus arg1, int arg2, RemoteSccpStatus arg3) {
    }

    public void onState(int arg0, int arg1, boolean arg2, int arg3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialog createPreviewDialog(PrevewDialogDataKey ky, SccpAddress localAddress, SccpAddress remoteAddress, int seqControl) throws TCAPException {
        FastMap<PrevewDialogDataKey, PrevewDialogData> fastMap = this.dialogPreviewList;
        synchronized (fastMap) {
            if (this.dialogPreviewList.size() >= this.stack.getMaxDialogs()) {
                throw new TCAPException("Current dialog count exceeds its maximum value");
            }
            PrevewDialogData pddx = this.dialogPreviewList.get(ky);
            if (pddx != null) {
                this.removePreviewDialog(pddx);
                throw new TCAPException("Dialog with trId=" + ky.origTxId + " is already exists - we ignore it and drops curent dialog");
            }
            Long dialogId = this.getAvailableTxIdPreview();
            PrevewDialogData pdd = new PrevewDialogData(this, dialogId);
            this.dialogPreviewList.put(ky, pdd);
            DialogImpl di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, false);
            pdd.setPrevewDialogDataKey1(ky);
            pdd.startIdleTimer();
            return di;
        }
    }

    private Long getAvailableTxIdPreview() throws TCAPException {
        if (this.curDialogId < this.stack.getDialogIdRangeStart()) {
            this.curDialogId = this.stack.getDialogIdRangeStart() - 1L;
        }
        if (++this.curDialogId > this.stack.getDialogIdRangeEnd()) {
            this.curDialogId = this.stack.getDialogIdRangeStart();
        }
        Long id = this.curDialogId;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dialog getPreviewDialog(PrevewDialogDataKey ky1, PrevewDialogDataKey ky2, SccpAddress localAddress, SccpAddress remoteAddress, int seqControl) {
        FastMap<PrevewDialogDataKey, PrevewDialogData> fastMap = this.dialogPreviewList;
        synchronized (fastMap) {
            PrevewDialogData pdd = this.dialogPreviewList.get(ky1);
            DialogImpl di = null;
            boolean sideB = false;
            if (pdd != null) {
                sideB = pdd.getPrevewDialogDataKey1().equals(ky1);
                di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, sideB);
            } else {
                if (ky2 != null) {
                    pdd = this.dialogPreviewList.get(ky2);
                }
                if (pdd != null) {
                    sideB = pdd.getPrevewDialogDataKey1().equals(ky1);
                    di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, sideB);
                } else {
                    return null;
                }
            }
            pdd.restartIdleTimer();
            if (pdd.getPrevewDialogDataKey2() == null && ky2 != null) {
                if (pdd.getPrevewDialogDataKey1().equals(ky1)) {
                    pdd.setPrevewDialogDataKey2(ky2);
                } else {
                    pdd.setPrevewDialogDataKey2(ky1);
                }
                this.dialogPreviewList.put(pdd.getPrevewDialogDataKey2(), pdd);
            }
            return di;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePreviewDialog(DialogImpl di) {
        FastMap<PrevewDialogDataKey, PrevewDialogData> fastMap = this.dialogPreviewList;
        synchronized (fastMap) {
            PrevewDialogData pdd = this.dialogPreviewList.get(di.prevewDialogData.getPrevewDialogDataKey1());
            if (pdd == null && di.prevewDialogData.getPrevewDialogDataKey2() != null) {
                pdd = this.dialogPreviewList.get(di.prevewDialogData.getPrevewDialogDataKey2());
            }
            if (pdd != null) {
                this.removePreviewDialog(pdd);
            }
        }
        this.doRelease(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePreviewDialog(PrevewDialogData pdd) {
        FastMap<PrevewDialogDataKey, PrevewDialogData> fastMap = this.dialogPreviewList;
        synchronized (fastMap) {
            this.dialogPreviewList.remove(pdd.getPrevewDialogDataKey1());
            if (pdd.getPrevewDialogDataKey2() != null) {
                this.dialogPreviewList.remove(pdd.getPrevewDialogDataKey2());
            }
        }
        pdd.stopIdleTimer();
    }

    public DraftParsedMessage parseMessageDraft(byte[] data) {
        try {
            DraftParsedMessageImpl res = new DraftParsedMessageImpl();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            if (ais.getTagClass() != 1) {
                res.setParsingErrorReason("Message tag class must be CLASS_APPLICATION");
                return res;
            }
            switch (tag) {
                case 5: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 8 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("originatingTransactionId tag/tagClass is bad for TC-CONTINUE message");
                        return res;
                    }
                    byte[] originatingTransactionId = localAis.readOctetString();
                    res.setOriginationDialogId(Utils.decodeTransactionId(originatingTransactionId));
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-CONTINUE message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.Continue);
                    break;
                }
                case 2: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 8 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("originatingTransactionId tag/tagClass is bad for TC-BEGIN message");
                        return res;
                    }
                    byte[] originatingTransactionId = localAis.readOctetString();
                    res.setOriginationDialogId(Utils.decodeTransactionId(originatingTransactionId));
                    res.setMessageType(MessageType.Begin);
                    break;
                }
                case 4: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-END message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.End);
                    break;
                }
                case 7: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-ABORT message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.Abort);
                    break;
                }
                case 1: {
                    res.setMessageType(MessageType.Unidirectional);
                    break;
                }
                default: {
                    res.setParsingErrorReason("Unrecognized message tag");
                }
            }
            return res;
        }
        catch (Exception e) {
            DraftParsedMessageImpl res = new DraftParsedMessageImpl();
            res.setParsingErrorReason("Exception when message parsing: " + e.getMessage());
            return res;
        }
    }

    protected class PrevewDialogDataKey {
        public int dpc;
        public String sccpDigits;
        public int ssn;
        public long origTxId;

        public PrevewDialogDataKey(int dpc, String sccpDigits, int ssn, long txId) {
            this.dpc = dpc;
            this.sccpDigits = sccpDigits;
            this.ssn = ssn;
            this.origTxId = txId;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PrevewDialogDataKey)) {
                return false;
            }
            PrevewDialogDataKey b = (PrevewDialogDataKey)obj;
            if (this.sccpDigits != null ? !this.sccpDigits.equals(b.sccpDigits) : this.dpc != b.dpc) {
                return false;
            }
            if (this.ssn != b.ssn) {
                return false;
            }
            return this.origTxId == b.origTxId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = this.sccpDigits != null ? 31 * result + (this.sccpDigits == null ? 0 : this.sccpDigits.hashCode()) : 31 * result + this.dpc;
            result = 31 * result + this.ssn;
            result = 31 * result + (int)(this.origTxId + (this.origTxId >> 32));
            return result;
        }
    }
}

