/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsSignalInfoImpl;

public class MtForwardShortMessageResponseImpl
extends SmsMessageImpl
implements MtForwardShortMessageResponse {
    private SmsSignalInfoImpl sM_RP_UI;
    private MAPExtensionContainer extensionContainer;
    protected String _PrimitiveName = "MtForwardShortMessageResponse";

    public MtForwardShortMessageResponseImpl() {
    }

    public MtForwardShortMessageResponseImpl(SmsSignalInfo sM_RP_UI, MAPExtensionContainer extensionContainer) {
        this.sM_RP_UI = (SmsSignalInfoImpl)sM_RP_UI;
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.mtForwardSM_Response;
    }

    public int getOperationCode() {
        return 44;
    }

    public SmsSignalInfo getSM_RP_UI() {
        return this.sM_RP_UI;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.sM_RP_UI = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter sm-RP-UI is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.sM_RP_UI = new SmsSignalInfoImpl();
                        this.sM_RP_UI.decodeAll(ais);
                        continue block4;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.sM_RP_UI != null) {
            this.sM_RP_UI.encodeAll(asnOs);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getMAPDialog() != null) {
            sb.append("DialogId=").append(this.getMAPDialog().getLocalDialogId());
        }
        if (this.sM_RP_UI != null) {
            sb.append(", sm_RP_UI=[");
            sb.append(this.sM_RP_UI.toString());
            sb.append("]");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

