/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.asn;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;

public class AsnInputStream
extends InputStream {
    private static final String _REAL_BASE10_CHARSET = "US-ASCII";
    private static final int DATA_BUCKET_SIZE = 1024;
    private byte[] buffer;
    private int start;
    private int length;
    private int pos;
    private int tagClass = 0;
    private int pCBit = 0;
    private int tag;

    public AsnInputStream(byte[] buf) {
        this.buffer = buf;
        this.length = buf.length;
    }

    public AsnInputStream(byte[] buf, int tagClass, boolean isPrimitive, int tag) {
        this.buffer = buf;
        this.length = buf.length;
        this.tagClass = tagClass;
        this.pCBit = isPrimitive ? 0 : 1;
        this.tag = tag;
    }

    protected AsnInputStream(AsnInputStream buf, int start, int length) throws IOException {
        this.buffer = buf.buffer;
        this.start = buf.start + start;
        this.length = length;
        if (start < 0 || start > buf.length || this.start < 0 || this.start > this.buffer.length || this.length < 0 || this.start + this.length > this.buffer.length) {
            throw new IOException("Bad start or length values when creating AsnInputStream");
        }
        this.tagClass = buf.tagClass;
        this.pCBit = buf.pCBit;
        this.tag = buf.tag;
    }

    @Deprecated
    public AsnInputStream(InputStream in) {
        try {
            int av = in.available();
            byte[] buf = new byte[av];
            in.read(buf);
            this.buffer = buf;
            this.length = buf.length;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.buffer = new byte[0];
        }
    }

    public int position() {
        return this.pos;
    }

    public void position(int newPosition) throws IOException {
        if (newPosition < 0 || newPosition > this.length) {
            throw new IOException("Bad newPosition value when setting the new position in the AsnInputStream");
        }
        this.pos = newPosition;
    }

    public int available() {
        return this.length - this.pos;
    }

    public void advance(int byteCount) throws IOException {
        this.position(this.pos + byteCount);
    }

    public long skip(long n) throws IOException {
        int newPosition;
        if (n < 0L) {
            n = 0L;
        }
        if ((newPosition = this.pos + (int)n) < 0 || newPosition > this.length) {
            newPosition = this.length;
        }
        long skipCnt = newPosition - this.pos;
        this.pos = newPosition;
        return skipCnt;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.available() == 0) {
            throw new EOFException("AsnInputStream has reached the end");
        }
        return this.buffer[this.start + this.pos++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int cnt;
        if (len > b.length) {
            len = b.length;
        }
        if ((cnt = this.available()) > len) {
            cnt = len;
        }
        if (b == null || off < 0 || len < 0 || off + len > b.length) {
            throw new EOFException("Target byte array is null or bad off or len values");
        }
        System.arraycopy(this.buffer, this.start + this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new EOFException("Target byte array is null");
        }
        return this.read(b, 0, b.length);
    }

    public int readTag() throws IOException {
        byte b = (byte)this.read();
        this.tagClass = (b & 0xC0) >> 6;
        this.pCBit = (b & 0x20) >> 5;
        this.tag = b & 0x1F;
        if (this.tag == 31) {
            byte temp;
            this.tag = 0;
            do {
                temp = (byte)this.read();
                this.tag = this.tag << 7 | 0x7F & temp;
            } while (0 != (0x80 & temp));
        }
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean isTagPrimitive() {
        return this.pCBit == 0;
    }

    public int readLength() throws IOException {
        int length = 0;
        int b = this.read();
        if ((b & 0x80) == 0) {
            return b;
        }
        if ((b = (byte)(b & 0x7F)) == 0) {
            return -1;
        }
        for (int i = 0; i < b; ++i) {
            byte temp = (byte)this.read();
            length = length << 8 | 0xFF & temp;
        }
        return length;
    }

    public AsnInputStream readSequenceStream() throws AsnException, IOException {
        int length = this.readLength();
        return this.readSequenceStreamData(length);
    }

    public byte[] readSequence() throws AsnException, IOException {
        int length = this.readLength();
        return this.readSequenceData(length);
    }

    public AsnInputStream readSequenceStreamData(int length) throws AsnException, IOException {
        if (length == -1) {
            return this.readSequenceIndefinite();
        }
        int startPos = this.pos;
        this.advance(length);
        return new AsnInputStream(this, startPos, length);
    }

    public byte[] readSequenceData(int length) throws AsnException, IOException {
        AsnInputStream ais = this.readSequenceStreamData(length);
        byte[] res = new byte[ais.length];
        System.arraycopy(ais.buffer, ais.start + ais.pos, res, 0, ais.length);
        return res;
    }

    public AsnInputStream readSequenceIndefinite() throws AsnException, IOException {
        int startPos = this.pos;
        this.advanceIndefiniteLength();
        return new AsnInputStream(this, startPos, this.pos - startPos - 2);
    }

    public byte[] readIndefinite() throws AsnException, IOException {
        int startPos = this.pos;
        this.advanceIndefiniteLength();
        byte[] res = new byte[this.pos - startPos - 2];
        System.arraycopy(this.buffer, this.start + startPos, res, 0, this.pos - startPos - 2);
        return res;
    }

    private void advanceIndefiniteLength() throws AsnException, IOException {
        while (this.available() > 0) {
            int tag = this.readTag();
            if (tag == 0 && this.tagClass == 0) {
                if (this.read() == 0) {
                    return;
                }
                throw new AsnException("End-of-contents tag must have the zero length");
            }
            int length = this.readLength();
            if (length == -1) {
                this.advanceIndefiniteLength();
                continue;
            }
            this.advance(length);
        }
    }

    public void advanceElement() throws IOException, AsnException {
        int length = this.readLength();
        this.advanceElementData(length);
    }

    public void advanceElementData(int length) throws IOException, AsnException {
        if (length == -1) {
            this.advanceIndefiniteLength();
        } else {
            this.advance(length);
        }
    }

    public boolean readBoolean() throws AsnException, IOException {
        int length = this.readLength();
        return this.readBooleanData(length);
    }

    public boolean readBooleanData(int length) throws AsnException, IOException {
        if (this.pCBit != 0 || length != 1) {
            throw new AsnException("Failed when parsing the Boolean field: this field must be primitive and the length must be equal 1");
        }
        byte temp = (byte)this.read();
        return temp != 0;
    }

    public long readInteger() throws AsnException, IOException {
        int length = this.readLength();
        return this.readIntegerData(length);
    }

    public long readIntegerData(int length) throws AsnException, IOException {
        long value = 0L;
        if (this.pCBit != 0 || length == 0 || length == -1) {
            throw new AsnException("Failed when parsing the Interger field: this field must be primitive and have the length more then zero");
        }
        byte temp = (byte)this.read();
        value = temp;
        for (int i = 0; i < length - 1; ++i) {
            temp = (byte)this.read();
            value = value << 8 | (long)(0xFF & temp);
        }
        return value;
    }

    public double readReal() throws AsnException, IOException {
        int length = this.readLength();
        return this.readRealData(length);
    }

    public double readRealData(int length) throws AsnException, IOException {
        if (this.pCBit != 0 || length == -1) {
            throw new AsnException("Failed when parsing the Real field: this field must be primitive");
        }
        if (length == 0) {
            return 0.0;
        }
        if (length == 1) {
            int b = this.read() & 0xFF;
            if (b == 64) {
                return Double.POSITIVE_INFINITY;
            }
            if (b == 65) {
                return Double.NEGATIVE_INFINITY;
            }
            throw new AsnException("Failed when parsing the Real field: Real length indicates positive/negative infinity, but value is wrong: " + Integer.toBinaryString(b));
        }
        int infoBits = this.read();
        --length;
        if ((infoBits & 0xC0) == 0) {
            String nrRep = new String(this.buffer, this.start + this.pos, length, _REAL_BASE10_CHARSET);
            return Double.parseDouble(nrRep);
        }
        if ((infoBits & 0x80) == 128) {
            int tmp = 0;
            int signBit = (infoBits & 0x40) << 1;
            long e = 0L;
            int s = (infoBits & 0xC) >> 2;
            tmp = infoBits & 3;
            if (tmp == 0) {
                e = this.read() & 0xFF;
                --length;
            } else if (tmp == 1) {
                e = (this.read() & 0xFF) << 8;
                --length;
                --length;
                if ((e |= (long)(this.read() & 0xFF)) > 2047L) {
                    throw new AsnException("Exponent part has to many bits lit, allowed are 11, present: " + Long.toBinaryString(e));
                }
                e &= 0x7FFL;
            } else {
                throw new AsnException("Exponent part has to many bits lit, allowed are 11, but stream indicates 3 or more octets");
            }
            if (length > 7) {
                throw new AsnException("Length exceeds JAVA double mantisa size");
            }
            long n = 0L;
            while (length > 0) {
                long readV = (long)this.read() << 32 >>> 32 & 0xFFL;
                n |= (readV <<= --length * 8);
            }
            if ((n & 0xFFFFFFFL) > 0xFFFFFFFFFFFFFL) {
                throw new AsnException("Overflow on mantisa");
            }
            int shift = (int)Math.pow(2.0, s) - 1;
            n <<= shift;
            int base = (infoBits & 0x30) >> 4;
            if (base == 1) {
                e *= 3L;
            } else if (base == 16) {
                e *= 4L;
            }
            if (e > 2047L) {
                throw new AsnException("Exponent part has to many bits lit, allowed are 11, present: " + Long.toBinaryString(e));
            }
            byte[] doubleRep = new byte[8];
            doubleRep[0] = (byte)signBit;
            doubleRep[0] = (byte)((long)doubleRep[0] | e >> 4 & 0xFFL);
            doubleRep[1] = (byte)((e & 0xFL) << 4);
            doubleRep[7] = (byte)n;
            doubleRep[6] = (byte)(n >> 8);
            doubleRep[5] = (byte)(n >> 16);
            doubleRep[4] = (byte)(n >> 24);
            doubleRep[3] = (byte)(n >> 32);
            doubleRep[2] = (byte)(n >> 40);
            doubleRep[1] = (byte)(doubleRep[1] | (byte)(n >> 48 & 0xFL));
            ByteBuffer bb = ByteBuffer.wrap(doubleRep);
            return bb.getDouble();
        }
        throw new AsnException("Failed when parsing the Real field: Unknown infoBits: " + infoBits);
    }

    public BitSetStrictLength readBitString() throws AsnException, IOException {
        int length = this.readLength();
        return this.readBitStringData(length);
    }

    public BitSetStrictLength readBitStringData(int length) throws AsnException, IOException {
        BitSetStrictLength bitSet = new BitSetStrictLength(0);
        int bitCount = this._readBitString(bitSet, length, 0);
        bitSet.setStrictLength(bitCount);
        return bitSet;
    }

    @Deprecated
    public void readBitString(BitSet bitSet) throws AsnException, IOException {
        int length = this.readLength();
        this.readBitStringData(bitSet, length);
    }

    @Deprecated
    public void readBitStringData(BitSet bitSet, int length) throws AsnException, IOException {
        this._readBitString(bitSet, length, 0);
    }

    @Deprecated
    public void readBitStringData(BitSet bitSet, int length, boolean isTagPrimitive) throws AsnException, IOException {
        this.pCBit = isTagPrimitive ? 0 : 1;
        this._readBitString(bitSet, length, 0);
    }

    private int _readBitString(BitSet bitSet, int length, int counter) throws AsnException, IOException {
        block15: {
            int bits = 0;
            if (this.pCBit == 0) {
                int pad = this.read();
                for (int count = 1; count < length - 1; ++count) {
                    byte dataByte = (byte)this.read();
                    for (bits = 0; bits < 8; ++bits) {
                        if (0 != (dataByte & 128 >> bits)) {
                            bitSet.set(counter);
                        }
                        ++counter;
                    }
                }
                byte lastByte = (byte)this.read();
                for (bits = 0; bits < 8 - pad; ++bits) {
                    if (0 != (lastByte & 128 >> bits)) {
                        bitSet.set(counter);
                    }
                    ++counter;
                }
                return counter;
            }
            if (length == -1) {
                while (true) {
                    int tag;
                    if ((tag = this.readTag()) == 0) {
                        length = this.read();
                        if (length != 0) {
                            throw new AsnException("Error while decoding the bit-string: End-of-contents tag must have the zero length");
                        }
                        break block15;
                    }
                    if (tag != 3 || this.tagClass != 0) {
                        throw new AsnException("Error while decoding the bit-string: subsequent bit string tag must be CLASS_UNIVERSAL - STRING_BIT");
                    }
                    int length2 = this.readLength();
                    counter = this._readBitString(bitSet, length2, counter);
                }
            }
            int startPos = this.pos;
            while (true) {
                if (this.pos > startPos + length) {
                    throw new AsnException("Error while decoding the bit-string: constructed bit-string content do not fit its length");
                }
                if (this.pos == startPos + length) break;
                int tag = this.readTag();
                if (tag != 3 || this.tagClass != 0) {
                    throw new AsnException("Error while decoding the bit-string: subsequent bit string string tag must be CLASS_UNIVERSAL - STRING_BIT");
                }
                int length2 = this.readLength();
                if (this.pos + length2 > startPos + length) {
                    throw new AsnException("Error while decoding the bit-string: subsequent bit string is unconsistent");
                }
                counter = this._readBitString(bitSet, length2, counter);
            }
        }
        return counter;
    }

    public byte[] readOctetString() throws AsnException, IOException {
        int length = this.readLength();
        return this.readOctetStringData(length);
    }

    @Deprecated
    public void readOctetString(OutputStream outputStream) throws AsnException, IOException {
        int length = this.readLength();
        this.readOctetStringData(outputStream, length);
    }

    public byte[] readOctetStringData(int length) throws AsnException, IOException {
        if (this.pCBit == 0) {
            if (length == -1) {
                throw new AsnException("Error while decoding the octet-string: primitive with Indefinite_Length");
            }
            byte[] buf = new byte[length];
            int cnt = this.read(buf);
            if (cnt != length) {
                throw new AsnException("Error while decoding the octet-string: not enouph data for the octet string");
            }
            return buf;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this._readOctetString(outputStream, length);
        return outputStream.toByteArray();
    }

    @Deprecated
    public void readOctetStringData(OutputStream outputStream, int length) throws AsnException, IOException {
        this._readOctetString(outputStream, length);
    }

    @Deprecated
    public void readOctetStringData(OutputStream outputStream, int length, boolean isTagPrimitive) throws AsnException, IOException {
        this.pCBit = isTagPrimitive ? 0 : 1;
        this._readOctetString(outputStream, length);
    }

    private void _readOctetString(OutputStream outputStream, int length) throws AsnException, IOException {
        block10: {
            if (this.pCBit == 0) {
                this.fillOutputStream(outputStream, length);
            } else {
                if (length == -1) {
                    while (true) {
                        int tag;
                        if ((tag = this.readTag()) == 0) {
                            length = this.read();
                            if (length != 0) {
                                throw new AsnException("Error while decoding the octet-string: End-of-contents tag must have the zero length");
                            }
                            break block10;
                        }
                        if (tag != 4 || this.tagClass != 0) {
                            throw new AsnException("Error while decoding the octet-string: subsequent octet string tag must be CLASS_UNIVERSAL - STRING_BIT");
                        }
                        int length2 = this.readLength();
                        this._readOctetString(outputStream, length2);
                    }
                }
                int startPos = this.pos;
                while (this.pos != startPos + length) {
                    int tag = this.readTag();
                    if (tag != 4 || this.tagClass != 0) {
                        throw new AsnException("Error while decoding the octet-string: subsequent octet string string tag must be CLASS_UNIVERSAL - STRING_BIT");
                    }
                    int length2 = this.readLength();
                    if (this.pos + length2 > startPos + length) {
                        throw new AsnException("Error while decoding the octet-string: subsequent octet string is unconsistent");
                    }
                    this._readOctetString(outputStream, length2);
                }
            }
        }
    }

    private void fillOutputStream(OutputStream stream, int length) throws AsnException, IOException {
        byte[] dataBucket = new byte[1024];
        while (length != 0) {
            int cnt = length < 1024 ? length : 1024;
            int readCount = this.read(dataBucket, 0, cnt);
            if (readCount < cnt) {
                throw new AsnException("input stream has reached the end");
            }
            stream.write(dataBucket, 0, readCount);
            length -= readCount;
        }
    }

    public void readNull() throws AsnException, IOException {
        int length = this.readLength();
        this.readNullData(length);
    }

    public void readNullData(int length) throws AsnException, IOException {
        if (this.pCBit != 0 || length != 0) {
            throw new AsnException("Failed when parsing the NULL field: this field must be primitive and the length must be equal 0");
        }
    }

    public long[] readObjectIdentifier() throws AsnException, IOException {
        int length = this.readLength();
        return this.readObjectIdentifierData(length);
    }

    public long[] readObjectIdentifierData(int length) throws AsnException, IOException {
        if (this.pCBit != 0 || length == -1) {
            throw new AsnException("Failed when parsing the ObjectIdentifier field: this field must be primitive and the length must be defined");
        }
        byte[] data = new byte[length];
        this.read(data);
        length = 2;
        for (int i = 1; i < data.length; ++i) {
            if (data[i] < 0) continue;
            ++length;
        }
        long[] oids = new long[length];
        int b = 0xFF & data[0];
        oids[0] = b / 40;
        if (oids[0] == 0L || oids[0] == 1L) {
            oids[1] = b % 40;
        } else {
            oids[0] = 2L;
            oids[1] = b - 80;
        }
        int v = 0;
        length = 2;
        for (int i = 1; i < data.length; ++i) {
            byte b1 = data[i];
            if ((b1 & 0x80) != 0) {
                v = v << 7 | b1 & 0x7F;
                continue;
            }
            v = v << 7 | b1 & 0x7F;
            oids[length++] = v;
            v = 0;
        }
        if (length == oids.length) {
            return oids;
        }
        long[] oids2 = new long[length];
        System.arraycopy(oids, 0, oids2, 0, length);
        return oids2;
    }

    public String readIA5String() throws AsnException, IOException {
        int length = this.readLength();
        return this.readString(_REAL_BASE10_CHARSET, 22, length);
    }

    public String readIA5StringData(int length) throws AsnException, IOException {
        return this.readString(_REAL_BASE10_CHARSET, 22, length);
    }

    public String readUTF8String() throws AsnException, IOException {
        int length = this.readLength();
        return this.readString("UTF-8", 12, length);
    }

    public String readUTF8StringData(int length) throws AsnException, IOException {
        return this.readString("UTF-8", 12, length);
    }

    public String readGraphicString() throws AsnException, IOException {
        int length = this.readLength();
        return this.readString(_REAL_BASE10_CHARSET, 25, length);
    }

    public String readGraphicStringData(int length) throws AsnException, IOException {
        return this.readString(_REAL_BASE10_CHARSET, 25, length);
    }

    private String readString(String charset, int tagValue, int length) throws IOException, AsnException {
        if (this.pCBit == 0) {
            byte[] buf = new byte[length];
            int readCnt = this.read(buf);
            if (readCnt < length) {
                throw new AsnException("Error decoding string fieald: not enough data in the stream");
            }
            String s = new String(buf, charset);
            return s;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.readConstructedString(bos, tagValue, length);
        String s = new String(bos.toByteArray(), charset);
        return s;
    }

    private void readConstructedString(ByteArrayOutputStream bos, int parentTag, int length) throws AsnException, IOException {
        AsnInputStream ais = this.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int localTag = ais.readTag();
            if (parentTag != localTag) {
                throw new AsnException("Error decoding string fieald: Parent tag=" + parentTag + ", does not match member tag=" + localTag);
            }
            int localLength = ais.readLength();
            if (ais.pCBit == 0) {
                byte[] buf = new byte[localLength];
                int readCnt = ais.read(buf);
                if (readCnt < localLength) {
                    throw new AsnException("Error decoding string fieald: not enough data in the stream");
                }
                bos.write(buf);
                continue;
            }
            ais.readConstructedString(bos, parentTag, localLength);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Size=");
        sb.append(this.length);
        sb.append(", Pos=");
        sb.append(this.pos);
        sb.append(", Tag=");
        sb.append(this.tag);
        sb.append(", TagClass=");
        sb.append(this.tagClass);
        sb.append(", pCBit=");
        sb.append(this.pCBit);
        sb.append("\n");
        byte[] bf = new byte[this.length];
        System.arraycopy(this.buffer, this.start, bf, 0, this.length);
        sb.append(AsnOutputStream.arrayToString(bf));
        return sb.toString();
    }
}

