/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.scheduler;

import org.mobicents.protocols.ss7.scheduler.ConcurrentLinkedList;
import org.mobicents.protocols.ss7.scheduler.Task;

public class OrderedTaskQueue {
    private ConcurrentLinkedList<Task>[] taskList = new ConcurrentLinkedList[2];
    private Integer activeIndex = 0;

    public OrderedTaskQueue() {
        this.taskList[0] = new ConcurrentLinkedList();
        this.taskList[1] = new ConcurrentLinkedList();
    }

    public boolean isEmpty() {
        return this.taskList[this.activeIndex].isEmpty();
    }

    public void accept(Task task) {
        if ((this.activeIndex + 1) % 2 == 0) {
            if (!task.isInQueue0().booleanValue()) {
                this.taskList[0].offer(task);
                task.storedInQueue0();
            }
        } else if (!task.isInQueue1().booleanValue()) {
            this.taskList[1].offer(task);
            task.storedInQueue1();
        }
    }

    public Task poll() {
        Task result = this.taskList[this.activeIndex].poll();
        if (result != null) {
            if (this.activeIndex == 0) {
                result.removeFromQueue0();
            } else {
                result.removeFromQueue1();
            }
        }
        return result;
    }

    public void changePool() {
        this.activeIndex = (this.activeIndex + 1) % 2;
    }

    public void clear() {
        this.taskList[0].clear();
        this.taskList[1].clear();
    }

    public int size() {
        return this.taskList[this.activeIndex].size();
    }

    protected void remove(Task task) {
        if (task.isInQueue0().booleanValue()) {
            this.taskList[0].remove(task);
            task.removeFromQueue0();
        }
        if (task.isInQueue1().booleanValue()) {
            this.taskList[1].remove(task);
            task.removeFromQueue1();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Queue[");
        int len = Math.min(30, this.taskList[this.activeIndex].size());
        for (int i = 0; i < len - 1; ++i) {
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

