/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.AMBR;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;

public class AMBRImpl
extends SequenceBase
implements AMBR {
    private static final int _TAG_maxRequestedBandwidthUL = 0;
    private static final int _TAG_maxRequestedBandwidthDL = 1;
    private static final int _TAG_extensionContainer = 2;
    private int maxRequestedBandwidthUL;
    private int maxRequestedBandwidthDL;
    private MAPExtensionContainer extensionContainer = null;

    public AMBRImpl() {
        super("AMBR");
    }

    public AMBRImpl(int maxRequestedBandwidthUL, int maxRequestedBandwidthDL, MAPExtensionContainer extensionContainer) {
        super("AMBR");
        this.maxRequestedBandwidthUL = maxRequestedBandwidthUL;
        this.maxRequestedBandwidthDL = maxRequestedBandwidthDL;
        this.extensionContainer = extensionContainer;
    }

    public int getMaxRequestedBandwidthUL() {
        return this.maxRequestedBandwidthUL;
    }

    public int getMaxRequestedBandwidthDL() {
        return this.maxRequestedBandwidthDL;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.maxRequestedBandwidthUL = -1;
        this.maxRequestedBandwidthDL = -1;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 0 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".maxRequestedBandwidthUL: Parameter bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.maxRequestedBandwidthUL = (int)ais.readInteger();
                    break;
                }
                case 1: {
                    if (tag != 1 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".maxRequestedBandwidthDL: Parameter bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.maxRequestedBandwidthDL = (int)ais.readInteger();
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.maxRequestedBandwidthUL == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament maxRequestedBandwidthUL is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.maxRequestedBandwidthDL == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament maxRequestedBandwidthDL is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeInteger(2, 0, this.maxRequestedBandwidthUL);
            asnOs.writeInteger(2, 1, this.maxRequestedBandwidthDL);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        sb.append("maxRequestedBandwidthUL=");
        sb.append(this.maxRequestedBandwidthUL);
        sb.append(", ");
        sb.append("maxRequestedBandwidthDL=");
        sb.append(this.maxRequestedBandwidthDL);
        sb.append(", ");
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

