/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.UserTeleserviceInformation;

public class UserTeleserviceInformationImpl
extends AbstractISUPParameter
implements UserTeleserviceInformation {
    private static final String CODING_STANDARD = "codingStandard";
    private static final String INTERPRETATION = "interpretation";
    private static final String PRESENTATION_METHOD = "presentationMethod";
    private static final String HIGHLAYER_CHAR_IDENTIFICATION = "highLayerCharIdentification";
    private static final String E_HIGH_LAYER_CHAR_IDENTIFICATION = "eHighLayerCharIdentification";
    private static final String E_VIDEO_TELEPHONY_CHAR_IDENTIFICATION = "eVideoTelephonyCharIdentification";
    private static final int DEFAULT_INT_VALUE = 0;
    private int codingStandard;
    private int interpretation;
    private int presentationMethod;
    private int highLayerCharIdentification;
    private boolean eHighLayerCharIdentificationPresent;
    private boolean eVideoTelephonyCharIdentificationPresent;
    private int eHighLayerCharIdentification;
    private int eVideoTelephonyCharIdentification;
    protected static final XMLFormat<UserTeleserviceInformationImpl> ISUP_USER_TELESERVICE_INFORMATION_XML = new XMLFormat<UserTeleserviceInformationImpl>(UserTeleserviceInformationImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, UserTeleserviceInformationImpl userTeleserviceInformation) throws XMLStreamException {
            userTeleserviceInformation.codingStandard = xml.getAttribute(UserTeleserviceInformationImpl.CODING_STANDARD, 0);
            userTeleserviceInformation.interpretation = xml.getAttribute(UserTeleserviceInformationImpl.INTERPRETATION, 0);
            userTeleserviceInformation.presentationMethod = xml.getAttribute(UserTeleserviceInformationImpl.PRESENTATION_METHOD, 0);
            userTeleserviceInformation.highLayerCharIdentification = xml.getAttribute(UserTeleserviceInformationImpl.HIGHLAYER_CHAR_IDENTIFICATION, 0);
            int val = xml.getAttribute(UserTeleserviceInformationImpl.E_HIGH_LAYER_CHAR_IDENTIFICATION, Integer.MIN_VALUE);
            if (val != Integer.MIN_VALUE) {
                userTeleserviceInformation.setEHighLayerCharIdentification(val);
            }
            if ((val = xml.getAttribute(UserTeleserviceInformationImpl.E_VIDEO_TELEPHONY_CHAR_IDENTIFICATION, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                userTeleserviceInformation.setEVideoTelephonyCharIdentification(val);
            }
        }

        @Override
        public void write(UserTeleserviceInformationImpl userTeleserviceInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(UserTeleserviceInformationImpl.CODING_STANDARD, userTeleserviceInformation.codingStandard);
            xml.setAttribute(UserTeleserviceInformationImpl.INTERPRETATION, userTeleserviceInformation.interpretation);
            xml.setAttribute(UserTeleserviceInformationImpl.PRESENTATION_METHOD, userTeleserviceInformation.presentationMethod);
            xml.setAttribute(UserTeleserviceInformationImpl.HIGHLAYER_CHAR_IDENTIFICATION, userTeleserviceInformation.highLayerCharIdentification);
            if (userTeleserviceInformation.eHighLayerCharIdentificationPresent) {
                xml.setAttribute(UserTeleserviceInformationImpl.E_HIGH_LAYER_CHAR_IDENTIFICATION, userTeleserviceInformation.eHighLayerCharIdentification);
            }
            if (userTeleserviceInformation.eVideoTelephonyCharIdentificationPresent) {
                xml.setAttribute(UserTeleserviceInformationImpl.E_VIDEO_TELEPHONY_CHAR_IDENTIFICATION, userTeleserviceInformation.eVideoTelephonyCharIdentification);
            }
        }
    };

    public UserTeleserviceInformationImpl() {
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification, int eVideoTelephonyCharIdentification, boolean notImportantIgnoredParameter) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
        this.setEVideoTelephonyCharIdentification(eVideoTelephonyCharIdentification);
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification, int eHighLayerCharIdentification) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
        this.setEHighLayerCharIdentification(eHighLayerCharIdentification);
    }

    public UserTeleserviceInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int decode(byte[] b) throws ParameterException {
        boolean ext;
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must not be null and length must be greater than  1");
        }
        try {
            this.setPresentationMethod(b[0]);
            this.setInterpretation(b[0] >> 2);
            this.setCodingStandard(b[0] >> 5);
            this.setHighLayerCharIdentification(b[1]);
        }
        catch (Exception e) {
            throw new ParameterException(e);
        }
        boolean bl = ext = (b[1] >> 7 & 1) == 0;
        if (ext && b.length < 3) {
            throw new ParameterException("byte[] indicates extension to high layer cahracteristic indicator, however there isnt enough bytes");
        }
        if (!ext) {
            return b.length;
        }
        if (this.highLayerCharIdentification == 94 || this.highLayerCharIdentification == 95) {
            this.setEHighLayerCharIdentification(b[2] & 0x7F);
        } else if (this.highLayerCharIdentification >= 96 && this.highLayerCharIdentification <= 111) {
            this.setEVideoTelephonyCharIdentification(b[2] & 0x7F);
        }
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = null;
        b = this.eHighLayerCharIdentificationPresent || this.eVideoTelephonyCharIdentificationPresent ? new byte[3] : new byte[2];
        int v = 0;
        v = this.presentationMethod & 3;
        v |= (this.interpretation & 7) << 2;
        v |= (this.codingStandard & 3) << 5;
        b[0] = (byte)(v |= 0x80);
        b[1] = (byte)(this.highLayerCharIdentification & 0x7F);
        if (this.eHighLayerCharIdentificationPresent || this.eVideoTelephonyCharIdentificationPresent) {
            b[2] = this.eHighLayerCharIdentificationPresent ? (byte)(0x80 | this.eHighLayerCharIdentification & 0x7F) : (byte)(0x80 | this.eVideoTelephonyCharIdentification & 0x7F);
            return b;
        }
        b[1] = (byte)(b[1] | 0x80);
        return b;
    }

    public int getCodingStandard() {
        return this.codingStandard;
    }

    public void setCodingStandard(int codingStandard) {
        this.codingStandard = codingStandard & 3;
    }

    public int getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(int interpretation) {
        this.interpretation = interpretation & 7;
    }

    public int getPresentationMethod() {
        return this.presentationMethod;
    }

    public void setPresentationMethod(int presentationMethod) {
        this.presentationMethod = presentationMethod & 3;
    }

    public int getHighLayerCharIdentification() {
        return this.highLayerCharIdentification;
    }

    public void setHighLayerCharIdentification(int highLayerCharIdentification) {
        this.highLayerCharIdentification = highLayerCharIdentification & 0x7F;
    }

    public int getEHighLayerCharIdentification() {
        return this.eHighLayerCharIdentification;
    }

    public void setEHighLayerCharIdentification(int highLayerCharIdentification) {
        if (this.eVideoTelephonyCharIdentificationPresent) {
            throw new IllegalStateException("Either Extended VideoTlephony or Extended HighLayer octet is set. ExtendedVideoTlephony is already present");
        }
        if (this.highLayerCharIdentification != 94 && this.highLayerCharIdentification != 95) {
            throw new IllegalArgumentException("Can not set this octet - HLCI is of value: " + this.highLayerCharIdentification);
        }
        this.eHighLayerCharIdentificationPresent = true;
        this.eHighLayerCharIdentification = highLayerCharIdentification & 0x7F;
    }

    public int getEVideoTelephonyCharIdentification() {
        return this.eVideoTelephonyCharIdentification;
    }

    public void setEVideoTelephonyCharIdentification(int eVidedoTelephonyCharIdentification) {
        if (this.eHighLayerCharIdentificationPresent) {
            throw new IllegalStateException("Either Extended VideoTlephony or Extended HighLayer octet is set. ExtendedHighLayer is already present");
        }
        if (this.highLayerCharIdentification < 96 || this.highLayerCharIdentification > 111) {
            throw new IllegalArgumentException("Can not set this octet - HLCI is of value: " + this.highLayerCharIdentification);
        }
        this.eVideoTelephonyCharIdentificationPresent = true;
        this.eVideoTelephonyCharIdentification = eVidedoTelephonyCharIdentification & 0x7F;
    }

    public boolean isEHighLayerCharIdentificationPresent() {
        return this.eHighLayerCharIdentificationPresent;
    }

    public boolean isEVideoTelephonyCharIdentificationPresent() {
        return this.eVideoTelephonyCharIdentificationPresent;
    }

    public int getCode() {
        return 52;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UserTeleserviceInformation [codingStandard=");
        sb.append(this.codingStandard);
        sb.append(", interpretation=");
        sb.append(this.interpretation);
        sb.append(", presentationMethod=");
        sb.append(this.presentationMethod);
        sb.append(", highLayerCharIdentification=");
        sb.append(this.highLayerCharIdentification);
        if (this.eHighLayerCharIdentificationPresent) {
            sb.append(", eHighLayerCharIdentification=");
            sb.append(this.eHighLayerCharIdentification);
        }
        if (this.eVideoTelephonyCharIdentificationPresent) {
            sb.append(", eVideoTelephonyCharIdentification=");
            sb.append(this.eVideoTelephonyCharIdentification);
        }
        sb.append("]");
        return sb.toString();
    }
}

