/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.GenericDigitsImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.GenericNumberImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericDigits;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNumber;

public class DigitsImpl
implements Digits,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "Digits";
    private static final String ISUP_GENERIC_DIGITS_XML = "genericDigits";
    private static final String ISUP_GENERIC_NUMBER_XML = "genericNumber";
    private byte[] data;
    private boolean isGenericDigits;
    private boolean isGenericNumber;
    protected static final XMLFormat<DigitsImpl> DIGITS_XML = new XMLFormat<DigitsImpl>(DigitsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, DigitsImpl digits) throws XMLStreamException {
            try {
                GenericNumber gn;
                GenericDigits gd = xml.get(DigitsImpl.ISUP_GENERIC_DIGITS_XML, GenericDigitsImpl.class);
                if (gd != null) {
                    digits.setGenericDigits(gd);
                }
                if ((gn = (GenericNumber)xml.get(DigitsImpl.ISUP_GENERIC_NUMBER_XML, GenericNumberImpl.class)) != null) {
                    digits.setGenericNumber(gn);
                }
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void write(DigitsImpl digits, XMLFormat.OutputElement xml) throws XMLStreamException {
            block4: {
                try {
                    if (digits.getIsGenericDigits()) {
                        xml.add((GenericDigitsImpl)digits.getGenericDigits(), DigitsImpl.ISUP_GENERIC_DIGITS_XML, GenericDigitsImpl.class);
                        break block4;
                    }
                    if (digits.getIsGenericNumber()) {
                        xml.add((GenericNumberImpl)digits.getGenericNumber(), DigitsImpl.ISUP_GENERIC_NUMBER_XML, GenericNumberImpl.class);
                        break block4;
                    }
                    throw new XMLStreamException("Error when serializing Digits: primitive is marked neither GenericDigits nor GenericNumber");
                }
                catch (CAPException e) {
                    throw new XMLStreamException(e);
                }
            }
        }
    };

    public DigitsImpl() {
    }

    public DigitsImpl(byte[] data) {
        this.data = data;
    }

    public DigitsImpl(GenericDigits genericDigits) throws CAPException {
        this.setGenericDigits(genericDigits);
    }

    public DigitsImpl(GenericNumber genericNumber) throws CAPException {
        this.setGenericNumber(genericNumber);
    }

    public byte[] getData() {
        return this.data;
    }

    public GenericDigits getGenericDigits() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        if (!this.isGenericDigits) {
            throw new CAPException("Primitive is not marked as GenericDigits (use setGenericDigits() before)");
        }
        try {
            GenericDigitsImpl ocn = new GenericDigitsImpl();
            ocn.decode(this.data);
            return ocn;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding GenericDigits: " + e.getMessage(), e);
        }
    }

    public GenericNumber getGenericNumber() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        if (!this.isGenericNumber) {
            throw new CAPException("Primitive is not marked as GenericNumber (use setGenericNumber() before)");
        }
        try {
            GenericNumberImpl ocn = new GenericNumberImpl();
            ocn.decode(this.data);
            return ocn;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding GenericNumber: " + e.getMessage(), e);
        }
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setGenericDigits(GenericDigits genericDigits) throws CAPException {
        if (genericDigits == null) {
            throw new CAPException("The genericDigits parameter must not be null");
        }
        try {
            this.data = ((GenericDigitsImpl)genericDigits).encode();
            this.setIsGenericDigits();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding genericDigits: " + e.getMessage(), e);
        }
    }

    public void setGenericNumber(GenericNumber genericNumber) throws CAPException {
        if (genericNumber == null) {
            throw new CAPException("The genericNumber parameter must not be null");
        }
        try {
            this.data = ((GenericNumberImpl)genericNumber).encode();
            this.setIsGenericNumber();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding genericNumber: " + e.getMessage(), e);
        }
    }

    public boolean getIsGenericDigits() {
        return this.isGenericDigits;
    }

    public boolean getIsGenericNumber() {
        return this.isGenericNumber;
    }

    public void setIsGenericDigits() {
        this.isGenericDigits = true;
        this.isGenericNumber = false;
    }

    public void setIsGenericNumber() {
        this.isGenericNumber = true;
        this.isGenericDigits = false;
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding Digits: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding Digits: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding Digits: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding Digits: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 2 || this.data.length > 16) {
            throw new CAPParsingComponentException("Error while decoding Digits: data must be from 2 to 16 bytes length, found: " + this.data.length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding Digits: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("data field must not be null");
        }
        if (this.data.length < 2 && this.data.length > 16) {
            throw new CAPException("data field length must be from 2 to 16");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                if (this.getIsGenericNumber()) {
                    GenericNumber gn = this.getGenericNumber();
                    sb.append(", genericNumber");
                    sb.append(gn.toString());
                }
                if (this.getIsGenericDigits()) {
                    GenericDigits gd = this.getGenericDigits();
                    sb.append(", genericDigits");
                    sb.append(gd.toString());
                }
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

