/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;

public class External {
    protected static final int _TAG_EXTERNAL_CLASS = 0;
    protected static final boolean _TAG_EXTERNAL_PC_PRIMITIVE = false;
    protected static final int _TAG_ASN = 0;
    protected static final int _TAG_ASN_CLASS = 2;
    protected static final boolean _TAG_ASN_PC_PRIMITIVE = false;
    protected static final int _TAG_ARBITRARY = 2;
    protected static final int _TAG_ARBITRARY_CLASS = 2;
    protected static final int _TAG_OCTET_ALIGNED = 1;
    protected static final int _TAG_OCTET_ALIGNED_CLASS = 2;
    protected static final int _TAG_IMPLICIT_SEQUENCE = 8;
    protected boolean oid = false;
    protected boolean integer = false;
    protected boolean objDescriptor = false;
    protected long[] oidValue = null;
    protected long indirectReference = 0L;
    protected String objDescriptorValue = null;
    private boolean asn = false;
    private boolean octet = false;
    private boolean arbitrary = false;
    private byte[] data;
    private BitSetStrictLength bitDataString;

    public void decode(AsnInputStream ais) throws AsnException {
        this.oid = false;
        this.integer = false;
        this.objDescriptor = false;
        this.oidValue = null;
        this.indirectReference = 0L;
        this.objDescriptorValue = null;
        this.asn = false;
        this.octet = false;
        this.arbitrary = false;
        this.data = null;
        this.bitDataString = null;
        try {
            AsnInputStream localAsnIS = ais.readSequenceStream();
            block12: while (localAsnIS.available() != 0) {
                int tag = localAsnIS.readTag();
                if (localAsnIS.getTagClass() == 0) {
                    switch (tag) {
                        case 2: {
                            this.indirectReference = localAsnIS.readInteger();
                            this.setInteger(true);
                            continue block12;
                        }
                        case 6: {
                            this.oidValue = localAsnIS.readObjectIdentifier();
                            this.setOid(true);
                            continue block12;
                        }
                        case 7: {
                            this.objDescriptorValue = localAsnIS.readGraphicString();
                            this.setObjDescriptor(true);
                            continue block12;
                        }
                    }
                    throw new AsnException("Error while decoding External: Unrecognized tag value=" + tag + ", tagClass=" + localAsnIS.getTagClass());
                }
                if (localAsnIS.getTagClass() == 2) {
                    switch (tag) {
                        case 0: {
                            this.data = localAsnIS.readSequence();
                            this.setAsn(true);
                            break;
                        }
                        case 1: {
                            this.setEncodeType(localAsnIS.readOctetString());
                            this.setOctet(true);
                            break;
                        }
                        case 2: {
                            this.setEncodeBitStringType(localAsnIS.readBitString());
                            this.setArbitrary(true);
                            break;
                        }
                        default: {
                            throw new AsnException("Error while decoding External: Unrecognized tag value=" + tag + ", tagClass=" + localAsnIS.getTagClass());
                        }
                    }
                    if (localAsnIS.available() == 0) continue;
                    throw new AsnException("Error while decoding External: data field must be the last");
                }
                throw new AsnException("Error while decoding External: Unrecognized tag value=" + tag + ", tagClass=" + localAsnIS.getTagClass());
            }
        }
        catch (IOException e) {
            throw new AsnException("IOException while decoding External: " + e.getMessage(), e);
        }
    }

    public void encode(AsnOutputStream aos) throws AsnException {
        this.encode(aos, 0, 8);
    }

    public void encode(AsnOutputStream aos, int tagClass, int tag) throws AsnException {
        if (!this.oid && !this.integer) {
            throw new AsnException("Error while encoding External: oid value or integer value must be definite");
        }
        if (!(this.asn || this.octet || this.arbitrary)) {
            throw new AsnException("Error while encoding External: asn value, octect value or arbitrary value must be definite");
        }
        try {
            aos.writeTag(tagClass, false, tag);
            int pos1 = aos.StartContentDefiniteLength();
            if (this.oid) {
                aos.writeObjectIdentifier(this.oidValue);
            }
            if (this.integer) {
                aos.writeInteger(this.indirectReference);
            }
            if (this.objDescriptor) {
                aos.writeStringGraphic(0, 7, this.objDescriptorValue);
            }
            if (this.asn) {
                byte[] childData = this.getEncodeType();
                aos.writeTag(2, false, 0);
                aos.writeLength(childData.length);
                aos.write(childData);
            } else if (this.octet) {
                byte[] childData = this.getEncodeType();
                aos.writeOctetString(2, 1, childData);
            } else if (this.arbitrary) {
                BitSetStrictLength bs = this.bitDataString;
                aos.writeBitString(2, 2, bs);
            }
            aos.FinalizeContent(pos1);
        }
        catch (IOException e) {
            throw new AsnException(e);
        }
    }

    public byte[] getEncodeType() throws AsnException {
        return this.data;
    }

    public void setEncodeType(byte[] data) {
        this.data = data;
    }

    public BitSetStrictLength getEncodeBitStringType() throws AsnException {
        return this.bitDataString;
    }

    public void setEncodeBitStringType(BitSetStrictLength data) {
        this.bitDataString = data;
        this.setArbitrary(true);
    }

    public boolean isOid() {
        return this.oid;
    }

    public void setOid(boolean oid) {
        this.oid = oid;
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) {
        this.integer = integer;
    }

    public boolean isObjDescriptor() {
        return this.objDescriptor;
    }

    public void setObjDescriptor(boolean objDescriptor) {
        this.objDescriptor = objDescriptor;
    }

    public long[] getOidValue() {
        return this.oidValue;
    }

    public void setOidValue(long[] oidValue) {
        this.oidValue = oidValue;
    }

    public long getIndirectReference() {
        return this.indirectReference;
    }

    public void setIndirectReference(long indirectReference) {
        this.indirectReference = indirectReference;
    }

    public String getObjDescriptorValue() {
        return this.objDescriptorValue;
    }

    public void setObjDescriptorValue(String objDescriptorValue) {
        this.objDescriptorValue = objDescriptorValue;
    }

    public boolean isAsn() {
        return this.asn;
    }

    public void setAsn(boolean asn) {
        this.asn = asn;
        if (asn) {
            this.setArbitrary(false);
            this.setOctet(false);
        }
    }

    public boolean isOctet() {
        return this.octet;
    }

    public void setOctet(boolean octet) {
        this.octet = octet;
        if (octet) {
            this.setArbitrary(false);
            this.setAsn(false);
        }
    }

    public boolean isArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(boolean arbitrary) {
        this.arbitrary = arbitrary;
        if (arbitrary) {
            this.setObjDescriptor(false);
            this.setAsn(false);
        }
    }
}

