/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic;

import com.dialogic.signaling.gct.BBUtil;
import com.dialogic.signaling.gct.GctException;
import com.dialogic.signaling.gct.GctLib;
import com.dialogic.signaling.gct.GctMsg;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusCause;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartBaseImpl;

public class DialogicMtp3UserPart
extends Mtp3UserPartBaseImpl {
    private static final Logger logger = Logger.getLogger(DialogicMtp3UserPart.class);
    private static final int DIALOGIC_MESSAGE_TYPE_API_MSG_TX_REQ = 52992;
    private static final int DIALOGIC_MESSAGE_TYPE_API_MSG_RX_IND = 36609;
    private static final int DIALOGIC_MESSAGE_TYPE_MTP_MSG_PAUSE = 33795;
    private static final int DIALOGIC_MESSAGE_TYPE_MTP_MSG_RESUME = 33796;
    private static final int DIALOGIC_MESSAGE_TYPE_MTP_MSG_STATUS = 33797;
    private int sourceModuleId;
    private int destinationModuleId;
    private MtpStreamHandler streamHandler;
    protected ExecutorService layer3exec;

    public DialogicMtp3UserPart(String productName) {
        super(productName);
    }

    public int getSourceModuleId() {
        return this.sourceModuleId;
    }

    public void setSourceModuleId(int sourceModuleId) {
        this.sourceModuleId = sourceModuleId;
    }

    public int getDestinationModuleId() {
        return this.destinationModuleId;
    }

    public void setDestinationModuleId(int destinationModuleId) {
        this.destinationModuleId = destinationModuleId;
    }

    public void start() throws Exception {
        this.layer3exec = Executors.newFixedThreadPool(1);
        this.streamHandler = new MtpStreamHandler();
        this.layer3exec.execute(this.streamHandler);
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.streamHandler.stop();
        this.layer3exec.shutdown();
    }

    public void sendMessage(Mtp3TransferPrimitive msg) throws IOException {
        if (this.isStarted) {
            byte[] buf = msg.encodeMtp3();
            try {
                GctMsg txMsg = GctLib.getm((int)buf.length);
                txMsg.setDst((short)this.destinationModuleId);
                txMsg.setSrc((short)this.sourceModuleId);
                txMsg.setType(52992);
                ByteBuffer bytebuffer = txMsg.getParam();
                bytebuffer.put(buf);
                bytebuffer.flip();
                GctLib.send((GctMsg)txMsg);
            }
            catch (GctException e) {
                throw new IOException(e);
            }
        }
    }

    private class MtpStreamHandler
    implements Runnable {
        private boolean handlerIsStarted = true;

        private MtpStreamHandler() {
        }

        public void run() {
            block12: while (this.handlerIsStarted) {
                try {
                    GctMsg gctmsg = GctLib.receive((short)((short)DialogicMtp3UserPart.this.sourceModuleId));
                    ByteBuffer byteBuffer = gctmsg.getParam();
                    switch (gctmsg.getType()) {
                        case 36609: {
                            byte[] b = new byte[byteBuffer.remaining()];
                            byteBuffer.get(b);
                            Mtp3TransferPrimitive msg = DialogicMtp3UserPart.this.getMtp3TransferPrimitiveFactory().createMtp3TransferPrimitive(b);
                            DialogicMtp3UserPart.this.sendTransferMessageToLocalUser(msg, msg.getSls());
                            GctLib.relm((GctMsg)gctmsg);
                            continue block12;
                        }
                        case 33795: {
                            Mtp3PausePrimitive msgPause = new Mtp3PausePrimitive((int)BBUtil.getU32((ByteBuffer)byteBuffer));
                            DialogicMtp3UserPart.this.sendPauseMessageToLocalUser(msgPause);
                            continue block12;
                        }
                        case 33796: {
                            Mtp3ResumePrimitive msgResume = new Mtp3ResumePrimitive((int)BBUtil.getU32((ByteBuffer)byteBuffer));
                            DialogicMtp3UserPart.this.sendResumeMessageToLocalUser(msgResume);
                            continue block12;
                        }
                        case 33797: {
                            Mtp3StatusCause cause;
                            short status = gctmsg.getStatus();
                            int affectedDpc = (int)BBUtil.getU32((ByteBuffer)byteBuffer);
                            int congestionLevel = 0;
                            if (status == 1) {
                                int unavailabiltyCause = BBUtil.getU16((ByteBuffer)byteBuffer);
                                switch (unavailabiltyCause) {
                                    case 1: {
                                        cause = Mtp3StatusCause.UserPartUnavailability_UnequippedRemoteUser;
                                        break;
                                    }
                                    case 2: {
                                        cause = Mtp3StatusCause.UserPartUnavailability_InaccessibleRemoteUser;
                                        break;
                                    }
                                    default: {
                                        cause = Mtp3StatusCause.UserPartUnavailability_Unknown;
                                    }
                                }
                                congestionLevel = 0;
                            } else {
                                congestionLevel = BBUtil.getU16((ByteBuffer)byteBuffer);
                                cause = Mtp3StatusCause.SignallingNetworkCongested;
                            }
                            Mtp3StatusPrimitive msgStatus = new Mtp3StatusPrimitive(affectedDpc, cause, congestionLevel);
                            DialogicMtp3UserPart.this.sendStatusMessageToLocalUser(msgStatus);
                            continue block12;
                        }
                    }
                    logger.error("Received unrecognized message type from Dialogic board \n M-t" + String.format("%04x", gctmsg.getType()) + " -i" + String.format("%04x", gctmsg.getId()) + " -f" + String.format("%02x", gctmsg.getSrc()) + " -d" + String.format("%02x", gctmsg.getDst()) + " -s" + String.format("%02x", gctmsg.getStatus()));
                    if (!byteBuffer.hasRemaining()) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append("-p");
                    while (byteBuffer.hasRemaining()) {
                        sb.append(String.format("%02x", BBUtil.getU8((ByteBuffer)byteBuffer)));
                    }
                    logger.error(sb.toString());
                }
                catch (Exception e) {
                    logger.error("Error while reading data from the Dialogic card", e);
                }
            }
        }

        public void stop() {
            this.handlerIsStarted = false;
        }
    }
}

