/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.pdpContextActivation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.GSNAddress;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsRequest;
import org.mobicents.protocols.ss7.map.primitives.GSNAddressImpl;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.pdpContextActivation.PdpContextActivationMessageImpl;

public class SendRoutingInfoForGprsRequestImpl
extends PdpContextActivationMessageImpl
implements SendRoutingInfoForGprsRequest {
    protected static final int _TAG_imsi = 0;
    protected static final int _TAG_ggsnAddress = 1;
    protected static final int _TAG_ggsnNumber = 2;
    protected static final int _TAG_extensionContainer = 3;
    public static final String _PrimitiveName = "SendRoutingInfoForGprsRequest";
    private IMSI imsi;
    private GSNAddress ggsnAddress;
    private ISDNAddressString ggsnNumber;
    private MAPExtensionContainer extensionContainer;

    public SendRoutingInfoForGprsRequestImpl() {
    }

    public SendRoutingInfoForGprsRequestImpl(IMSI imsi, GSNAddress ggsnAddress, ISDNAddressString ggsnNumber, MAPExtensionContainer extensionContainer) {
        this.imsi = imsi;
        this.ggsnAddress = ggsnAddress;
        this.ggsnNumber = ggsnNumber;
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendRoutingInfoForGprs_Request;
    }

    public int getOperationCode() {
        return 24;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public GSNAddress getGgsnAddress() {
        return this.ggsnAddress;
    }

    public ISDNAddressString getGgsnNumber() {
        return this.ggsnNumber;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForGprsRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForGprsRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForGprsRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForGprsRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.ggsnAddress = null;
        this.ggsnNumber = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest.imsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest.ggsnAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ggsnAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.ggsnAddress).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest.ggsnNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ggsnNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.ggsnNumber).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else {
                ais.advanceElement();
            }
            ++num;
        }
        if (this.imsi == null) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest: Parameter imsi is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.ggsnNumber == null) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsRequest: Parameter ggsnNumber is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendRoutingInfoForGprsRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null) {
            throw new MAPException("IMSI parameter must not be null");
        }
        if (this.ggsnNumber == null) {
            throw new MAPException("ggsnNumber parameter must not be null");
        }
        ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 0);
        if (this.ggsnAddress != null) {
            ((GSNAddressImpl)this.ggsnAddress).encodeAll(asnOs, 2, 1);
        }
        ((ISDNAddressStringImpl)this.ggsnNumber).encodeAll(asnOs, 2, 2);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi);
            sb.append(", ");
        }
        if (this.ggsnAddress != null) {
            sb.append("ggsnAddress=");
            sb.append(this.ggsnAddress);
            sb.append(", ");
        }
        if (this.ggsnNumber != null) {
            sb.append("ggsnNumber=");
            sb.append(this.ggsnNumber);
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

