/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javolution.util.ReentrantLock;
import org.mobicents.protocols.ss7.isup.ISUPEvent;
import org.mobicents.protocols.ss7.isup.ISUPTimeoutEvent;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.ISUPProviderImpl;
import org.mobicents.protocols.ss7.isup.impl.message.AbstractISUPMessage;
import org.mobicents.protocols.ss7.isup.message.BlockingMessage;
import org.mobicents.protocols.ss7.isup.message.CircuitGroupBlockingMessage;
import org.mobicents.protocols.ss7.isup.message.CircuitGroupQueryMessage;
import org.mobicents.protocols.ss7.isup.message.CircuitGroupResetMessage;
import org.mobicents.protocols.ss7.isup.message.CircuitGroupUnblockingMessage;
import org.mobicents.protocols.ss7.isup.message.ISUPMessage;
import org.mobicents.protocols.ss7.isup.message.InformationRequestMessage;
import org.mobicents.protocols.ss7.isup.message.ReleaseMessage;
import org.mobicents.protocols.ss7.isup.message.ResetCircuitMessage;
import org.mobicents.protocols.ss7.isup.message.UnblockingMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.mobicents.protocols.ss7.scheduler.ConcurrentLinkedList;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.protocols.ss7.scheduler.Task;

class Circuit {
    private final int cic;
    private final int dpc;
    private final ISUPProviderImpl provider;
    private ReentrantLock lock = new ReentrantLock();
    private ConcurrentLinkedList<ISUPMessage> incoming = new ConcurrentLinkedList();
    private ConcurrentLinkedList<ISUPMessage> outgoing = new ConcurrentLinkedList();
    private Sender sender;
    private Receiver receiver;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(300);
    private TimerT1 t1;
    private TimerT5 t5;
    private Mtp3TransferPrimitive t1t5encodedREL;
    private ReleaseMessage t1t5REL;
    private TimerT7 t7;
    private ISUPMessage t7AddressMessage;
    private TimerT12 t12;
    private TimerT13 t13;
    private Mtp3TransferPrimitive t12t13encodedBLO;
    private BlockingMessage t12t13BLO;
    private TimerT14 t14;
    private TimerT15 t15;
    private Mtp3TransferPrimitive t14t15encodedUBL;
    private UnblockingMessage t14t15UBL;
    private TimerT16 t16;
    private TimerT17 t17;
    private Mtp3TransferPrimitive t16t17encodedRSC;
    private ResetCircuitMessage t16t17RSC;
    private TimerT18 t18;
    private TimerT19 t19;
    private Mtp3TransferPrimitive t18t19encodedCGB;
    private CircuitGroupBlockingMessage t18t19CGB;
    private TimerT20 t20;
    private TimerT21 t21;
    private Mtp3TransferPrimitive t20t21encodedCGU;
    private CircuitGroupUnblockingMessage t20t21CGU;
    private TimerT22 t22;
    private TimerT23 t23;
    private Mtp3TransferPrimitive t22t23encodedGRS;
    private CircuitGroupResetMessage t22t23GRS;
    private TimerT28 t28;
    private CircuitGroupQueryMessage t28CQM;
    private TimerT33 t33;
    private InformationRequestMessage t33INR;

    public Circuit(int cic, int dpc, ISUPProviderImpl provider, Scheduler scheduler) {
        this.sender = new Sender(scheduler);
        this.receiver = new Receiver(scheduler);
        this.cic = cic;
        this.dpc = dpc;
        this.provider = provider;
        this.t1 = new TimerT1(scheduler);
        this.t5 = new TimerT5(scheduler);
        this.t7 = new TimerT7(scheduler);
        this.t12 = new TimerT12(scheduler);
        this.t13 = new TimerT13(scheduler);
        this.t14 = new TimerT14(scheduler);
        this.t15 = new TimerT15(scheduler);
        this.t16 = new TimerT16(scheduler);
        this.t17 = new TimerT17(scheduler);
        this.t18 = new TimerT18(scheduler);
        this.t19 = new TimerT19(scheduler);
        this.t20 = new TimerT20(scheduler);
        this.t21 = new TimerT21(scheduler);
        this.t22 = new TimerT22(scheduler);
        this.t23 = new TimerT23(scheduler);
        this.t28 = new TimerT28(scheduler);
        this.t33 = new TimerT33(scheduler);
        this.onStop();
    }

    public int getCic() {
        return this.cic;
    }

    public int getDpc() {
        return this.dpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTimer(int timerId) {
        try {
            this.lock.lock();
            switch (timerId) {
                case 1: {
                    boolean bl = this.cancelT1();
                    return bl;
                }
                case 5: {
                    boolean bl = this.cancelT5();
                    return bl;
                }
                case 7: {
                    boolean bl = this.cancelT7();
                    return bl;
                }
                case 12: {
                    boolean bl = this.cancelT12();
                    return bl;
                }
                case 13: {
                    boolean bl = this.cancelT13();
                    return bl;
                }
                case 14: {
                    boolean bl = this.cancelT14();
                    return bl;
                }
                case 15: {
                    boolean bl = this.cancelT15();
                    return bl;
                }
                case 16: {
                    boolean bl = this.cancelT16();
                    return bl;
                }
                case 17: {
                    boolean bl = this.cancelT17();
                    return bl;
                }
                case 18: {
                    boolean bl = this.cancelT18();
                    return bl;
                }
                case 19: {
                    boolean bl = this.cancelT19();
                    return bl;
                }
                case 20: {
                    boolean bl = this.cancelT20();
                    return bl;
                }
                case 21: {
                    boolean bl = this.cancelT21();
                    return bl;
                }
                case 22: {
                    boolean bl = this.cancelT22();
                    return bl;
                }
                case 23: {
                    boolean bl = this.cancelT23();
                    return bl;
                }
                case 28: {
                    boolean bl = this.cancelT28();
                    return bl;
                }
                case 33: {
                    boolean bl = this.cancelT33();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receive(ISUPMessage message) {
        this.incoming.offer(message);
        this.receiver.submit();
    }

    public void send(ISUPMessage message) throws ParameterException, IOException {
        this.outgoing.offer(message);
        this.sender.submit();
    }

    private Mtp3TransferPrimitive decorate(ISUPMessage message) throws ParameterException, IOException {
        ((AbstractISUPMessage)message).encode(this.bos);
        byte[] encoded = this.bos.toByteArray();
        int opc = this.provider.getLocalSpc();
        int dpc = this.dpc;
        int si = 5;
        int ni = this.provider.getNi();
        int sls = message.getSls() & 0xF;
        Mtp3TransferPrimitiveFactory factory = this.provider.stack.getMtp3UserPart().getMtp3TransferPrimitiveFactory();
        Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(si, ni, 0, opc, dpc, sls, encoded);
        return msg;
    }

    private void startRELTimers(Mtp3TransferPrimitive encoded, ReleaseMessage rel) {
        this.t1t5encodedREL = encoded;
        this.t1t5REL = rel;
        this.startT1();
        if (!this.t5.isActive()) {
            this.startT5();
        }
    }

    private boolean stopRELTimers() {
        if (this.t1.isActive() || this.t5.isActive()) {
            this.cancelT1();
            this.cancelT5();
            return true;
        }
        return false;
    }

    private void startXAMTimers(ISUPMessage message) {
        this.cancelT7();
        this.t7AddressMessage = message;
        this.startT7();
    }

    private void stoptXAMTimers() {
        this.cancelT7();
    }

    private void startBLOTimers(Mtp3TransferPrimitive encoded, BlockingMessage message) {
        this.t12t13BLO = message;
        this.t12t13encodedBLO = encoded;
        this.startT12();
        if (!this.t13.isActive()) {
            this.startT13();
        }
    }

    private void stoptBLOTimers() {
        this.cancelT12();
        this.cancelT13();
    }

    private void startUBLTimers(Mtp3TransferPrimitive encoded, UnblockingMessage message) {
        this.t14t15UBL = message;
        this.t14t15encodedUBL = encoded;
        this.startT14();
        if (!this.t15.isActive()) {
            this.startT15();
        }
    }

    private void stoptUBLTimers() {
        this.cancelT14();
        this.cancelT15();
    }

    private void startRSCTimers(Mtp3TransferPrimitive encoded, ResetCircuitMessage message) {
        this.t16t17RSC = message;
        this.t16t17encodedRSC = encoded;
        this.startT16();
        if (!this.t17.isActive()) {
            this.startT17();
        }
    }

    private void stopRSCTimers() {
        this.cancelT16();
        this.cancelT17();
    }

    private void startINRTimers(InformationRequestMessage message) {
        this.t33INR = message;
        this.startT33();
    }

    private void stoptINRTimers() {
        this.cancelT33();
    }

    private void startCQMTimers(CircuitGroupQueryMessage message) {
        this.t28CQM = message;
        this.startT28();
    }

    private void stoptCQMTimers() {
        this.cancelT28();
    }

    private void startGRSTimers(Mtp3TransferPrimitive encoded, CircuitGroupResetMessage message) {
        this.t22t23GRS = message;
        this.t22t23encodedGRS = encoded;
        this.startT22();
        if (!this.t23.isActive()) {
            this.startT23();
        }
    }

    private void stoptGRSTimers() {
        this.cancelT22();
        this.cancelT23();
    }

    private void startCGUTimers(Mtp3TransferPrimitive encoded, CircuitGroupUnblockingMessage message) {
        this.t20t21CGU = message;
        this.t20t21encodedCGU = encoded;
        this.startT20();
        if (!this.t21.isActive()) {
            this.startT21();
        }
    }

    private void stoptCGUTimers() {
        this.cancelT20();
        this.cancelT21();
    }

    private void startCGBTimers(Mtp3TransferPrimitive encoded, CircuitGroupBlockingMessage message) {
        this.t18t19CGB = message;
        this.t18t19encodedCGB = encoded;
        this.startT18();
        if (!this.t19.isActive()) {
            this.startT19();
        }
    }

    private void stoptCGBTimers() {
        this.cancelT18();
        this.cancelT19();
    }

    private void startT1() {
        this.cancelT1();
        this.t1.start();
    }

    private boolean cancelT1() {
        if (this.t1.isActive()) {
            this.t1.cancel();
            return true;
        }
        return false;
    }

    private void startT5() {
        this.cancelT5();
        this.t5.start();
    }

    private boolean cancelT5() {
        if (this.t5.isActive()) {
            this.t5.cancel();
            return true;
        }
        return false;
    }

    private void startT7() {
        this.cancelT7();
        this.t7.start();
    }

    private boolean cancelT7() {
        if (this.t7.isActive()) {
            this.t7.cancel();
            return true;
        }
        return false;
    }

    private void startT12() {
        this.cancelT12();
        this.t12.start();
    }

    private boolean cancelT12() {
        if (this.t12.isActive()) {
            this.t12.cancel();
            return true;
        }
        return false;
    }

    private void startT13() {
        this.cancelT13();
        this.t13.start();
    }

    private boolean cancelT13() {
        if (this.t13.isActive()) {
            this.t13.cancel();
            return true;
        }
        return false;
    }

    private void startT14() {
        this.cancelT14();
        this.t14.start();
    }

    private boolean cancelT14() {
        if (this.t14.isActive()) {
            this.t14.cancel();
            return true;
        }
        return false;
    }

    private void startT15() {
        this.cancelT15();
        this.t15.start();
    }

    private boolean cancelT15() {
        if (this.t15.isActive()) {
            this.t15.cancel();
            return true;
        }
        return false;
    }

    private void startT16() {
        this.cancelT16();
        this.t16.start();
    }

    private boolean cancelT16() {
        if (this.t16.isActive()) {
            this.t16.cancel();
            return true;
        }
        return false;
    }

    private void startT17() {
        this.cancelT17();
        this.t17.start();
    }

    private boolean cancelT17() {
        if (this.t17.isActive()) {
            this.t17.cancel();
            return true;
        }
        return false;
    }

    private void startT18() {
        this.cancelT18();
        this.t18.start();
    }

    private boolean cancelT18() {
        if (this.t18.isActive()) {
            this.t18.cancel();
            return true;
        }
        return false;
    }

    private void startT19() {
        this.cancelT19();
        this.t19.start();
    }

    private boolean cancelT19() {
        if (this.t19.isActive()) {
            this.t19.cancel();
            return true;
        }
        return false;
    }

    private void startT20() {
        this.cancelT20();
        this.t20.start();
    }

    private boolean cancelT20() {
        if (this.t20.isActive()) {
            this.t20.cancel();
            return true;
        }
        return false;
    }

    private void startT21() {
        this.cancelT21();
        this.t21.start();
    }

    private boolean cancelT21() {
        if (this.t21.isActive()) {
            this.t21.cancel();
            return true;
        }
        return false;
    }

    private void startT22() {
        this.cancelT22();
        this.t22.start();
    }

    private boolean cancelT22() {
        if (this.t22.isActive()) {
            this.t22.cancel();
            return true;
        }
        return false;
    }

    private void startT23() {
        this.cancelT23();
        this.t23.start();
    }

    private boolean cancelT23() {
        if (this.t23.isActive()) {
            this.t23.cancel();
            return true;
        }
        return false;
    }

    private void startT28() {
        this.cancelT28();
        this.t28.start();
    }

    private boolean cancelT28() {
        if (this.t28.isActive()) {
            this.t28.cancel();
            return true;
        }
        return false;
    }

    private void startT33() {
        this.cancelT33();
        this.t33.start();
    }

    private boolean cancelT33() {
        if (this.t33.isActive()) {
            this.t33.cancel();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() {
        try {
            this.lock.lock();
            this.cancelT1();
            this.cancelT5();
            this.cancelT12();
            this.cancelT13();
            this.cancelT14();
            this.cancelT15();
            this.cancelT16();
            this.cancelT17();
            this.cancelT18();
            this.cancelT19();
            this.cancelT20();
            this.cancelT21();
            this.cancelT22();
            this.cancelT23();
            this.cancelT28();
            this.cancelT33();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class TimerT33
    extends Task {
        private int ttl;

        public TimerT33(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT33Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        ReleaseMessage rel = Circuit.this.provider.getMessageFactory().createREL(Circuit.this.cic);
                        CauseIndicators ci = Circuit.this.provider.getParameterFactory().createCauseIndicators();
                        ci.setCauseValue(31);
                        rel.setCauseIndicators(ci);
                        Circuit.this.provider.sendMessage(rel, Circuit.this.dpc);
                    }
                    catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                InformationRequestMessage msg = Circuit.this.t33INR;
                Circuit.this.t33INR = null;
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, msg, 33, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT28
    extends Task {
        private int ttl;

        public TimerT28(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT28Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                CircuitGroupQueryMessage msg = Circuit.this.t28CQM;
                Circuit.this.t28CQM = null;
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, msg, 28, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT23
    extends Task {
        private int ttl;

        public TimerT23(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT23Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT22();
                Circuit.this.startT23();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t22t23encodedGRS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t22t23GRS, 23, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT22
    extends Task {
        private int ttl;

        public TimerT22(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT22Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT22();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t22t23encodedGRS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t22t23GRS, 22, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT21
    extends Task {
        private int ttl;

        public TimerT21(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT21Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT20();
                Circuit.this.startT21();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t20t21encodedCGU);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t20t21CGU, 21, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT20
    extends Task {
        private int ttl;

        public TimerT20(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT20Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT20();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t20t21encodedCGU);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t20t21CGU, 20, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT19
    extends Task {
        private int ttl;

        public TimerT19(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT19Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT18();
                Circuit.this.startT19();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t18t19encodedCGB);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t18t19CGB, 19, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT18
    extends Task {
        private int ttl;

        public TimerT18(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT18Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT18();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t18t19encodedCGB);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t18t19CGB, 18, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT17
    extends Task {
        private int ttl;

        public TimerT17(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT17Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT16();
                Circuit.this.startT17();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t16t17encodedRSC);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t16t17RSC, 17, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT16
    extends Task {
        private int ttl;

        public TimerT16(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT16Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT16();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t16t17encodedRSC);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t16t17RSC, 16, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT15
    extends Task {
        private int ttl;

        public TimerT15(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT15Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT14();
                Circuit.this.startT15();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t14t15encodedUBL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t14t15UBL, 15, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT14
    extends Task {
        private int ttl;

        public TimerT14(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT14Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT14();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t14t15encodedUBL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t14t15UBL, 14, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT13
    extends Task {
        private int ttl;

        public TimerT13(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT13Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.cancelT12();
                Circuit.this.startT13();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t12t13encodedBLO);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t12t13BLO, 13, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT12
    extends Task {
        private int ttl;

        public TimerT12(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT12Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT12();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t12t13encodedBLO);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t12t13BLO, 12, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT7
    extends Task {
        private int ttl;

        public TimerT7(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT7Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        ReleaseMessage rel = Circuit.this.provider.getMessageFactory().createREL(Circuit.this.cic);
                        CauseIndicators ci = Circuit.this.provider.getParameterFactory().createCauseIndicators();
                        ci.setCauseValue(31);
                        rel.setCauseIndicators(ci);
                        Circuit.this.provider.sendMessage(rel, Circuit.this.dpc);
                    }
                    catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t7AddressMessage, 7, Circuit.this.dpc);
                Circuit.this.t7AddressMessage = null;
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT5
    extends Task {
        private int ttl;

        public TimerT5(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT5Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                Circuit.this.cancelT1();
                this.cancel();
                Circuit.this.startT5();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        ResetCircuitMessage rcm = Circuit.this.provider.getMessageFactory().createRSC(Circuit.this.cic);
                        Circuit.this.provider.sendMessage(rcm, Circuit.this.dpc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t1t5REL, 5, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class TimerT1
    extends Task {
        private int ttl;

        public TimerT1(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void start() {
            this.activate(true);
            this.ttl = (int)(Circuit.this.provider.getT1Timeout() / 100L);
            this.scheduler.submitHeatbeat(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (this.ttl > 0) {
                --this.ttl;
                this.scheduler.submitHeatbeat(this);
                return 0L;
            }
            try {
                Circuit.this.lock.lock();
                this.cancel();
                Circuit.this.startT1();
                if (Circuit.this.provider.isAutomaticTimerMessages()) {
                    try {
                        Circuit.this.provider.send(Circuit.this.t1t5encodedREL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ISUPTimeoutEvent timeoutEvent = new ISUPTimeoutEvent(Circuit.this.provider, Circuit.this.t1t5REL, 1, Circuit.this.dpc);
                Circuit.this.provider.deliver(timeoutEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Circuit.this.lock.unlock();
            }
            return 0L;
        }
    }

    private class Sender
    extends Task {
        public Sender(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.L4WRITE_QUEUE;
        }

        public void submit() {
            this.scheduler.submit(this, this.getQueueNumber());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            while (!Circuit.this.outgoing.isEmpty()) {
                try {
                    ISUPMessage message = (ISUPMessage)Circuit.this.outgoing.poll();
                    Circuit.this.lock.lock();
                    Circuit.this.bos.reset();
                    Mtp3TransferPrimitive msg = Circuit.this.decorate(message);
                    switch (message.getMessageType().getCode()) {
                        case 12: {
                            Circuit.this.startRELTimers(msg, (ReleaseMessage)message);
                            break;
                        }
                        case 1: 
                        case 2: {
                            Circuit.this.startXAMTimers(message);
                            break;
                        }
                        case 19: {
                            Circuit.this.startBLOTimers(msg, (BlockingMessage)message);
                            break;
                        }
                        case 20: {
                            Circuit.this.startUBLTimers(msg, (UnblockingMessage)message);
                            break;
                        }
                        case 18: {
                            Circuit.this.startRSCTimers(msg, (ResetCircuitMessage)message);
                            break;
                        }
                        case 24: {
                            Circuit.this.startCGBTimers(msg, (CircuitGroupBlockingMessage)message);
                            break;
                        }
                        case 25: {
                            Circuit.this.startCGUTimers(msg, (CircuitGroupUnblockingMessage)message);
                            break;
                        }
                        case 23: {
                            Circuit.this.startGRSTimers(msg, (CircuitGroupResetMessage)message);
                            break;
                        }
                        case 42: {
                            Circuit.this.startCQMTimers((CircuitGroupQueryMessage)message);
                            break;
                        }
                        case 3: {
                            Circuit.this.startINRTimers((InformationRequestMessage)message);
                        }
                    }
                    Circuit.this.provider.send(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    Circuit.this.lock.unlock();
                }
            }
            return 0L;
        }
    }

    private class Receiver
    extends Task {
        public Receiver(Scheduler scheduler) {
            super(scheduler);
        }

        public int getQueueNumber() {
            return Scheduler.L4READ_QUEUE;
        }

        public void submit() {
            this.scheduler.submit(this, this.getQueueNumber());
        }

        public long perform() {
            Circuit.this.lock.lock();
            while (!Circuit.this.incoming.isEmpty()) {
                ISUPMessage message = (ISUPMessage)Circuit.this.incoming.poll();
                try {
                    switch (message.getMessageType().getCode()) {
                        case 16: {
                            if (Circuit.this.stopRELTimers()) break;
                            Circuit.this.stopRSCTimers();
                            break;
                        }
                        case 6: 
                        case 7: {
                            Circuit.this.stoptXAMTimers();
                            break;
                        }
                        case 21: {
                            Circuit.this.stoptBLOTimers();
                            break;
                        }
                        case 22: {
                            Circuit.this.stoptUBLTimers();
                            break;
                        }
                        case 24: {
                            Circuit.this.stoptCGBTimers();
                            break;
                        }
                        case 27: {
                            Circuit.this.stoptCGUTimers();
                            break;
                        }
                        case 41: {
                            Circuit.this.stoptGRSTimers();
                            break;
                        }
                        case 43: {
                            Circuit.this.stoptCQMTimers();
                            break;
                        }
                        case 4: {
                            Circuit.this.stoptINRTimers();
                        }
                    }
                    ISUPEvent event = new ISUPEvent(Circuit.this.provider, message, Circuit.this.dpc);
                    Circuit.this.provider.deliver(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Circuit.this.lock.unlock();
            return 0L;
        }
    }
}

