/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ChargingResult;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ElapsedTime;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.TransferredVolume;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.ElapsedTimeImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.TransferredVolumeImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ChargingResultImpl
implements ChargingResult,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "ChargingResult";
    public static final int _ID_transferredVolume = 0;
    public static final int _ID_elapsedTime = 1;
    private TransferredVolume transferredVolume;
    private ElapsedTime elapsedTime;

    public ChargingResultImpl() {
    }

    public ChargingResultImpl(TransferredVolume transferredVolume) {
        this.transferredVolume = transferredVolume;
    }

    public ChargingResultImpl(ElapsedTime elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public TransferredVolume getTransferredVolume() {
        return this.transferredVolume;
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsedTime;
    }

    public int getTag() throws CAPException {
        if (this.transferredVolume != null) {
            return 0;
        }
        return 1;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ChargingResult: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        block5: {
            block4: {
                this.transferredVolume = null;
                this.elapsedTime = null;
                int tag = ais.getTag();
                if (ais.getTagClass() != 2) break block4;
                switch (tag) {
                    case 0: {
                        this.transferredVolume = new TransferredVolumeImpl();
                        ais.readTag();
                        ((TransferredVolumeImpl)this.transferredVolume).decodeAll(ais);
                        break block5;
                    }
                    case 1: {
                        this.elapsedTime = new ElapsedTimeImpl();
                        ais.readTag();
                        ((ElapsedTimeImpl)this.elapsedTime).decodeAll(ais);
                        break block5;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding ChargingResult: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new CAPParsingComponentException("Error while decoding ChargingResult: bad choice tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ChargingResult: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.transferredVolume == null && this.elapsedTime == null || this.transferredVolume != null && this.elapsedTime != null) {
            throw new CAPException("Error while decoding ChargingResult: One and only one choice must be selected");
        }
        if (this.transferredVolume != null) {
            ((TransferredVolumeImpl)this.transferredVolume).encodeAll(asnOs);
        } else {
            ((ElapsedTimeImpl)this.elapsedTime).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChargingResult [");
        if (this.transferredVolume != null) {
            sb.append("transferredVolume=");
            sb.append(this.transferredVolume.toString());
        }
        if (this.elapsedTime != null) {
            sb.append("elapsedTime=");
            sb.append(this.elapsedTime.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

