/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageCancelFailed;
import org.mobicents.protocols.ss7.cap.api.errors.CancelProblem;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageImpl;

public class CAPErrorMessageCancelFailedImpl
extends CAPErrorMessageImpl
implements CAPErrorMessageCancelFailed {
    private static final String CANCEL_PROBLEM = "cancelProblem";
    public static final String _PrimitiveName = "CAPErrorMessageCancelFailed";
    private CancelProblem cancelProblem;
    protected static final XMLFormat<CAPErrorMessageCancelFailedImpl> CAP_ERROR_MESSAGE_CANCEL_FAILED_XML = new XMLFormat<CAPErrorMessageCancelFailedImpl>(CAPErrorMessageCancelFailedImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CAPErrorMessageCancelFailedImpl errorMessage) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            String str = xml.get(CAPErrorMessageCancelFailedImpl.CANCEL_PROBLEM, String.class);
            if (str != null) {
                errorMessage.cancelProblem = Enum.valueOf(CancelProblem.class, str);
            }
        }

        @Override
        public void write(CAPErrorMessageCancelFailedImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            if (errorMessage.cancelProblem != null) {
                xml.add(errorMessage.cancelProblem.toString(), CAPErrorMessageCancelFailedImpl.CANCEL_PROBLEM, String.class);
            }
        }
    };

    protected CAPErrorMessageCancelFailedImpl(CancelProblem cancelProblem) {
        super(1L);
        this.cancelProblem = cancelProblem;
    }

    public CAPErrorMessageCancelFailedImpl() {
        super(1L);
    }

    public boolean isEmCancelFailed() {
        return true;
    }

    public CAPErrorMessageCancelFailed getEmCancelFailed() {
        return this;
    }

    public CancelProblem getCancelProblem() {
        return this.cancelProblem;
    }

    public void setCancelProblem(CancelProblem cancelProblem) {
        this.cancelProblem = cancelProblem;
    }

    public int getTag() throws CAPException {
        return 10;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageCancelFailed: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageCancelFailed: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageCancelFailed: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageCancelFailed: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.cancelProblem = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 10 || !localAis.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error decoding CAPErrorMessageCancelFailed: bad tag class or tag or parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        int i1 = (int)localAis.readIntegerData(length);
        this.cancelProblem = CancelProblem.getInstance(i1);
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPErrorMessageCancelFailed: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.cancelProblem == null) {
            throw new CAPException("Error while encoding CAPErrorMessageCancelFailed: cancelProblem field must not be null");
        }
        try {
            aos.writeIntegerData(this.cancelProblem.getCode());
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CAPErrorMessageCancelFailed: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.cancelProblem != null) {
            sb.append("cancelProblem=");
            sb.append((Object)this.cancelProblem);
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

