/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.EsiBcsm;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.EsiBcsm.TBusySpecificInfo;
import org.mobicents.protocols.ss7.cap.api.isup.CalledPartyNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.CauseCap;
import org.mobicents.protocols.ss7.cap.isup.CalledPartyNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.CauseCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class TBusySpecificInfoImpl
extends SequenceBase
implements TBusySpecificInfo {
    private static final String BUSY_CAUSE = "busyCause";
    private static final String CALL_FORWARDED = "callForwarded";
    private static final String ROUTE_NOT_PERMITTED = "routeNotPermitted";
    private static final String FORWARDING_DESTINATION_NUMBER = "forwardingDestinationNumber";
    public static final int _ID_busyCause = 0;
    public static final int _ID_callForwarded = 50;
    public static final int _ID_routeNotPermitted = 51;
    public static final int _ID_forwardingDestinationNumber = 52;
    private CauseCap busyCause;
    private boolean callForwarded;
    private boolean routeNotPermitted;
    private CalledPartyNumberCap forwardingDestinationNumber;
    protected static final XMLFormat<TBusySpecificInfoImpl> T_BUSY_SPECIFIC_INFO = new XMLFormat<TBusySpecificInfoImpl>(TBusySpecificInfoImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, TBusySpecificInfoImpl tBusySpecificInfo) throws XMLStreamException {
            tBusySpecificInfo.busyCause = xml.get(TBusySpecificInfoImpl.BUSY_CAUSE, CauseCapImpl.class);
            Boolean bval = xml.get(TBusySpecificInfoImpl.CALL_FORWARDED, Boolean.class);
            if (bval != null) {
                tBusySpecificInfo.callForwarded = bval;
            }
            if ((bval = xml.get(TBusySpecificInfoImpl.ROUTE_NOT_PERMITTED, Boolean.class)) != null) {
                tBusySpecificInfo.routeNotPermitted = bval;
            }
            tBusySpecificInfo.forwardingDestinationNumber = xml.get(TBusySpecificInfoImpl.FORWARDING_DESTINATION_NUMBER, CalledPartyNumberCapImpl.class);
        }

        @Override
        public void write(TBusySpecificInfoImpl tBusySpecificInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (tBusySpecificInfo.busyCause != null) {
                xml.add((CauseCapImpl)tBusySpecificInfo.busyCause, TBusySpecificInfoImpl.BUSY_CAUSE, CauseCapImpl.class);
            }
            if (tBusySpecificInfo.callForwarded) {
                xml.add(tBusySpecificInfo.callForwarded, TBusySpecificInfoImpl.CALL_FORWARDED, Boolean.class);
            }
            if (tBusySpecificInfo.routeNotPermitted) {
                xml.add(tBusySpecificInfo.routeNotPermitted, TBusySpecificInfoImpl.ROUTE_NOT_PERMITTED, Boolean.class);
            }
            if (tBusySpecificInfo.forwardingDestinationNumber != null) {
                xml.add((CalledPartyNumberCapImpl)tBusySpecificInfo.forwardingDestinationNumber, TBusySpecificInfoImpl.FORWARDING_DESTINATION_NUMBER, CalledPartyNumberCapImpl.class);
            }
        }
    };

    public TBusySpecificInfoImpl() {
        super("TBusySpecificInfo");
    }

    public TBusySpecificInfoImpl(CauseCap busyCause, boolean callForwarded, boolean routeNotPermitted, CalledPartyNumberCap forwardingDestinationNumber) {
        super("TBusySpecificInfo");
        this.busyCause = busyCause;
        this.callForwarded = callForwarded;
        this.routeNotPermitted = routeNotPermitted;
        this.forwardingDestinationNumber = forwardingDestinationNumber;
    }

    public CauseCap getBusyCause() {
        return this.busyCause;
    }

    public boolean getCallForwarded() {
        return this.callForwarded;
    }

    public boolean getRouteNotPermitted() {
        return this.routeNotPermitted;
    }

    public CalledPartyNumberCap getForwardingDestinationNumber() {
        return this.forwardingDestinationNumber;
    }

    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, MAPParsingComponentException, IOException, AsnException {
        this.busyCause = null;
        this.callForwarded = false;
        this.routeNotPermitted = false;
        this.forwardingDestinationNumber = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block6: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.busyCause = new CauseCapImpl();
                        ((CauseCapImpl)this.busyCause).decodeAll(ais);
                        continue block6;
                    }
                    case 50: {
                        ais.readNull();
                        this.callForwarded = true;
                        continue block6;
                    }
                    case 51: {
                        ais.readNull();
                        this.routeNotPermitted = true;
                        continue block6;
                    }
                    case 52: {
                        this.forwardingDestinationNumber = new CalledPartyNumberCapImpl();
                        ((CalledPartyNumberCapImpl)this.forwardingDestinationNumber).decodeAll(ais);
                        continue block6;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.busyCause != null) {
                ((CauseCapImpl)this.busyCause).encodeAll(asnOs, 2, 0);
            }
            if (this.callForwarded) {
                asnOs.writeNull(2, 50);
            }
            if (this.routeNotPermitted) {
                asnOs.writeNull(2, 51);
            }
            if (this.forwardingDestinationNumber != null) {
                ((CalledPartyNumberCapImpl)this.forwardingDestinationNumber).encodeAll(asnOs, 2, 52);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.busyCause != null) {
            sb.append("busyCause= [");
            sb.append(this.busyCause);
            sb.append("]");
        }
        if (this.callForwarded) {
            sb.append(", callForwarded");
        }
        if (this.routeNotPermitted) {
            sb.append(", routeNotPermitted");
        }
        if (this.forwardingDestinationNumber != null) {
            sb.append(", forwardingDestinationNumber= [");
            sb.append(this.forwardingDestinationNumber);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

