/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.ISTSupportIndicator;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SuperChargerInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SupportedLCSCapabilitySets;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SupportedRATTypes;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.VLRCapability;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.OfferedCamel4CSIs;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.SupportedCamelPhases;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SuperChargerInfoImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SupportedLCSCapabilitySetsImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SupportedRATTypesImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.OfferedCamel4CSIsImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.SupportedCamelPhasesImpl;

public class VLRCapabilityImpl
implements VLRCapability,
MAPAsnPrimitive {
    public static final int _TAG_supportedCamelPhases = 0;
    public static final int _TAG_solsaSupportIndicator = 2;
    public static final int _TAG_istSupportIndicator = 1;
    public static final int _TAG_superChargerSupportedInServingNetworkEntity = 3;
    public static final int _TAG_longFTNSupported = 4;
    public static final int _TAG_supportedLCSCapabilitySets = 5;
    public static final int _TAG_offeredCamel4CSIs = 6;
    public static final int _TAG_supportedRATTypesIndicator = 7;
    public static final int _TAG_longGroupIDSupported = 8;
    public static final int _TAG_mtRoamingForwardingSupported = 9;
    public static final String _PrimitiveName = "VlrCapability";
    private SupportedCamelPhases supportedCamelPhases;
    private MAPExtensionContainer extensionContainer;
    private boolean solsaSupportIndicator;
    private ISTSupportIndicator istSupportIndicator;
    private SuperChargerInfo superChargerSupportedInServingNetworkEntity;
    private boolean longFtnSupported;
    private SupportedLCSCapabilitySets supportedLCSCapabilitySets;
    private OfferedCamel4CSIs offeredCamel4CSIs;
    private SupportedRATTypes supportedRATTypesIndicator;
    private boolean longGroupIDSupported;
    private boolean mtRoamingForwardingSupported;

    public VLRCapabilityImpl() {
    }

    public VLRCapabilityImpl(SupportedCamelPhases supportedCamelPhases, MAPExtensionContainer extensionContainer, boolean solsaSupportIndicator, ISTSupportIndicator istSupportIndicator, SuperChargerInfo superChargerSupportedInServingNetworkEntity, boolean longFtnSupported, SupportedLCSCapabilitySets supportedLCSCapabilitySets, OfferedCamel4CSIs offeredCamel4CSIs, SupportedRATTypes supportedRATTypesIndicator, boolean longGroupIDSupported, boolean mtRoamingForwardingSupported) {
        this.supportedCamelPhases = supportedCamelPhases;
        this.extensionContainer = extensionContainer;
        this.solsaSupportIndicator = solsaSupportIndicator;
        this.istSupportIndicator = istSupportIndicator;
        this.superChargerSupportedInServingNetworkEntity = superChargerSupportedInServingNetworkEntity;
        this.longFtnSupported = longFtnSupported;
        this.supportedLCSCapabilitySets = supportedLCSCapabilitySets;
        this.offeredCamel4CSIs = offeredCamel4CSIs;
        this.supportedRATTypesIndicator = supportedRATTypesIndicator;
        this.longGroupIDSupported = longGroupIDSupported;
        this.mtRoamingForwardingSupported = mtRoamingForwardingSupported;
    }

    public SupportedCamelPhases getSupportedCamelPhases() {
        return this.supportedCamelPhases;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getSolsaSupportIndicator() {
        return this.solsaSupportIndicator;
    }

    public ISTSupportIndicator getIstSupportIndicator() {
        return this.istSupportIndicator;
    }

    public SuperChargerInfo getSuperChargerSupportedInServingNetworkEntity() {
        return this.superChargerSupportedInServingNetworkEntity;
    }

    public boolean getLongFtnSupported() {
        return this.longFtnSupported;
    }

    public SupportedLCSCapabilitySets getSupportedLCSCapabilitySets() {
        return this.supportedLCSCapabilitySets;
    }

    public OfferedCamel4CSIs getOfferedCamel4CSIs() {
        return this.offeredCamel4CSIs;
    }

    public SupportedRATTypes getSupportedRATTypesIndicator() {
        return this.supportedRATTypesIndicator;
    }

    public boolean getLongGroupIDSupported() {
        return this.longGroupIDSupported;
    }

    public boolean getMtRoamingForwardingSupported() {
        return this.mtRoamingForwardingSupported;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding VlrCapability: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding VlrCapability: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding VlrCapability: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding VlrCapability: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.supportedCamelPhases = null;
        this.extensionContainer = null;
        this.solsaSupportIndicator = false;
        this.istSupportIndicator = null;
        this.superChargerSupportedInServingNetworkEntity = null;
        this.longFtnSupported = false;
        this.supportedLCSCapabilitySets = null;
        this.offeredCamel4CSIs = null;
        this.supportedRATTypesIndicator = null;
        this.longGroupIDSupported = false;
        this.mtRoamingForwardingSupported = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.supportedCamelPhases: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.supportedCamelPhases = new SupportedCamelPhasesImpl();
                        ((SupportedCamelPhasesImpl)this.supportedCamelPhases).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.solsaSupportIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.solsaSupportIndicator = true;
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.istSupportIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.istSupportIndicator = ISTSupportIndicator.getInstance(i1);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.superChargerSupportedInServingNetworkEntity: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.superChargerSupportedInServingNetworkEntity = new SuperChargerInfoImpl();
                        ((SuperChargerInfoImpl)this.superChargerSupportedInServingNetworkEntity).decodeAll(ais2);
                        break;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.longFTNSupported: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.longFtnSupported = true;
                        break;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.supportedLCSCapabilitySets: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.supportedLCSCapabilitySets = new SupportedLCSCapabilitySetsImpl();
                        ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).decodeAll(ais);
                        break;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.offeredCamel4CSIs: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.offeredCamel4CSIs = new OfferedCamel4CSIsImpl();
                        ((OfferedCamel4CSIsImpl)this.offeredCamel4CSIs).decodeAll(ais);
                        break;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.supportedRATTypesIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.supportedRATTypesIndicator = new SupportedRATTypesImpl();
                        ((SupportedRATTypesImpl)this.supportedRATTypesIndicator).decodeAll(ais);
                        break;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.longGroupIDSupported: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.longGroupIDSupported = true;
                        break;
                    }
                    case 9: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.longFTNSupported: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.mtRoamingForwardingSupported = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding VlrCapability.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding VlrCapability: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.supportedCamelPhases != null) {
                ((SupportedCamelPhasesImpl)this.supportedCamelPhases).encodeAll(asnOs, 2, 0);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.solsaSupportIndicator) {
                asnOs.writeNull(2, 2);
            }
            if (this.istSupportIndicator != null) {
                asnOs.writeInteger(2, 1, this.istSupportIndicator.getCode());
            }
            if (this.superChargerSupportedInServingNetworkEntity != null) {
                asnOs.writeTag(2, false, 3);
                int pos = asnOs.StartContentDefiniteLength();
                ((SuperChargerInfoImpl)this.superChargerSupportedInServingNetworkEntity).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            if (this.longFtnSupported) {
                asnOs.writeNull(2, 4);
            }
            if (this.supportedLCSCapabilitySets != null) {
                ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).encodeAll(asnOs, 2, 5);
            }
            if (this.offeredCamel4CSIs != null) {
                ((OfferedCamel4CSIsImpl)this.offeredCamel4CSIs).encodeAll(asnOs, 2, 6);
            }
            if (this.supportedRATTypesIndicator != null) {
                ((SupportedRATTypesImpl)this.supportedRATTypesIndicator).encodeAll(asnOs, 2, 7);
            }
            if (this.longGroupIDSupported) {
                asnOs.writeNull(2, 8);
            }
            if (this.mtRoamingForwardingSupported) {
                asnOs.writeNull(2, 9);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding VlrCapability: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding VlrCapability: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.supportedCamelPhases != null) {
            sb.append("supportedCamelPhases=");
            sb.append(this.supportedCamelPhases.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.solsaSupportIndicator) {
            sb.append("solsaSupportIndicator, ");
        }
        if (this.istSupportIndicator != null) {
            sb.append("istSupportIndicator=");
            sb.append(this.istSupportIndicator.toString());
            sb.append(", ");
        }
        if (this.superChargerSupportedInServingNetworkEntity != null) {
            sb.append("superChargerSupportedInServingNetworkEntity=");
            sb.append(this.superChargerSupportedInServingNetworkEntity.toString());
            sb.append(", ");
        }
        if (this.longFtnSupported) {
            sb.append("longFtnSupported, ");
        }
        if (this.supportedLCSCapabilitySets != null) {
            sb.append("supportedLCSCapabilitySets=");
            sb.append(this.supportedLCSCapabilitySets.toString());
            sb.append(", ");
        }
        if (this.offeredCamel4CSIs != null) {
            sb.append("offeredCamel4CSIs=");
            sb.append(this.offeredCamel4CSIs.toString());
            sb.append(", ");
        }
        if (this.supportedRATTypesIndicator != null) {
            sb.append("supportedRATTypesIndicator=");
            sb.append(this.supportedRATTypesIndicator.toString());
            sb.append(", ");
        }
        if (this.longGroupIDSupported) {
            sb.append("longGroupIDSupported, ");
        }
        if (this.mtRoamingForwardingSupported) {
            sb.append("mtRoamingForwardingSupported, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

