/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.GSNAddress;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSLocationInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSResponse;
import org.mobicents.protocols.ss7.map.primitives.GSNAddressImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SubscriberIdentityImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSLocationInfoImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;

public class SendRoutingInfoForLCSResponseImpl
extends LsmMessageImpl
implements SendRoutingInfoForLCSResponse {
    private static final int _TAG_TARGET_MS = 0;
    private static final int _TAG_LCS_LOCATION_INFO = 1;
    private static final int _TAG_EXTENSION_CONTAINER = 2;
    private static final int _TAG_V_GMLC_ADDRESS = 3;
    private static final int _TAG_H_GMLC_ADDRESS = 4;
    private static final int _TAG_PPR_ADDRESS = 5;
    private static final int _TAG_ADDITIONAL_V_GMLC_ADDRESS = 6;
    public static final String _PrimitiveName = "SendRoutingInfoForLCSResponse";
    private SubscriberIdentity targetMS;
    private LCSLocationInfo lcsLocationInfo;
    private MAPExtensionContainer extensionContainer;
    private GSNAddress vgmlcAddress;
    private GSNAddress hGmlcAddress;
    private GSNAddress pprAddress;
    private GSNAddress additionalVGmlcAddress;

    public SendRoutingInfoForLCSResponseImpl() {
    }

    public SendRoutingInfoForLCSResponseImpl(SubscriberIdentity targetMS, LCSLocationInfo lcsLocationInfo, MAPExtensionContainer extensionContainer, GSNAddress vgmlcAddress, GSNAddress hGmlcAddress, GSNAddress pprAddress, GSNAddress additionalVGmlcAddress) {
        this.targetMS = targetMS;
        this.lcsLocationInfo = lcsLocationInfo;
        this.extensionContainer = extensionContainer;
        this.vgmlcAddress = vgmlcAddress;
        this.hGmlcAddress = hGmlcAddress;
        this.pprAddress = pprAddress;
        this.additionalVGmlcAddress = additionalVGmlcAddress;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendRoutingInfoForLCS_Response;
    }

    public int getOperationCode() {
        return 85;
    }

    public SubscriberIdentity getTargetMS() {
        return this.targetMS;
    }

    public LCSLocationInfo getLCSLocationInfo() {
        return this.lcsLocationInfo;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public GSNAddress getVgmlcAddress() {
        return this.vgmlcAddress;
    }

    public GSNAddress getHGmlcAddress() {
        return this.hGmlcAddress;
    }

    public GSNAddress getPprAddress() {
        return this.pprAddress;
    }

    public GSNAddress getAdditionalVGmlcAddress() {
        return this.additionalVGmlcAddress;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForLCSResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForLCSResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForLCSResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForLCSResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.targetMS = null;
        this.lcsLocationInfo = null;
        this.extensionContainer = null;
        this.vgmlcAddress = null;
        this.hGmlcAddress = null;
        this.pprAddress = null;
        this.additionalVGmlcAddress = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [targetMS [0] SubscriberIdentity] bad tag, tag class or primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.targetMS = new SubscriberIdentityImpl();
        AsnInputStream ais2 = ais.readSequenceStream();
        ais2.readTag();
        ((SubscriberIdentityImpl)this.targetMS).decodeAll(ais2);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [lcsLocationInfo [1] LCSLocationInfo] bad tag, tag class or primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.lcsLocationInfo = new LCSLocationInfoImpl();
        ((LCSLocationInfoImpl)this.lcsLocationInfo).decodeAll(ais);
        block7: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [extensionContainer [2] ExtensionContainer] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block7;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [v-gmlc-Address [3] GSN-Address] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.vgmlcAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.vgmlcAddress).decodeAll(ais);
                        continue block7;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [h-gmlc-Address [4] GSN-Address] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.hGmlcAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.hGmlcAddress).decodeAll(ais);
                        continue block7;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [ppr-Address [5] GSN-Address] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pprAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.pprAddress).decodeAll(ais);
                        continue block7;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSResponse: Parameter [additional-v-gmlc-Address [6] GSN-Address] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.additionalVGmlcAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.additionalVGmlcAddress).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendRoutingInfoForLCSResponse: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.targetMS == null) {
            throw new MAPException("Encoding of SendRoutingInfoForLCSResponse failed. Manadatory parameter targetMS [0] SubscriberIdentity is not set");
        }
        if (this.lcsLocationInfo == null) {
            throw new MAPException("Encoding of SendRoutingInfoForLCSResponse failed. Manadatory parameter lcsLocationInfo [1] LCSLocationInfo is not set");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((SubscriberIdentityImpl)this.targetMS).encodeAll(asnOs, 2, ((SubscriberIdentityImpl)this.targetMS).getTag());
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding parameter SendRoutingInfoForLCSResponse.targetMS [0] SubscriberIdentity");
        }
        ((LCSLocationInfoImpl)this.lcsLocationInfo).encodeAll(asnOs, 2, 1);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
        if (this.vgmlcAddress != null) {
            ((GSNAddressImpl)this.vgmlcAddress).encodeAll(asnOs, 2, 3);
        }
        if (this.hGmlcAddress != null) {
            ((GSNAddressImpl)this.hGmlcAddress).encodeAll(asnOs, 2, 4);
        }
        if (this.pprAddress != null) {
            ((GSNAddressImpl)this.pprAddress).encodeAll(asnOs, 2, 5);
        }
        if (this.additionalVGmlcAddress != null) {
            ((GSNAddressImpl)this.additionalVGmlcAddress).encodeAll(asnOs, 2, 6);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.targetMS != null) {
            sb.append("targetMS");
            sb.append(this.targetMS);
        }
        if (this.lcsLocationInfo != null) {
            sb.append(", lcsLocationInfo=");
            sb.append(this.lcsLocationInfo);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.vgmlcAddress != null) {
            sb.append(", vgmlcAddress=");
            sb.append(this.vgmlcAddress);
        }
        if (this.hGmlcAddress != null) {
            sb.append(", hGmlcAddress=");
            sb.append(this.hGmlcAddress);
        }
        if (this.pprAddress != null) {
            sb.append(", pprAddress=");
            sb.append(this.pprAddress);
        }
        if (this.additionalVGmlcAddress != null) {
            sb.append(", additionalVGmlcAddress=");
            sb.append(this.additionalVGmlcAddress);
        }
        sb.append("]");
        return sb.toString();
    }
}

