/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNotificationIndicator;

public class GenericNotificationIndicatorImpl
extends AbstractISUPParameter
implements GenericNotificationIndicator {
    private int[] notificationIndicator;

    public GenericNotificationIndicatorImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public GenericNotificationIndicatorImpl() {
    }

    public GenericNotificationIndicatorImpl(int[] notificationIndicator) {
        this.setNotificationIndicator(notificationIndicator);
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must  not be null and length must be 1 or greater");
        }
        this.notificationIndicator = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            int extFlag = b[i] >> 7 & 1;
            if (extFlag == 1 && b.length - 1 > i) {
                throw new ParameterException("Extenstion flag idnicates end of data, however byte[] has more octets. Index: " + i);
            }
            this.notificationIndicator[i] = b[i] & 0x7F;
        }
        return this.notificationIndicator.length;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = new byte[this.notificationIndicator.length];
        for (int index = 0; index < b.length; ++index) {
            b[index] = (byte)(this.notificationIndicator[index] & 0x7F);
        }
        int n = b.length - 1;
        b[n] = (byte)(b[n] | 0x80);
        return b;
    }

    public int[] getNotificationIndicator() {
        return this.notificationIndicator;
    }

    public void setNotificationIndicator(int[] notificationIndicator) {
        if (notificationIndicator == null) {
            throw new IllegalArgumentException("Notification indicator must not be null");
        }
        this.notificationIndicator = notificationIndicator;
    }

    public int getCode() {
        return 44;
    }
}

