/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.parameter;

public enum RefusalCauseValue {
    END_USER_ORIGINATED(0),
    END_USER_CONGESTION(1),
    END_USER_FAILURE(2),
    SCCP_USER_ORIGINATED(3),
    DESTINATION_ADDRESS_UNKNOWN(4),
    DESTINATION_INACCESSIBLE(5),
    NETWORK_RESOURCE_QOS_NOT_AVAILABLE_NON_TRANSIENT(6),
    NETWORK_RESOURCE_QOS_NOT_AVAILABLE_TRANSIENT(7),
    ACCESS_FAILURE(8),
    ACCESS_CONGESTION(9),
    SUBSYSTEM_FAILURE(10),
    SUBSYSTEM_CONGESTION(11),
    EXPIRATION_OF_THE_CONNECTION_ESTABLISHMENT_TIMER(12),
    INCOMPATIBLE_USER_DATA(13),
    UNQUALIFIED(15),
    HOP_COUNTER_VIOLATION(16),
    SCCP_FAILURE(17),
    NO_TRANSLATION_FOR_AN_ADDRESS_OF_SUCH_NATURE(18),
    UNEQUIPPED_USER(19);

    private int code;

    private RefusalCauseValue(int code) {
        this.code = code;
    }

    public int getValue() {
        return this.code;
    }

    public static RefusalCauseValue getInstance(int code) {
        switch (code) {
            case 0: {
                return END_USER_ORIGINATED;
            }
            case 1: {
                return END_USER_CONGESTION;
            }
            case 2: {
                return END_USER_FAILURE;
            }
            case 3: {
                return SCCP_USER_ORIGINATED;
            }
            case 4: {
                return DESTINATION_ADDRESS_UNKNOWN;
            }
            case 5: {
                return DESTINATION_INACCESSIBLE;
            }
            case 6: {
                return NETWORK_RESOURCE_QOS_NOT_AVAILABLE_NON_TRANSIENT;
            }
            case 7: {
                return NETWORK_RESOURCE_QOS_NOT_AVAILABLE_TRANSIENT;
            }
            case 8: {
                return ACCESS_FAILURE;
            }
            case 9: {
                return ACCESS_CONGESTION;
            }
            case 10: {
                return SUBSYSTEM_FAILURE;
            }
            case 11: {
                return SUBSYSTEM_CONGESTION;
            }
            case 12: {
                return EXPIRATION_OF_THE_CONNECTION_ESTABLISHMENT_TIMER;
            }
            case 13: {
                return INCOMPATIBLE_USER_DATA;
            }
            case 15: {
                return UNQUALIFIED;
            }
            case 16: {
                return HOP_COUNTER_VIOLATION;
            }
            case 17: {
                return SCCP_FAILURE;
            }
            case 18: {
                return NO_TRANSLATION_FOR_AN_ADDRESS_OF_SUCH_NATURE;
            }
            case 19: {
                return UNEQUIPPED_USER;
            }
        }
        return UNQUALIFIED;
    }
}

