/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.restcomm.protocols.ss7.sccp.NetworkIdState;
import org.restcomm.protocols.ss7.sccp.OriginationType;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.Router;
import org.restcomm.protocols.ss7.sccp.Rule;
import org.restcomm.protocols.ss7.sccp.RuleType;
import org.restcomm.protocols.ss7.sccp.SccpStack;
import org.restcomm.protocols.ss7.sccp.impl.congestion.NetworkIdStateImpl;
import org.restcomm.protocols.ss7.sccp.impl.congestion.SccpCongestionControl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0001Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0010Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0011Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0100Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.NoGlobalTitle;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.LongMessageRuleImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.LongMessageRuleMap;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3DestinationMap;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointMap;
import org.restcomm.protocols.ss7.sccp.impl.router.RuleComparatorFactory;
import org.restcomm.protocols.ss7.sccp.impl.router.RuleImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.RuleMap;
import org.restcomm.protocols.ss7.sccp.impl.router.SccpAddressMap;
import org.restcomm.protocols.ss7.sccp.impl.router.SccpRouterXMLBinding;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class RouterImpl
implements Router {
    private static final Logger logger = Logger.getLogger(RouterImpl.class);
    private static final String SCCP_ROUTER_PERSIST_DIR_KEY = "sccprouter.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sccprouter2.xml";
    private static final String RULE = "rule";
    private static final String ROUTING_ADDRESS = "routingAddress";
    private static final String LONG_MESSAGE_RULE = "longMessageRule";
    private static final String MTP3_SERVICE_ACCESS_POINT = "sap";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    protected static final SccpRouterXMLBinding binding = new SccpRouterXMLBinding();
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private String persistDir = null;
    private RuleComparatorFactory ruleComparatorFactory = null;
    private RuleMap<Integer, Rule> rulesMap = new RuleMap();
    private SccpAddressMap<Integer, SccpAddressImpl> routingAddresses = new SccpAddressMap();
    private LongMessageRuleMap<Integer, LongMessageRule> longMessageRules = new LongMessageRuleMap();
    private Mtp3ServiceAccessPointMap<Integer, Mtp3ServiceAccessPoint> saps = new Mtp3ServiceAccessPointMap();
    private final String name;
    private final SccpStack sccpStack;

    public RouterImpl(String name, SccpStack sccpStack) {
        this.name = name;
        this.sccpStack = sccpStack;
        this.ruleComparatorFactory = RuleComparatorFactory.getInstance("RuleComparatorFactory");
        binding.setAlias(RuleImpl.class, RULE);
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Mtp3DestinationMap.class, "mtp3DestinationMap");
        binding.setAlias(GlobalTitle0001Impl.class, "GT0001");
        binding.setAlias(GlobalTitle0010Impl.class, "GT0010");
        binding.setAlias(GlobalTitle0011Impl.class, "GT0011");
        binding.setAlias(GlobalTitle0100Impl.class, "GT0100");
        binding.setAlias(NoGlobalTitle.class, "NoGlobalTitle");
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void start() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCCP_ROUTER_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info(String.format("SCCP Router configuration file path %s", this.persistFile.toString()));
        this.load();
        logger.info("Started SCCP Router");
    }

    public void stop() {
        this.store();
    }

    public Rule findRule(SccpAddress calledParty, SccpAddress callingParty, boolean isMtpOriginated, int msgNetworkId) {
        FastCollection.Record e = this.rulesMap.head();
        FastMap.Entry end = this.rulesMap.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Rule rule = (Rule)((FastMap.Entry)e).getValue();
            if (!rule.matches(calledParty, callingParty, isMtpOriginated, msgNetworkId)) continue;
            return rule;
        }
        return null;
    }

    public LongMessageRule findLongMessageRule(int dpc) {
        FastCollection.Record e = this.longMessageRules.head();
        FastMap.Entry end = this.longMessageRules.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            LongMessageRule rule = (LongMessageRule)((FastMap.Entry)e).getValue();
            if (!rule.matches(dpc)) continue;
            return rule;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPoint(int dpc, int sls) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (!sap.matches(dpc, sls)) continue;
            return sap;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPoint(int dpc, int sls, int networkId) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (!sap.matches(dpc, sls) || sap.getNetworkId() != networkId) continue;
            return sap;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPointForIncMes(int localPC, int remotePC, String localGtDigits) {
        Mtp3ServiceAccessPoint sap;
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getLocalGtDigits() == null || sap.getLocalGtDigits().length() <= 0 || sap.getOpc() != localPC || !sap.matches(remotePC) || localGtDigits == null || !localGtDigits.equals(sap.getLocalGtDigits())) continue;
            return sap;
        }
        e = this.saps.head();
        end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getLocalGtDigits() != null && sap.getLocalGtDigits().length() != 0 || sap.getOpc() != localPC || !sap.matches(remotePC)) continue;
            return sap;
        }
        return null;
    }

    @Override
    public Rule getRule(int id) {
        return (Rule)this.rulesMap.get(id);
    }

    @Override
    public SccpAddress getRoutingAddress(int id) {
        return (SccpAddress)this.routingAddresses.get(id);
    }

    @Override
    public LongMessageRule getLongMessageRule(int id) {
        return (LongMessageRule)this.longMessageRules.get(id);
    }

    @Override
    public Mtp3ServiceAccessPoint getMtp3ServiceAccessPoint(int id) {
        return (Mtp3ServiceAccessPoint)this.saps.get(id);
    }

    public boolean spcIsLocal(int spc) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getOpc() != spc) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Integer, Rule> getRules() {
        HashMap<Integer, Rule> rulesMapTmp = new HashMap<Integer, Rule>();
        rulesMapTmp.putAll(this.rulesMap);
        return rulesMapTmp;
    }

    @Override
    public Map<Integer, SccpAddress> getRoutingAddresses() {
        HashMap<Integer, SccpAddress> routingAddressesTmp = new HashMap<Integer, SccpAddress>();
        routingAddressesTmp.putAll(this.routingAddresses);
        return routingAddressesTmp;
    }

    @Override
    public Map<Integer, LongMessageRule> getLongMessageRules() {
        HashMap<Integer, LongMessageRule> longMessageRulesTmp = new HashMap<Integer, LongMessageRule>();
        longMessageRulesTmp.putAll(this.longMessageRules);
        return longMessageRulesTmp;
    }

    @Override
    public Map<Integer, Mtp3ServiceAccessPoint> getMtp3ServiceAccessPoints() {
        HashMap<Integer, Mtp3ServiceAccessPoint> sapsTmp = new HashMap<Integer, Mtp3ServiceAccessPoint>();
        sapsTmp.putAll(this.saps);
        return sapsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId, int networkId, SccpAddress patternCallingAddress) throws Exception {
        int patternNumberOfSecs;
        Rule ruleTmp = this.getRule(id);
        if (ruleTmp != null) {
            throw new Exception("Rule already exist");
        }
        int maskumberOfSecs = mask.split("/").length - 1;
        if (maskumberOfSecs != (patternNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1)) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in pattern GlobalTitle digits");
        }
        SccpAddress pAddress = this.getRoutingAddress(pAddressId);
        if (pAddress == null) {
            throw new Exception(String.format("No primary address defined for id=%d", pAddressId));
        }
        int primAddNumberOfSecs = pAddress.getGlobalTitle().getDigits().split("/").length - 1;
        if (maskumberOfSecs != primAddNumberOfSecs) {
            throw new Exception("Number of sections in mask doesn't match with number of sections in primary address GlobalTitle digits");
        }
        if (sAddressId != -1) {
            SccpAddress sAddress = this.getRoutingAddress(sAddressId);
            if (sAddress == null) {
                throw new Exception(String.format("No backup address defined for id=%d", sAddressId));
            }
            int secAddNumberOfSecs = sAddress.getGlobalTitle().getDigits().split("/").length - 1;
            if (maskumberOfSecs != secAddNumberOfSecs) {
                throw new Exception("Number of sections in mask doesn't match with number of sections in secondary address GlobalTitle digits");
            }
        }
        if (sAddressId == -1 && ruleType != RuleType.SOLITARY) {
            throw new Exception("If RuleType is not Solitary, specifying Secondar Address is mandatory");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            RuleImpl rule = new RuleImpl(ruleType, algo, originationType, pattern, mask, networkId, patternCallingAddress);
            rule.setPrimaryAddressId(pAddressId);
            rule.setSecondaryAddressId(sAddressId);
            rule.setNewCallingPartyAddressId(newCallingPartyAddressAddressId);
            rule.setRuleId(id);
            RuleImpl[] rulesArray = new RuleImpl[this.rulesMap.size() + 1];
            int count = 0;
            FastCollection.Record e = this.rulesMap.head();
            FastMap.Entry end = this.rulesMap.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Integer ruleId = (Integer)((FastMap.Entry)e).getKey();
                RuleImpl ruleTemp1 = (RuleImpl)((FastMap.Entry)e).getValue();
                ruleTemp1.setRuleId(ruleId);
                rulesArray[count++] = ruleTemp1;
            }
            rulesArray[count++] = rule;
            Arrays.sort(rulesArray, this.ruleComparatorFactory.getRuleComparator());
            RuleMap newRule = new RuleMap();
            for (int i = 0; i < rulesArray.length; ++i) {
                RuleImpl ruleTemp = rulesArray[i];
                newRule.put(ruleTemp.getRuleId(), ruleTemp);
            }
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId, int networkId, SccpAddress patternCallingAddress) throws Exception {
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            int patternNumberOfSecs;
            Rule ruleTmp = this.getRule(id);
            if (ruleTmp == null) {
                throw new Exception(String.format("Rule doesn't exist on stack=%s", this.name));
            }
            int maskumberOfSecs = mask.split("/").length - 1;
            if (maskumberOfSecs != (patternNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1)) {
                throw new Exception("Number of sections in mask doesn't match with number of sections in pattern GlobalTitle digits");
            }
            SccpAddress pAddress = this.getRoutingAddress(pAddressId);
            if (pAddress == null) {
                throw new Exception(String.format("No primary address defined for id=%d", pAddressId));
            }
            int primAddNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1;
            if (maskumberOfSecs != primAddNumberOfSecs) {
                throw new Exception("Number of sections in mask doesn't match with number of sections in primary address GlobalTitle digits");
            }
            if (sAddressId != -1) {
                SccpAddress sAddress = this.getRoutingAddress(sAddressId);
                if (sAddress == null) {
                    throw new Exception(String.format("No backup address defined for id=%d", sAddressId));
                }
                int secAddNumberOfSecs = pattern.getGlobalTitle().getDigits().split("/").length - 1;
                if (maskumberOfSecs != secAddNumberOfSecs) {
                    throw new Exception("Number of sections in mask doesn't match with number of sections in secondary address GlobalTitle digits");
                }
            }
            if (sAddressId == -1 && ruleType != RuleType.SOLITARY) {
                throw new Exception("If RuleType is not Solitary, specifying Secondar Address is mandatory");
            }
            RuleImpl rule = new RuleImpl(ruleType, algo, originationType, pattern, mask, networkId, patternCallingAddress);
            rule.setPrimaryAddressId(pAddressId);
            rule.setSecondaryAddressId(sAddressId);
            rule.setNewCallingPartyAddressId(newCallingPartyAddressAddressId);
            rule.setRuleId(id);
            RuleImpl[] rulesArray = new RuleImpl[this.rulesMap.size()];
            int count = 0;
            this.removeRule(id);
            FastCollection.Record e = this.rulesMap.head();
            FastMap.Entry end = this.rulesMap.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Integer ruleId = (Integer)((FastMap.Entry)e).getKey();
                RuleImpl ruleTemp1 = (RuleImpl)((FastMap.Entry)e).getValue();
                ruleTemp1.setRuleId(ruleId);
                rulesArray[count++] = ruleTemp1;
            }
            rulesArray[count++] = rule;
            Arrays.sort(rulesArray, this.ruleComparatorFactory.getRuleComparator());
            RuleMap newRule = new RuleMap();
            for (int i = 0; i < rulesArray.length; ++i) {
                RuleImpl ruleTemp = rulesArray[i];
                newRule.put(ruleTemp.getRuleId(), ruleTemp);
            }
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(int id) throws Exception {
        if (this.getRule(id) == null) {
            throw new Exception(String.format("Rule doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            RuleMap newRule = new RuleMap();
            newRule.putAll(this.rulesMap);
            newRule.remove(id);
            this.rulesMap = newRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoutingAddress(int primAddressId, SccpAddress primaryAddress) throws Exception {
        if (this.getRoutingAddress(primAddressId) != null) {
            throw new Exception("Address already exist");
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll(this.routingAddresses);
            newPrimaryAddress.put(primAddressId, (SccpAddressImpl)primaryAddress);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyRoutingAddress(int primAddressId, SccpAddress primaryAddress) throws Exception {
        if (this.getRoutingAddress(primAddressId) == null) {
            throw new Exception(String.format("Address doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll(this.routingAddresses);
            newPrimaryAddress.put(primAddressId, (SccpAddressImpl)primaryAddress);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoutingAddress(int id) throws Exception {
        if (this.getRoutingAddress(id) == null) {
            throw new Exception(String.format("Address doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            SccpAddressMap newPrimaryAddress = new SccpAddressMap();
            newPrimaryAddress.putAll(this.routingAddresses);
            newPrimaryAddress.remove(id);
            this.routingAddresses = newPrimaryAddress;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) != null) {
            throw new Exception("Long message rule already exists");
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception(String.format("Long message rule doesn't exist on stack=%s", this.name));
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLongMessageRule(int id) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception(String.format("Long message rule doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.remove(id);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    @Override
    public void addMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.addMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    @Override
    public void modifyMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.modifyMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    @Override
    public void removeMtp3Destination(int sapId, int destId) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.removeMtp3Destination(destId);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId, String localGtDigits) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) != null) {
            throw new Exception("Service access point already exists");
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        if (localGtDigits != null && (localGtDigits.equals("null") || localGtDigits.equals(""))) {
            localGtDigits = null;
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni, this.name, networkId, localGtDigits);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId, String localGtDigits) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        if (localGtDigits != null && (localGtDigits.equals("null") || localGtDigits.equals(""))) {
            localGtDigits = null;
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni, this.name, networkId, localGtDigits);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMtp3ServiceAccessPoint(int id) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.remove(id);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllResourses() {
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            if (this.rulesMap.size() == 0 && this.routingAddresses.size() == 0 && this.longMessageRules.size() == 0 && this.saps.size() == 0) {
                return;
            }
            this.rulesMap = new RuleMap();
            this.routingAddresses = new SccpAddressMap();
            this.longMessageRules = new LongMessageRuleMap();
            this.saps = new Mtp3ServiceAccessPointMap();
            this.store();
        }
    }

    public FastMap<Integer, NetworkIdState> getNetworkIdStateList() {
        return this.getNetworkIdList(-1);
    }

    public FastMap<Integer, NetworkIdState> getNetworkIdList(int affectedPc) {
        FastMap<Integer, NetworkIdState> res = new FastMap<Integer, NetworkIdState>();
        FastCollection.Record e = this.rulesMap.head();
        FastMap.Entry end = this.rulesMap.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Rule rule = (Rule)((FastMap.Entry)e).getValue();
            NetworkIdStateImpl networkIdState = this.getRoutingAddressStatusForRoutingRule(rule, affectedPc);
            if (networkIdState == null) continue;
            NetworkIdState prevNetworkIdState = res.get(rule.getNetworkId());
            if (prevNetworkIdState != null) {
                if (!prevNetworkIdState.isAvailavle()) continue;
                if (networkIdState.isAvailavle()) {
                    if (prevNetworkIdState.getCongLevel() >= networkIdState.getCongLevel()) continue;
                    res.put(rule.getNetworkId(), networkIdState);
                    continue;
                }
                res.put(rule.getNetworkId(), networkIdState);
                continue;
            }
            res.put(rule.getNetworkId(), networkIdState);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NetworkIdStateImpl getRoutingAddressStatusForRoutingRule(Rule rule, int affectedPc) {
        SccpAddress translationAddressPri = this.getRoutingAddress(rule.getPrimaryAddressId());
        NetworkIdStateImpl rspStatusPri = this.getRoutingAddressStatusForRoutingAddress(translationAddressPri, affectedPc);
        if (rule.getRuleType() == RuleType.DOMINANT || rule.getRuleType() == RuleType.LOADSHARED) {
            SccpAddress translationAddressSec = this.getRoutingAddress(rule.getSecondaryAddressId());
            NetworkIdStateImpl rspStatusSec = this.getRoutingAddressStatusForRoutingAddress(translationAddressSec, affectedPc);
            if (!rspStatusPri.isAffectedByPc() && !rspStatusSec.isAffectedByPc()) return null;
            if (rule.getRuleType() == RuleType.DOMINANT) {
                if (!rspStatusPri.isAvailavle()) return rspStatusSec;
                return rspStatusPri;
            }
            if (rule.getRuleType() != RuleType.LOADSHARED) return null;
            if (rspStatusPri.isAvailavle()) {
                if (!rspStatusSec.isAvailavle()) return rspStatusPri;
                if (rspStatusPri.getCongLevel() < rspStatusSec.getCongLevel()) return rspStatusSec;
                return rspStatusPri;
            }
            if (!rspStatusSec.isAvailavle()) return rspStatusPri;
            return rspStatusSec;
        }
        if (!rspStatusPri.isAffectedByPc()) return null;
        return rspStatusPri;
    }

    private NetworkIdStateImpl getRoutingAddressStatusForRoutingAddress(SccpAddress routingAddress, int affectedPc) {
        if (routingAddress != null && routingAddress.getAddressIndicator().isPCPresent()) {
            boolean spcIsLocal;
            boolean affectedByPc = true;
            if (affectedPc >= 0 && routingAddress.getSignalingPointCode() != affectedPc) {
                affectedByPc = false;
            }
            if (spcIsLocal = this.spcIsLocal(routingAddress.getSignalingPointCode())) {
                return new NetworkIdStateImpl(affectedByPc);
            }
            RemoteSignalingPointCode remoteSpc = this.sccpStack.getSccpResource().getRemoteSpcByPC(routingAddress.getSignalingPointCode());
            if (remoteSpc == null) {
                return new NetworkIdStateImpl(affectedByPc);
            }
            if (remoteSpc.isRemoteSpcProhibited()) {
                return new NetworkIdStateImpl(false, affectedByPc);
            }
            int congLevel = SccpCongestionControl.generateSccpUserCongLevel(remoteSpc.getCurrentRestrictionLevel());
            if (congLevel > 0) {
                return new NetworkIdStateImpl(congLevel, affectedByPc);
            }
            return new NetworkIdStateImpl(affectedByPc);
        }
        return new NetworkIdStateImpl(false);
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.rulesMap, RULE, RuleMap.class);
            writer.write(this.routingAddresses, ROUTING_ADDRESS, SccpAddressMap.class);
            writer.write(this.longMessageRules, LONG_MESSAGE_RULE, LongMessageRuleMap.class);
            writer.write(this.saps, MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error while persisting the Rule state in file", e);
        }
    }

    protected void load() {
        try {
            File f = new File(this.persistFile.toString());
            if (f.exists()) {
                this.loadVer3(this.persistFile.toString());
            } else {
                String s1 = this.persistFile.toString().replace("2.xml", ".xml");
                f = new File(s1);
                if (f.exists() && !this.loadVer1(s1)) {
                    this.loadVer2(s1);
                }
                this.store();
                f.delete();
            }
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            logger.error(String.format("Failed to load the SS7 configuration file. \n%s", ex.getMessage()));
        }
        catch (FileNotFoundException e) {
            logger.warn(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
    }

    private void moveBackupToRoutingAddress(SccpAddressMap<Integer, SccpAddress> backupAddresses) {
        FastMap<Integer, Integer> lstChange = new FastMap<Integer, Integer>();
        for (Integer bId : backupAddresses.keySet()) {
            SccpAddress addr = (SccpAddress)backupAddresses.get(bId);
            int i1 = bId + 100;
            while (this.routingAddresses.get(i1) != null) {
                ++i1;
            }
            this.routingAddresses.putEntry(i1, (SccpAddressImpl)addr);
            lstChange.putEntry(bId, i1);
        }
        for (Rule rule : this.rulesMap.values()) {
            Integer newVal = (Integer)lstChange.get(rule.getSecondaryAddressId());
            if (newVal == null) continue;
            ((RuleImpl)rule).setSecondaryAddressId(newVal);
        }
    }

    private boolean loadVer1(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        s2 = s2.replace("type=\"rule\"", "");
        s2 = s2.replace("pattern type=\"org.restcomm.protocols.ss7.sccp.parameter.SccpAddress\"", "patternSccpAddress");
        s2 = s2.replace("ai type=\"org.restcomm.protocols.ss7.indicator.AddressIndicator\" ai=", "ai value=");
        s2 = s2.replace("gt type=\"org.restcomm.protocols.ss7.sccp.parameter.", "gt type=\"");
        s2 = s2.replace("Key type=\"java.lang.Integer\"", "id");
        s2 = s2.replace("Value", "value");
        s2 = s2.replace("/pattern", "/patternSccpAddress");
        s2 = s2.replace("value type=\"org.restcomm.protocols.ss7.sccp.parameter.SccpAddress\"", "sccpAddress");
        s2 = s2.replace("</value>\r\n</primaryAddress>", "</sccpAddress>\r\n</primaryAddress>");
        s2 = s2.replace("</value>\n</primaryAddress>", "</sccpAddress>\n</primaryAddress>");
        s2 = s2.replace("</value>\r\n</backupAddress>", "</sccpAddress>\r\n</backupAddress>");
        s2 = s2.replace("</value>\n</backupAddress>", "</sccpAddress>\n</backupAddress>");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.", "type=\"");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPoint\"", "");
        s2 = s2.replace("javolution.util.FastMap", "mtp3DestinationMap");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.impl.router.Mtp3Destination\"", "");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance(sr);
        reader.setBinding(binding);
        XMLBinding binding2 = new XMLBinding();
        binding2.setClassAttribute(CLASS_ATTRIBUTE);
        String BACKUP_ADDRESS_V2 = "backupAddress";
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        try {
            this.rulesMap = reader.read(RULE, RuleMap.class);
        }
        catch (XMLStreamException e) {
            return false;
        }
        this.routingAddresses = reader.read(ROUTING_ADDRESS_V2, SccpAddressMap.class);
        SccpAddressMap backupAddresses = reader.read(BACKUP_ADDRESS_V2, SccpAddressMap.class);
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
        this.moveBackupToRoutingAddress(backupAddresses);
        return true;
    }

    private void loadVer2(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance(sr);
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        String BACKUP_ADDRESS_V2 = "backupAddress";
        reader.setBinding(binding);
        this.rulesMap = reader.read(RULE, RuleMap.class);
        this.routingAddresses = reader.read(ROUTING_ADDRESS_V2, SccpAddressMap.class);
        SccpAddressMap backupAddresses = reader.read(BACKUP_ADDRESS_V2, SccpAddressMap.class);
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
        this.moveBackupToRoutingAddress(backupAddresses);
    }

    protected void loadVer3(String fn) throws XMLStreamException, FileNotFoundException {
        XMLObjectReader reader = XMLObjectReader.newInstance(new FileInputStream(fn));
        reader.setBinding(binding);
        this.loadVer3(reader);
    }

    protected void loadVer3(XMLObjectReader reader) throws XMLStreamException {
        this.rulesMap = reader.read(RULE, RuleMap.class);
        this.routingAddresses = reader.read(ROUTING_ADDRESS, SccpAddressMap.class);
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
    }
}

