/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import org.restcomm.protocols.ss7.indicator.GlobalTitleIndicator;
import org.restcomm.protocols.ss7.indicator.NatureOfAddress;
import org.restcomm.protocols.ss7.indicator.NumberingPlan;
import org.restcomm.protocols.ss7.indicator.RoutingIndicator;
import org.restcomm.protocols.ss7.sccp.impl.parameter.BCDEvenEncodingScheme;
import org.restcomm.protocols.ss7.sccp.impl.parameter.BCDOddEncodingScheme;
import org.restcomm.protocols.ss7.sccp.impl.parameter.DefaultEncodingScheme;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0001Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0010Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0011Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.GlobalTitle0100Impl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.HopCounterImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.NoGlobalTitle;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ReturnCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SegmentationImpl;
import org.restcomm.protocols.ss7.sccp.parameter.EncodingScheme;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0001;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0010;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0011;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.restcomm.protocols.ss7.sccp.parameter.HopCounter;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.protocols.ss7.sccp.parameter.Segmentation;

public class ParameterFactoryImpl
implements ParameterFactory {
    @Override
    public SccpAddress createSccpAddress(RoutingIndicator ri, GlobalTitle gt, int dpc, int ssn) {
        return new SccpAddressImpl(ri, gt, dpc, ssn);
    }

    @Override
    public Importance createImportance(int value) {
        return new ImportanceImpl((byte)value);
    }

    @Override
    public HopCounter createHopCounter(int hopCount) {
        return new HopCounterImpl(hopCount);
    }

    @Override
    public ProtocolClass createProtocolClass(int pClass, boolean returnMessageOnError) {
        return new ProtocolClassImpl(pClass, returnMessageOnError);
    }

    @Override
    public Segmentation createSegmentation() {
        return new SegmentationImpl();
    }

    @Override
    public ReturnCause createReturnCause(ReturnCauseValue cause) {
        return new ReturnCauseImpl(cause);
    }

    @Override
    public EncodingScheme createEncodingScheme(byte i) {
        switch (i) {
            case 0: {
                return DefaultEncodingScheme.INSTANCE;
            }
            case 1: {
                return BCDOddEncodingScheme.INSTANCE;
            }
            case 2: {
                return BCDEvenEncodingScheme.INSTANCE;
            }
        }
        return DefaultEncodingScheme.INSTANCE;
    }

    @Override
    public GlobalTitle createGlobalTitle(GlobalTitleIndicator globalTitleIndicator) {
        switch (globalTitleIndicator) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                return new GlobalTitle0001Impl();
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                return new GlobalTitle0011Impl();
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                return new GlobalTitle0100Impl();
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                return new GlobalTitle0010Impl();
            }
            case NO_GLOBAL_TITLE_INCLUDED: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public GlobalTitle0001 createGlobalTitle(String digits, NatureOfAddress noa) {
        return new GlobalTitle0001Impl(digits, noa);
    }

    @Override
    public GlobalTitle0010 createGlobalTitle(String digits, int translationType) {
        return new GlobalTitle0010Impl(digits, translationType);
    }

    @Override
    public GlobalTitle0011 createGlobalTitle(String digits, int translationType, NumberingPlan numberingPlan, EncodingScheme encodingScheme) {
        return new GlobalTitle0011Impl(digits, translationType, this.getEncodingScheme(encodingScheme, digits), numberingPlan);
    }

    @Override
    public GlobalTitle0100 createGlobalTitle(String digits, int translationType, NumberingPlan numberingPlan, EncodingScheme encodingScheme, NatureOfAddress noa) {
        return new GlobalTitle0100Impl(digits, translationType, this.getEncodingScheme(encodingScheme, digits), numberingPlan, noa);
    }

    @Override
    public GlobalTitle createGlobalTitle(String digits) {
        return new NoGlobalTitle(digits);
    }

    protected EncodingScheme getEncodingScheme(EncodingScheme encodingScheme, String digits) {
        if (encodingScheme != null) {
            return encodingScheme;
        }
        if (digits.length() % 2 == 0) {
            return BCDEvenEncodingScheme.INSTANCE;
        }
        return BCDOddEncodingScheme.INSTANCE;
    }
}

