/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.ConcernedSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.RemoteSubSystem;
import org.restcomm.protocols.ss7.sccp.SccpResource;
import org.restcomm.protocols.ss7.sccp.impl.ConcernedSignalingPointCodeImpl;
import org.restcomm.protocols.ss7.sccp.impl.ConcernedSignalingPointCodeMap;
import org.restcomm.protocols.ss7.sccp.impl.RemoteSignalingPointCodeImpl;
import org.restcomm.protocols.ss7.sccp.impl.RemoteSignalingPointCodeMap;
import org.restcomm.protocols.ss7.sccp.impl.RemoteSubSystemImpl;
import org.restcomm.protocols.ss7.sccp.impl.RemoteSubSystemMap;
import org.restcomm.protocols.ss7.sccp.impl.SccpResourceXMLBinding;

public class SccpResourceImpl
implements SccpResource {
    private static final Logger logger = Logger.getLogger(SccpResourceImpl.class);
    protected RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = new RemoteSubSystemMap();
    protected RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode> remoteSpcs = new RemoteSignalingPointCodeMap();
    protected ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> concernedSpcs = new ConcernedSignalingPointCodeMap();
    private final String name;
    private String persistDir = null;
    protected final boolean rspProhibitedByDefault;
    private final PersistentStorage persistanceStorage = new PersistentStorage();

    public SccpResourceImpl(String name) {
        this(name, false);
    }

    public SccpResourceImpl(String name, boolean rspProhibitedByDefault) {
        this.name = name;
        this.rspProhibitedByDefault = rspProhibitedByDefault;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void start() {
        this.persistanceStorage.setPersistDir(this.persistDir, this.name);
        this.load();
        logger.info("Started Sccp Resource");
    }

    public void stop() {
        this.store();
    }

    protected void load() {
        PersistentStorage.ResourcesSet resources = this.persistanceStorage.load();
        if (resources == null) {
            return;
        }
        for (RemoteSignalingPointCode rsp : resources.remoteSpcs.values()) {
            ((RemoteSignalingPointCodeImpl)rsp).setProhibitedState(this.rspProhibitedByDefault, this.rspProhibitedByDefault);
        }
        this.remoteSpcs = resources.remoteSpcs;
        this.remoteSsns = resources.remoteSsns;
        this.concernedSpcs = resources.concernedSpcs;
    }

    protected synchronized void store() {
        this.persistanceStorage.store(this.remoteSpcs, this.remoteSsns, this.concernedSpcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteSsn(int remoteSsnid, int remoteSpc, int remoteSsn, int remoteSsnFlag, boolean markProhibitedWhenSpcResuming) throws Exception {
        if (this.getRemoteSsn(remoteSsnid) != null) {
            throw new Exception("Remote Subsystem already exists");
        }
        RemoteSubSystemImpl rsscObj = new RemoteSubSystemImpl(remoteSpc, remoteSsn, remoteSsnFlag, markProhibitedWhenSpcResuming);
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            RemoteSubSystemMap newRemoteSsns = new RemoteSubSystemMap();
            newRemoteSsns.putAll(this.remoteSsns);
            newRemoteSsns.put(remoteSsnid, rsscObj);
            this.remoteSsns = newRemoteSsns;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyRemoteSsn(int remoteSsnid, int remoteSpc, int remoteSsn, int remoteSsnFlag, boolean markProhibitedWhenSpcResuming) throws Exception {
        RemoteSubSystemImpl rsscObj = (RemoteSubSystemImpl)this.remoteSsns.get(remoteSsnid);
        if (rsscObj == null) {
            throw new Exception(String.format("Remote Subsystem doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            rsscObj.setRemoteSsn(remoteSsn);
            rsscObj.setRemoteSpc(remoteSpc);
            rsscObj.setRemoteSsnFlag(remoteSsnFlag);
            rsscObj.setMarkProhibitedWhenSpcResuming(markProhibitedWhenSpcResuming);
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteSsn(int remoteSsnid) throws Exception {
        if (this.getRemoteSsn(remoteSsnid) == null) {
            throw new Exception(String.format("Remote Subsystem doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            RemoteSubSystemMap newRemoteSsns = new RemoteSubSystemMap();
            newRemoteSsns.putAll(this.remoteSsns);
            newRemoteSsns.remove(remoteSsnid);
            this.remoteSsns = newRemoteSsns;
            this.store();
        }
    }

    @Override
    public RemoteSubSystem getRemoteSsn(int remoteSsnid) {
        return (RemoteSubSystem)this.remoteSsns.get(remoteSsnid);
    }

    @Override
    public RemoteSubSystem getRemoteSsn(int spc, int remoteSsn) {
        FastCollection.Record e = this.remoteSsns.head();
        FastMap.Entry end = this.remoteSsns.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            RemoteSubSystem remoteSubSystem = (RemoteSubSystem)((FastMap.Entry)e).getValue();
            if (remoteSubSystem.getRemoteSpc() != spc || remoteSsn != remoteSubSystem.getRemoteSsn()) continue;
            return remoteSubSystem;
        }
        return null;
    }

    @Override
    public Map<Integer, RemoteSubSystem> getRemoteSsns() {
        HashMap<Integer, RemoteSubSystem> remoteSsnsTmp = new HashMap<Integer, RemoteSubSystem>();
        remoteSsnsTmp.putAll(this.remoteSsns);
        return remoteSsnsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteSpc(int remoteSpcId, int remoteSpc, int remoteSpcFlag, int mask) throws Exception {
        if (this.getRemoteSpc(remoteSpcId) != null) {
            throw new Exception("Remote Signaling Pointcode already exists");
        }
        RemoteSignalingPointCodeImpl rspcObj = new RemoteSignalingPointCodeImpl(remoteSpc, remoteSpcFlag, mask, this.rspProhibitedByDefault);
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            RemoteSignalingPointCodeMap newRemoteSpcs = new RemoteSignalingPointCodeMap();
            newRemoteSpcs.putAll(this.remoteSpcs);
            newRemoteSpcs.put(remoteSpcId, rspcObj);
            this.remoteSpcs = newRemoteSpcs;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyRemoteSpc(int remoteSpcId, int remoteSpc, int remoteSpcFlag, int mask) throws Exception {
        RemoteSignalingPointCodeImpl remoteSignalingPointCode = (RemoteSignalingPointCodeImpl)this.getRemoteSpc(remoteSpcId);
        if (remoteSignalingPointCode == null) {
            throw new Exception(String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            remoteSignalingPointCode.setRemoteSpc(remoteSpc);
            remoteSignalingPointCode.setRemoteSpcFlag(remoteSpcFlag);
            remoteSignalingPointCode.setMask(mask);
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteSpc(int remoteSpcId) throws Exception {
        if (this.getRemoteSpc(remoteSpcId) == null) {
            throw new Exception(String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            RemoteSignalingPointCodeMap newRemoteSpcs = new RemoteSignalingPointCodeMap();
            newRemoteSpcs.putAll(this.remoteSpcs);
            newRemoteSpcs.remove(remoteSpcId);
            this.remoteSpcs = newRemoteSpcs;
            this.store();
        }
    }

    @Override
    public RemoteSignalingPointCode getRemoteSpc(int remoteSpcId) {
        return (RemoteSignalingPointCode)this.remoteSpcs.get(remoteSpcId);
    }

    @Override
    public RemoteSignalingPointCode getRemoteSpcByPC(int remotePC) {
        FastCollection.Record e = this.remoteSpcs.head();
        FastMap.Entry end = this.remoteSpcs.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            RemoteSignalingPointCode remoteSignalingPointCode = (RemoteSignalingPointCode)((FastMap.Entry)e).getValue();
            if (remoteSignalingPointCode.getRemoteSpc() != remotePC) continue;
            return remoteSignalingPointCode;
        }
        return null;
    }

    @Override
    public Map<Integer, RemoteSignalingPointCode> getRemoteSpcs() {
        HashMap<Integer, RemoteSignalingPointCode> remoteSpcsTmp = new HashMap<Integer, RemoteSignalingPointCode>();
        remoteSpcsTmp.putAll(this.remoteSpcs);
        return remoteSpcsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConcernedSpc(int concernedSpcId, int remoteSpc) throws Exception {
        if (this.getConcernedSpc(concernedSpcId) != null) {
            throw new Exception("Concerned spc already exists");
        }
        ConcernedSignalingPointCodeImpl concernedSpc = new ConcernedSignalingPointCodeImpl(remoteSpc);
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            ConcernedSignalingPointCodeMap newConcernedSpcs = new ConcernedSignalingPointCodeMap();
            newConcernedSpcs.putAll(this.concernedSpcs);
            newConcernedSpcs.put(concernedSpcId, concernedSpc);
            this.concernedSpcs = newConcernedSpcs;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConcernedSpc(int concernedSpcId) throws Exception {
        if (this.getConcernedSpc(concernedSpcId) == null) {
            throw new Exception(String.format("Concerned spc doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            ConcernedSignalingPointCodeMap newConcernedSpcs = new ConcernedSignalingPointCodeMap();
            newConcernedSpcs.putAll(this.concernedSpcs);
            newConcernedSpcs.remove(concernedSpcId);
            this.concernedSpcs = newConcernedSpcs;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyConcernedSpc(int concernedSpcId, int remoteSpc) throws Exception {
        ConcernedSignalingPointCodeImpl concernedSignalingPointCode = (ConcernedSignalingPointCodeImpl)this.getConcernedSpc(concernedSpcId);
        if (concernedSignalingPointCode == null) {
            throw new Exception(String.format("Concerned spc doesn't exist on stack=%s", this.name));
        }
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            concernedSignalingPointCode.setRemoteSpc(remoteSpc);
            this.store();
        }
    }

    @Override
    public ConcernedSignalingPointCode getConcernedSpc(int concernedSpcId) {
        return (ConcernedSignalingPointCode)this.concernedSpcs.get(concernedSpcId);
    }

    @Override
    public ConcernedSignalingPointCode getConcernedSpcByPC(int remotePC) {
        FastCollection.Record e = this.concernedSpcs.head();
        FastMap.Entry end = this.concernedSpcs.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            ConcernedSignalingPointCode concernedSubSystem = (ConcernedSignalingPointCode)((FastMap.Entry)e).getValue();
            if (concernedSubSystem.getRemoteSpc() != remotePC) continue;
            return concernedSubSystem;
        }
        return null;
    }

    @Override
    public Map<Integer, ConcernedSignalingPointCode> getConcernedSpcs() {
        HashMap<Integer, ConcernedSignalingPointCode> concernedSpcsTmp = new HashMap<Integer, ConcernedSignalingPointCode>();
        concernedSpcsTmp.putAll(this.concernedSpcs);
        return concernedSpcsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllResourses() {
        SccpResourceImpl sccpResourceImpl = this;
        synchronized (sccpResourceImpl) {
            if (this.remoteSsns.size() == 0 && this.remoteSpcs.size() == 0 && this.concernedSpcs.size() == 0) {
                return;
            }
            this.remoteSsns = new RemoteSubSystemMap();
            this.remoteSpcs = new RemoteSignalingPointCodeMap();
            this.concernedSpcs = new ConcernedSignalingPointCodeMap();
            this.store();
        }
    }

    protected static class PersistentStorage {
        private static final Logger logger = Logger.getLogger(SccpResourceImpl.class);
        private static final String SCCP_RESOURCE_PERSIST_DIR_KEY = "sccpresource.persist.dir";
        private static final String USER_DIR_KEY = "user.dir";
        private static final String PERSIST_FILE_NAME = "sccpresource2.xml";
        private static final String REMOTE_SSN = "remoteSsns";
        private static final String REMOTE_SPC = "remoteSpcs";
        private static final String CONCERNED_SPC = "concernedSpcs";
        private final TextBuilder persistFile = TextBuilder.newInstance();
        protected static final SccpResourceXMLBinding binding = new SccpResourceXMLBinding();
        private static final String TAB_INDENT = "\t";
        private static final String CLASS_ATTRIBUTE = "type";

        protected PersistentStorage() {
            binding.setClassAttribute(CLASS_ATTRIBUTE);
            binding.setAlias(RemoteSubSystemImpl.class, "remoteSubSystem");
        }

        private void setPersistDir(String persistDir, String stackName) {
            this.persistFile.clear();
            if (persistDir != null) {
                this.persistFile.append(persistDir).append(File.separator).append(stackName).append("_").append(PERSIST_FILE_NAME);
            } else {
                this.persistFile.append(System.getProperty(SCCP_RESOURCE_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(stackName).append("_").append(PERSIST_FILE_NAME);
            }
            logger.info(String.format("SCCP Resource configuration file path %s", this.persistFile.toString()));
        }

        private void store(RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode> remoteSpcs, RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns, ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> concernedSpcs) {
            try {
                XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
                writer.setBinding(binding);
                writer.setIndentation(TAB_INDENT);
                writer.write(remoteSsns, REMOTE_SSN, RemoteSubSystemMap.class);
                writer.write(remoteSpcs, REMOTE_SPC, RemoteSignalingPointCodeMap.class);
                writer.write(concernedSpcs, CONCERNED_SPC, ConcernedSignalingPointCodeMap.class);
                writer.close();
            }
            catch (Exception e) {
                logger.error("Error while persisting the Sccp Resource state in file", e);
            }
        }

        protected ResourcesSet load() {
            ResourcesSet resources = null;
            try {
                File f = new File(this.persistFile.toString());
                if (f.exists()) {
                    resources = this.loadVer3(this.persistFile.toString());
                } else {
                    String s1 = this.persistFile.toString().replace("2.xml", ".xml");
                    f = new File(s1);
                    if (f.exists() && (resources = this.loadVer1(s1)) == null) {
                        resources = this.loadVer2(s1);
                    }
                    f.delete();
                }
            }
            catch (XMLStreamException ex) {
                logger.error(String.format("Failed to load the SS7 configuration file. \n%s", ex.getMessage()));
            }
            catch (FileNotFoundException e) {
                logger.warn(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
            }
            catch (IOException e) {
                logger.error(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
            }
            return resources;
        }

        private ResourcesSet loadVer1(String fn) throws XMLStreamException, IOException {
            Object val;
            String s1;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
            StringBuilder sb = new StringBuilder();
            while ((s1 = br.readLine()) != null) {
                sb.append(s1);
                sb.append("\n");
            }
            br.close();
            String s2 = sb.toString();
            s2 = s2.replace("impl.RemoteSubSystem", "impl.RemoteSubSystemImpl");
            s2 = s2.replace("impl.RemoteSignalingPointCode", "impl.RemoteSignalingPointCodeImpl");
            s2 = s2.replace("impl.ConcernedSignalingPointCode", "impl.ConcernedSignalingPointCodeImpl");
            StringReader sr = new StringReader(s2);
            XMLObjectReader reader = XMLObjectReader.newInstance(sr);
            reader.setBinding(binding);
            String REMOTE_SSN_V1 = "remoteSsn";
            String REMOTE_SPC_V1 = "remoteSpc";
            String CONCERNED_SPC_V1 = "concernedSpc";
            XMLBinding binding2 = new XMLBinding();
            binding2.setClassAttribute(CLASS_ATTRIBUTE);
            FastMap remoteSsnsX = reader.read(REMOTE_SSN_V1, FastMap.class);
            FastMap remoteSpcsX = reader.read(REMOTE_SPC_V1, FastMap.class);
            FastMap concernedSpcsX = reader.read(CONCERNED_SPC_V1, FastMap.class);
            reader.close();
            if (remoteSsnsX == null) {
                return null;
            }
            RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns = new RemoteSubSystemMap<Integer, RemoteSubSystem>();
            RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode> remoteSpcs = new RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode>();
            ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> concernedSpcs = new ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode>();
            for (Integer id : remoteSsnsX.keySet()) {
                val = (RemoteSubSystem)remoteSsnsX.get(id);
                remoteSsns.put(id, val);
            }
            for (Integer id : remoteSpcsX.keySet()) {
                val = (RemoteSignalingPointCode)remoteSpcsX.get(id);
                remoteSpcs.put(id, val);
            }
            for (Integer id : concernedSpcsX.keySet()) {
                val = (ConcernedSignalingPointCode)concernedSpcsX.get(id);
                concernedSpcs.put(id, val);
            }
            return new ResourcesSet(remoteSpcs, remoteSsns, concernedSpcs);
        }

        private ResourcesSet loadVer2(String fn) throws XMLStreamException, FileNotFoundException {
            XMLObjectReader reader = XMLObjectReader.newInstance(new FileInputStream(fn));
            reader.setBinding(binding);
            RemoteSubSystemMap remoteSsns = reader.read(REMOTE_SSN, RemoteSubSystemMap.class);
            RemoteSignalingPointCodeMap remoteSpcs = reader.read(REMOTE_SPC, RemoteSignalingPointCodeMap.class);
            ConcernedSignalingPointCodeMap concernedSpcs = reader.read(CONCERNED_SPC, ConcernedSignalingPointCodeMap.class);
            reader.close();
            return new ResourcesSet(remoteSpcs, remoteSsns, concernedSpcs);
        }

        protected ResourcesSet loadVer3(String fn) throws XMLStreamException, FileNotFoundException {
            XMLObjectReader reader = XMLObjectReader.newInstance(new FileInputStream(fn));
            reader.setBinding(binding);
            return this.loadVer3(reader);
        }

        protected ResourcesSet loadVer3(XMLObjectReader reader) throws XMLStreamException {
            RemoteSubSystemMap remoteSsns = reader.read(REMOTE_SSN, RemoteSubSystemMap.class);
            RemoteSignalingPointCodeMap remoteSpcs = reader.read(REMOTE_SPC, RemoteSignalingPointCodeMap.class);
            ConcernedSignalingPointCodeMap concernedSpcs = reader.read(CONCERNED_SPC, ConcernedSignalingPointCodeMap.class);
            reader.close();
            return new ResourcesSet(remoteSpcs, remoteSsns, concernedSpcs);
        }

        static class ResourcesSet {
            final RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode> remoteSpcs;
            final RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns;
            final ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> concernedSpcs;

            public ResourcesSet(RemoteSignalingPointCodeMap<Integer, RemoteSignalingPointCode> remoteSpcs, RemoteSubSystemMap<Integer, RemoteSubSystem> remoteSsns, ConcernedSignalingPointCodeMap<Integer, ConcernedSignalingPointCode> concernedSpcs) {
                this.remoteSpcs = remoteSpcs;
                this.remoteSsns = remoteSsns;
                this.concernedSpcs = concernedSpcs;
            }
        }
    }
}

