/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.SccpCongestionControlAlgo;
import org.restcomm.protocols.ss7.sccp.impl.congestion.CongStateTimerA;
import org.restcomm.protocols.ss7.sccp.impl.congestion.CongStateTimerD;
import org.restcomm.protocols.ss7.sccp.impl.congestion.SccpCongestionControl;

public class RemoteSignalingPointCodeImpl
implements XMLSerializable,
RemoteSignalingPointCode {
    private static final String REMOTE_SPC = "remoteSpc";
    private static final String REMOTE_SPC_FLAG = "remoteSpcFlag";
    private static final String MASK = "mask";
    private Logger logger = Logger.getLogger(RemoteSignalingPointCodeImpl.class);
    private int remoteSpc;
    private int remoteSpcFlag;
    private int mask;
    protected boolean remoteSpcProhibited;
    protected boolean remoteSccpProhibited;
    protected int rl;
    protected int rsl;
    private CongStateTimerA timerA;
    private CongStateTimerD timerD;
    private SccpCongestionControl sccpCongestionControl;
    protected static final XMLFormat<RemoteSignalingPointCodeImpl> XML = new XMLFormat<RemoteSignalingPointCodeImpl>(RemoteSignalingPointCodeImpl.class){

        @Override
        public void write(RemoteSignalingPointCodeImpl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC, ai.remoteSpc);
            xml.setAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC_FLAG, ai.remoteSpcFlag);
            xml.setAttribute(RemoteSignalingPointCodeImpl.MASK, ai.mask);
        }

        @Override
        public void read(XMLFormat.InputElement xml, RemoteSignalingPointCodeImpl ai) throws XMLStreamException {
            ai.remoteSpc = xml.getAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC).toInt();
            ai.remoteSpcFlag = xml.getAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC_FLAG).toInt();
            ai.mask = xml.getAttribute(RemoteSignalingPointCodeImpl.MASK).toInt();
        }
    };

    public RemoteSignalingPointCodeImpl() {
    }

    public RemoteSignalingPointCodeImpl(int remoteSpc, int remoteSpcFlag, int mask, boolean isProhibited) {
        this.remoteSpc = remoteSpc;
        this.remoteSpcFlag = remoteSpcFlag;
        this.mask = mask;
        this.remoteSccpProhibited = isProhibited;
        this.remoteSpcProhibited = isProhibited;
    }

    @Override
    public int getRemoteSpc() {
        return this.remoteSpc;
    }

    @Override
    public int getRemoteSpcFlag() {
        return this.remoteSpcFlag;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public boolean isRemoteSpcProhibited() {
        return this.remoteSpcProhibited;
    }

    @Override
    public boolean isRemoteSccpProhibited() {
        return this.remoteSccpProhibited;
    }

    protected void setProhibitedState(boolean remoteSpcProhibited, boolean remoteSccpProhibited) {
        this.remoteSpcProhibited = remoteSpcProhibited;
        this.remoteSccpProhibited = remoteSccpProhibited;
    }

    protected void setRemoteSpcProhibited(boolean remoteSpcProhibited) {
        this.remoteSpcProhibited = remoteSpcProhibited;
    }

    protected void setRemoteSccpProhibited(boolean remoteSccpProhibited) {
        this.remoteSccpProhibited = remoteSccpProhibited;
    }

    protected void setRemoteSpc(int remoteSpc) {
        this.remoteSpc = remoteSpc;
    }

    protected void setRemoteSpcFlag(int remoteSpcFlag) {
        this.remoteSpcFlag = remoteSpcFlag;
    }

    protected void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public int getCurrentRestrictionLevel() {
        return this.rl;
    }

    public int getCurrentRestrictionSubLevel() {
        return this.rsl;
    }

    public void clearCongLevel(SccpCongestionControl sccpCongestionControl) {
        this.sccpCongestionControl = sccpCongestionControl;
        this.rl = 0;
        this.rsl = 0;
        this.sccpCongestionControl.onRestrictionLevelChange(this.remoteSpc, this.rl, false);
    }

    public void increaseCongLevel(SccpCongestionControl sccpCongestionControl, int level) {
        this.sccpCongestionControl = sccpCongestionControl;
        if (this.timerA != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SCCP cong increaseCongLevel - no actions because of timerA is not over: " + this);
            }
            return;
        }
        this.timerA = new CongStateTimerA(this);
        this.sccpCongestionControl.scheduleTimer(this.timerA, sccpCongestionControl.getCongControlTIMER_A());
        CongStateTimerD _timerD = this.timerD;
        if (_timerD != null) {
            _timerD.cancel();
        }
        this.timerD = new CongStateTimerD(this);
        this.sccpCongestionControl.scheduleTimer(this.timerD, sccpCongestionControl.getCongControlTIMER_D());
        if (this.rl >= sccpCongestionControl.getCongControlN()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SCCP cong increaseCongLevel - no actions because rl has its max level: " + this);
            }
            return;
        }
        if (sccpCongestionControl.getCongControl_Algo() == SccpCongestionControlAlgo.levelDepended && this.rl >= SccpCongestionControl.getMaxRestrictionLevelForMtp3Level(level)) {
            return;
        }
        ++this.rsl;
        if (this.rsl >= sccpCongestionControl.getCongControlM()) {
            this.rsl = 0;
            ++this.rl;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SCCP cong increaseCongLevel - rl has increased: " + this);
            }
            this.sccpCongestionControl.onRestrictionLevelChange(this.remoteSpc, this.rl, true);
        }
    }

    public void clearTimerA() {
        this.timerA = null;
    }

    public void decreaseCongLevel() {
        if (this.rl == 0 && this.rsl == 0) {
            return;
        }
        --this.rsl;
        if (this.rsl < 0) {
            this.rsl = this.sccpCongestionControl.getCongControlM() - 1;
            --this.rl;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SCCP cong increaseCongLevel - rl has decreased: " + this);
            }
            this.sccpCongestionControl.onRestrictionLevelChange(this.remoteSpc, this.rl, false);
        }
        this.timerD = new CongStateTimerD(this);
        this.sccpCongestionControl.scheduleTimer(this.timerD, this.sccpCongestionControl.getCongControlTIMER_D());
    }

    protected void setCurrentRestrictionLevel(int value) {
        this.rl = value;
        this.rsl = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("rsp=").append(this.remoteSpc).append(" rsp-flag=").append(this.remoteSpcFlag).append(" mask=").append(this.mask).append(" rsp-prohibited=").append(this.remoteSpcProhibited).append(" rsccp-prohibited=").append(this.remoteSccpProhibited).append(" rl=").append(this.rl).append(" rsl=").append(this.rsl);
        return sb.toString();
    }
}

