/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.smstpdu;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.smstpdu.AbsoluteTimeStamp;

public class AbsoluteTimeStampImpl
implements AbsoluteTimeStamp {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int timeZone;

    private AbsoluteTimeStampImpl() {
    }

    public AbsoluteTimeStampImpl(int year, int month, int day, int hour, int minute, int second, int timeZone) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.timeZone = timeZone;
    }

    public static AbsoluteTimeStampImpl createMessage(InputStream stm) throws MAPException {
        if (stm == null) {
            throw new MAPException("Error creating ServiceCentreTimeStamp: stream must not be null");
        }
        AbsoluteTimeStampImpl res = new AbsoluteTimeStampImpl();
        try {
            byte[] buf = new byte[7];
            int i1 = stm.read(buf);
            if (i1 < 7) {
                throw new MAPException("Error creating ServiceCentreTimeStamp: not enouph data in the stream");
            }
            res.year = AbsoluteTimeStampImpl.constractDigitVal(buf[0]);
            res.month = AbsoluteTimeStampImpl.constractDigitVal(buf[1]);
            res.day = AbsoluteTimeStampImpl.constractDigitVal(buf[2]);
            res.hour = AbsoluteTimeStampImpl.constractDigitVal(buf[3]);
            res.minute = AbsoluteTimeStampImpl.constractDigitVal(buf[4]);
            res.second = AbsoluteTimeStampImpl.constractDigitVal(buf[5]);
            res.timeZone = AbsoluteTimeStampImpl.constractDigitVal((byte)(buf[6] & 0xF7));
            if ((buf[6] & 8) != 0) {
                res.timeZone = -res.timeZone;
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when creating ServiceCentreTimeStamp: " + e.getMessage(), e);
        }
        return res;
    }

    private static int constractDigitVal(byte bt) {
        return (bt & 0xF) * 10 + ((bt & 0xF0) >>> 4);
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    @Override
    public int getTimeZone() {
        return this.timeZone;
    }

    private static int constractEncodesVal(int val) {
        int i1 = val % 10;
        int i2 = val / 10;
        return i1 << 4 | i2;
    }

    @Override
    public void encodeData(OutputStream stm) throws MAPException {
        try {
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.year));
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.month));
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.day));
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.hour));
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.minute));
            stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.second));
            if (this.timeZone >= 0) {
                stm.write(AbsoluteTimeStampImpl.constractEncodesVal(this.timeZone));
            } else {
                stm.write(AbsoluteTimeStampImpl.constractEncodesVal(-this.timeZone) | 8);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbsoluteTimeStamp [");
        int yr = this.year > 90 ? 1900 + this.year : 2000 + this.year;
        sb.append(this.month);
        sb.append("/");
        sb.append(this.day);
        sb.append("/");
        sb.append(yr);
        sb.append(" ");
        sb.append(this.hour);
        sb.append(":");
        sb.append(this.minute);
        sb.append(":");
        sb.append(this.second);
        sb.append(" GMT");
        if (this.timeZone >= 0) {
            sb.append("+");
        }
        sb.append(this.timeZone / 4);
        sb.append(":");
        sb.append(this.timeZone % 4 * 15);
        sb.append("]");
        return sb.toString();
    }
}

