/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.primitives;

import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.primitives.GSNAddress;
import org.restcomm.protocols.ss7.map.api.primitives.GSNAddressAddressType;
import org.restcomm.protocols.ss7.map.primitives.OctetStringBase;

public class GSNAddressImpl
extends OctetStringBase
implements GSNAddress {
    public GSNAddressImpl() {
        super(5, 17, "GSNAddress");
    }

    public GSNAddressImpl(byte[] data) {
        super(5, 17, "GSNAddress", data);
    }

    public GSNAddressImpl(GSNAddressAddressType addressType, byte[] addressData) throws MAPException {
        super(5, 17, "GSNAddress", null);
        if (addressType == null) {
            throw new MAPException("addressType argument must not be null");
        }
        if (addressData == null) {
            throw new MAPException("addressData argument must not be null");
        }
        switch (addressType) {
            case IPv4: {
                if (addressData.length == 4) break;
                throw new MAPException("addressData argument must have length=4 for IPv4");
            }
            case IPv6: {
                if (addressData.length == 16) break;
                throw new MAPException("addressData argument must have length=4 for IPv6");
            }
        }
        this.data = new byte[addressData.length + 1];
        this.data[0] = (byte)addressType.createGSNAddressFirstByte();
        System.arraycopy(addressData, 0, this.data, 1, addressData.length);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public GSNAddressAddressType getGSNAddressAddressType() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        int val = this.data[0] & 0xFF;
        return GSNAddressAddressType.getFromGSNAddressFirstByte(val);
    }

    @Override
    public byte[] getGSNAddressData() {
        GSNAddressAddressType type = this.getGSNAddressAddressType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case IPv4: {
                if (this.data.length < 5) break;
                byte[] res = new byte[4];
                System.arraycopy(this.data, 1, res, 0, 4);
                return res;
            }
            case IPv6: {
                if (this.data.length < 17) break;
                byte[] res = new byte[16];
                System.arraycopy(this.data, 1, res, 0, 16);
                return res;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        GSNAddressAddressType type = this.getGSNAddressAddressType();
        byte[] val = this.getGSNAddressData();
        if (type != null && val != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this._PrimitiveName);
            sb.append(" [");
            sb.append("type=");
            sb.append((Object)type);
            sb.append(", data=[");
            sb.append(this.printDataArr(val));
            sb.append("]");
            sb.append("]");
            return sb.toString();
        }
        return super.toString();
    }

    protected String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (arr != null) {
            for (byte b : arr) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(b & 0xFF);
            }
        }
        return sb.toString();
    }
}

