/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public abstract class FuzzyTbcdString
implements MAPAsnPrimitive {
    protected static int DIGIT_1_MASK = 15;
    protected static int DIGIT_2_MASK = 240;
    protected String data;
    protected int minLength;
    protected int maxLength;
    protected String _PrimitiveName;

    public FuzzyTbcdString(int minLength, int maxLength, String _PrimitiveName) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this._PrimitiveName = _PrimitiveName;
    }

    public FuzzyTbcdString(int minLength, int maxLength, String _PrimitiveName, String data) {
        this(minLength, maxLength, _PrimitiveName);
        this.data = data;
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        if (!ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": field must be primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (length < this.minLength || length > this.maxLength) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain from " + this.minLength + " to " + this.maxLength + " octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        try {
            this.data = FuzzyTbcdString.decodeString(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.data == null) {
            throw new MAPException("Error while encoding the " + this._PrimitiveName + ": data is not defined");
        }
        FuzzyTbcdString.encodeString(asnOs, this.data);
    }

    public static String decodeString(InputStream ansIS, int length) throws IOException, MAPParsingComponentException {
        StringBuilder s = new StringBuilder();
        for (int i1 = 0; i1 < length; ++i1) {
            int b = ansIS.read();
            int digit1 = b & DIGIT_1_MASK;
            if (digit1 != 15) {
                s.append(FuzzyTbcdString.decodeNumber(digit1));
            }
            int digit2 = (b & DIGIT_2_MASK) >> 4;
            if (digit2 == 15) continue;
            s.append(FuzzyTbcdString.decodeNumber(digit2));
        }
        return s.toString();
    }

    public static void encodeString(OutputStream asnOs, String data) throws MAPException {
        char[] chars = data.toCharArray();
        for (int i = 0; i < chars.length; i += 2) {
            try {
                asnOs.write(chars[i]);
                continue;
            }
            catch (IOException e) {
                throw new MAPException("Error when encoding TbcdString: " + e.getMessage(), e);
            }
        }
    }

    protected static int encodeNumber(char c) throws MAPException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '#': {
                return 11;
            }
            case 'A': 
            case 'a': {
                return 12;
            }
            case 'B': 
            case 'b': {
                return 13;
            }
            case 'C': 
            case 'c': {
                return 14;
            }
        }
        throw new MAPException("char should be between 0 - 9, *, #, a, b, c for Telephony Binary Coded Decimal String. Received " + c);
    }

    protected static char decodeNumber(int i) throws MAPParsingComponentException {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return 'a';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return 'c';
            }
        }
        throw new MAPParsingComponentException("Integer should be between 0 - 15 for Telephony Binary Coded Decimal String. Received " + i, MAPParsingComponentExceptionReason.MistypedParameter);
    }

    public String toString() {
        return this._PrimitiveName + " [" + this.data + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyTbcdString other = (FuzzyTbcdString)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

