/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.As;
import org.restcomm.protocols.ss7.m3ua.Asp;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.IPSPType;
import org.restcomm.protocols.ss7.m3ua.RouteAs;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.MessageHandler;
import org.restcomm.protocols.ss7.m3ua.impl.RouteAsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.DeregistrationResultImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.DeregistrationStatusImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.RegistrationResultImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.RegistrationStatusImpl;
import org.restcomm.protocols.ss7.m3ua.message.rkm.DeregistrationRequest;
import org.restcomm.protocols.ss7.m3ua.message.rkm.DeregistrationResponse;
import org.restcomm.protocols.ss7.m3ua.message.rkm.RegistrationRequest;
import org.restcomm.protocols.ss7.m3ua.message.rkm.RegistrationResponse;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingKey;
import org.restcomm.protocols.ss7.m3ua.parameter.TrafficModeType;

public class RoutingKeyManagementHandler
extends MessageHandler {
    private static final Logger logger = Logger.getLogger(RoutingKeyManagementHandler.class);
    private static final String KEY_SEPARATOR = ":";
    private static final String AS_NAME = "asRkm";
    private AtomicInteger asCounter = new AtomicInteger(1);

    public RoutingKeyManagementHandler(AspFactoryImpl aspFactoryImpl) {
        super(aspFactoryImpl);
    }

    public void handleRegistrationRequest(RegistrationRequest registrationRequest) {
        String asName = null;
        RoutingKey routingKey = registrationRequest.getRoutingKey();
        TrafficModeType trafficMode = routingKey.getTrafficModeType();
        RoutingContext rc = routingKey.getRoutingContext();
        int dpc = routingKey.getDestinationPointCodes()[0].getPointCode();
        int[] opcs = null;
        short[] sis = null;
        opcs = routingKey.getOPCLists() == null ? new int[]{-1} : routingKey.getOPCLists()[0].getPointCodes();
        RouteAs routeAs = this.compareRoutingKeys(dpc, opcs, sis = routingKey.getServiceIndicators() == null ? new short[]{-1} : routingKey.getServiceIndicators()[0].getIndicators());
        if (routeAs != null) {
            for (As as : routeAs.getAsArray()) {
                if (as == null) continue;
                List<Asp> currList = as.getAspList();
                boolean found = false;
                for (Asp subAsp : currList) {
                    if (!subAsp.getName().equals(this.aspFactoryImpl.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                try {
                    this.aspFactoryImpl.m3UAManagementImpl.assignAspToAs(as.getName(), this.aspFactoryImpl.getName());
                }
                catch (Exception e) {
                    logger.error("Can not assign ASP to AS after register request", e);
                    this.sendRegisterError(routingKey, 1);
                    return;
                }
            }
        } else {
            Functionality functionality = null;
            ExchangeType exchangeType = null;
            IPSPType ipspType = null;
            int minAspActiveForLoadbalance = 0;
            if (!this.aspFactoryImpl.m3UAManagementImpl.appServers.isEmpty()) {
                for (As as : this.aspFactoryImpl.m3UAManagementImpl.appServers) {
                    if (as == null) continue;
                    functionality = as.getFunctionality();
                    exchangeType = as.getExchangeType();
                    ipspType = as.getIpspType();
                    minAspActiveForLoadbalance = as.getMinAspActiveForLb();
                }
                try {
                    asName = AS_NAME + this.asCounter.getAndIncrement();
                    this.aspFactoryImpl.m3UAManagementImpl.createAs(asName, functionality, exchangeType, ipspType, rc, trafficMode, minAspActiveForLoadbalance, routingKey.getNetworkAppearance());
                }
                catch (Exception e) {
                    logger.error("Can not create AS after register request", e);
                    this.sendRegisterError(routingKey, 1);
                    return;
                }
            } else {
                logger.error("Can not create AS because of empty AS list after register request. Creation new one based on exited one.");
                this.sendRegisterError(routingKey, 1);
                return;
            }
            try {
                this.aspFactoryImpl.m3UAManagementImpl.assignAspToAs(asName, this.aspFactoryImpl.getName());
            }
            catch (Exception e) {
                logger.error("Can not assign ASP to AS after register request", e);
                this.sendRegisterError(routingKey, 1);
                return;
            }
            try {
                this.addRoute(asName, dpc, opcs, sis, trafficMode.getMode());
            }
            catch (Exception e) {
                logger.error("Can not add Route after register request", e);
                this.sendRegisterError(routingKey, 1);
                return;
            }
        }
        RegistrationResponse registrationResponse = (RegistrationResponse)this.aspFactoryImpl.messageFactory.createMessage(9, 2);
        RegistrationResultImpl rslt = new RegistrationResultImpl(routingKey.getLocalRKIdentifier(), new RegistrationStatusImpl(0), rc);
        registrationResponse.setRegistrationResult(rslt);
        this.aspFactoryImpl.write(registrationResponse);
    }

    public void handleRegistrationResponse(RegistrationResponse registrationResponse) {
        logger.error(String.format("Received REGRES=%s. Handling of RKM message is not supported", registrationResponse));
    }

    public void handleDeregistrationRequest(DeregistrationRequest deregistrationRequest) {
        int i$ = 0;
        RoutingContext rc = deregistrationRequest.getRoutingContext();
        long[] arr$ = rc.getRoutingContexts();
        int len$ = arr$.length;
        if (i$ < len$) {
            long currRc = arr$[i$];
            AspImpl aspImpl = this.aspFactoryImpl.getAsp(currRc);
            if (aspImpl != null) {
                try {
                    AsImpl as = aspImpl.asImpl;
                    this.aspFactoryImpl.m3UAManagementImpl.stopAsp(aspImpl.getName());
                    this.aspFactoryImpl.m3UAManagementImpl.unassignAspFromAs(as.getName(), aspImpl.getName());
                    if (as.appServerProcs.isEmpty()) {
                        for (Map.Entry<String, RouteAs> entry : this.aspFactoryImpl.m3UAManagementImpl.getRoute().entrySet()) {
                            if (!((RouteAsImpl)entry.getValue()).hasAs(as)) continue;
                            String key = entry.getKey();
                            String[] keys = key.split(KEY_SEPARATOR);
                            this.aspFactoryImpl.m3UAManagementImpl.removeRoute(Integer.valueOf(keys[0]), Integer.valueOf(keys[1]), Integer.valueOf(keys[2]), as.getName());
                        }
                        this.aspFactoryImpl.m3UAManagementImpl.destroyAs(as.getName());
                    }
                    this.aspFactoryImpl.m3UAManagementImpl.startAsp(aspImpl.getName());
                    DeregistrationResponse deregistrationResponse = (DeregistrationResponse)this.aspFactoryImpl.messageFactory.createMessage(9, 4);
                    DeregistrationResultImpl derslt = new DeregistrationResultImpl(rc, new DeregistrationStatusImpl(0));
                    deregistrationResponse.setDeregistrationResult(derslt);
                    this.aspFactoryImpl.write(deregistrationResponse);
                    return;
                }
                catch (Exception e) {
                    logger.error("Can not add Route after register request", e);
                    this.sendDeregisterError(rc, 1);
                    return;
                }
            }
            logger.error("Can not find ASP for RC : " + currRc + " register request");
            this.sendDeregisterError(rc, 1);
            return;
        }
    }

    public void handleDeregistrationResponse(DeregistrationResponse deregistrationResponse) {
        logger.error(String.format("Received DEREGRES=%s. Handling of RKM message is not supported", deregistrationResponse));
    }

    private RouteAs compareRoutingKeys(int dpc, int[] opcIntArr, short[] siShortArr) {
        RouteAs route = null;
        for (int i = 0; i < opcIntArr.length; ++i) {
            for (int j = 0; j < siShortArr.length; ++j) {
                String sKey = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(opcIntArr[i]).append(KEY_SEPARATOR).append(siShortArr[j]).toString();
                route = this.aspFactoryImpl.m3UAManagementImpl.getRoute().get(sKey);
                if (route == null) continue;
                return route;
            }
        }
        return route;
    }

    private void addRoute(String asName, int dpc, int[] opcIntArr, short[] siShortArr, int trafficMode) throws Exception {
        for (int i = 0; i < opcIntArr.length; ++i) {
            for (int j = 0; j < siShortArr.length; ++j) {
                this.aspFactoryImpl.m3UAManagementImpl.addRoute(dpc, opcIntArr[i], siShortArr[j], asName, trafficMode);
            }
        }
    }

    private void sendRegisterError(RoutingKey routingKey, int errorCode) {
        RegistrationResponse registrationResponse = (RegistrationResponse)this.aspFactoryImpl.messageFactory.createMessage(9, 2);
        RegistrationResultImpl rslt = new RegistrationResultImpl(routingKey.getLocalRKIdentifier(), new RegistrationStatusImpl(errorCode), routingKey.getRoutingContext());
        registrationResponse.setRegistrationResult(rslt);
        this.aspFactoryImpl.write(registrationResponse);
    }

    private void sendDeregisterError(RoutingContext rc, int errorCode) {
        DeregistrationResponse deregistrationResponse = (DeregistrationResponse)this.aspFactoryImpl.messageFactory.createMessage(9, 4);
        DeregistrationStatusImpl status = new DeregistrationStatusImpl(1);
        DeregistrationResultImpl rslt = new DeregistrationResultImpl(rc, status);
        deregistrationResponse.setDeregistrationResult(rslt);
        this.aspFactoryImpl.write(deregistrationResponse);
    }
}

