/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import sun.reflect.Reflection;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;

    static {
        try {
            Reflection.getCallerClass((int)2);
            GET_CALLER_CLASS_METHOD_AVAILABLE = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Throwable e) {
            System.err.println("Unexpected exception");
            e.printStackTrace();
        }
    }

    public void calculate(IThrowableProxy tp) {
        while (tp != null) {
            this.populateFrames(tp.getStackTraceElementProxyArray());
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                IThrowableProxy[] iThrowableProxyArray = suppressed;
                int n = suppressed.length;
                int n2 = 0;
                while (n2 < n) {
                    IThrowableProxy current = iThrowableProxyArray[n2];
                    this.populateFrames(current.getStackTraceElementProxyArray());
                    ++n2;
                }
            }
            tp = tp.getCause();
        }
    }

    void populateFrames(StackTraceElementProxy[] stepArray) {
        Throwable t = new Throwable("local stack reference");
        StackTraceElement[] localteSTEArray = t.getStackTrace();
        int commonFrames = STEUtil.findNumberOfCommonFrames(localteSTEArray, stepArray);
        int localFirstCommon = localteSTEArray.length - commonFrames;
        int stepFirstCommon = stepArray.length - commonFrames;
        ClassLoader lastExactClassLoader = null;
        ClassLoader firsExactClassLoader = null;
        int missfireCount = 0;
        int i = 0;
        while (i < commonFrames) {
            ClassPackagingData pi;
            Class callerClass = null;
            if (GET_CALLER_CLASS_METHOD_AVAILABLE) {
                callerClass = Reflection.getCallerClass((int)(localFirstCommon + i - missfireCount + 1));
            }
            StackTraceElementProxy step = stepArray[stepFirstCommon + i];
            String stepClassname = step.ste.getClassName();
            if (callerClass != null && stepClassname.equals(callerClass.getName())) {
                lastExactClassLoader = callerClass.getClassLoader();
                if (firsExactClassLoader == null) {
                    firsExactClassLoader = lastExactClassLoader;
                }
                pi = this.calculateByExactType(callerClass);
                step.setClassPackagingData(pi);
            } else {
                ++missfireCount;
                pi = this.computeBySTEP(step, lastExactClassLoader);
                step.setClassPackagingData(pi);
            }
            ++i;
        }
        this.populateUncommonFrames(commonFrames, stepArray, firsExactClassLoader);
    }

    void populateUncommonFrames(int commonFrames, StackTraceElementProxy[] stepArray, ClassLoader firstExactClassLoader) {
        int uncommonFrames = stepArray.length - commonFrames;
        int i = 0;
        while (i < uncommonFrames) {
            StackTraceElementProxy step = stepArray[i];
            ClassPackagingData pi = this.computeBySTEP(step, firstExactClassLoader);
            step.setClassPackagingData(pi);
            ++i;
        }
    }

    private ClassPackagingData calculateByExactType(Class type) {
        String className = type.getName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        String version2 = this.getImplementationVersion(type);
        String codeLocation = this.getCodeLocation(type);
        cpd = new ClassPackagingData(codeLocation, version2);
        this.cache.put(className, cpd);
        return cpd;
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy step, ClassLoader lastExactClassLoader) {
        String className = step.ste.getClassName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        Class type = this.bestEffortLoadClass(lastExactClassLoader, className);
        String version2 = this.getImplementationVersion(type);
        String codeLocation = this.getCodeLocation(type);
        cpd = new ClassPackagingData(codeLocation, version2, false);
        this.cache.put(className, cpd);
        return cpd;
    }

    String getImplementationVersion(Class type) {
        if (type == null) {
            return "na";
        }
        Package aPackage = type.getPackage();
        if (aPackage != null) {
            String v = aPackage.getImplementationVersion();
            if (v == null) {
                return "na";
            }
            return v;
        }
        return "na";
    }

    String getCodeLocation(Class type) {
        try {
            URL resource;
            CodeSource codeSource;
            if (type != null && (codeSource = type.getProtectionDomain().getCodeSource()) != null && (resource = codeSource.getLocation()) != null) {
                String locationStr = resource.toString();
                String result2 = this.getCodeLocation(locationStr, '/');
                if (result2 != null) {
                    return result2;
                }
                return this.getCodeLocation(locationStr, '\\');
            }
        }
        catch (Exception exception) {}
        return "na";
    }

    private String getCodeLocation(String locationStr, char separator) {
        int idx = locationStr.lastIndexOf(separator);
        if (this.isFolder(idx, locationStr)) {
            idx = locationStr.lastIndexOf(separator, idx - 1);
            return locationStr.substring(idx + 1);
        }
        if (idx > 0) {
            return locationStr.substring(idx + 1);
        }
        return null;
    }

    private boolean isFolder(int idx, String text2) {
        return idx != -1 && idx + 1 == text2.length();
    }

    private Class loadClass(ClassLoader cl, String className) {
        if (cl == null) {
            return null;
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class bestEffortLoadClass(ClassLoader lastGuaranteedClassLoader, String className) {
        Class result2 = this.loadClass(lastGuaranteedClassLoader, className);
        if (result2 != null) {
            return result2;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != lastGuaranteedClassLoader) {
            result2 = this.loadClass(tccl, className);
        }
        if (result2 != null) {
            return result2;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

