"""
exploitDB.py - A simple Module

Author: Levi (levi0x0)
Date: 21/06/2014
Version: 0.3
License: GPL 3

Description:
	This module ExploitDB will search exploits, etc.. in the EXPLOIT-DB.COM data-base
"""

MODULE_NAME = "exploitDB"
MODULE_AUTHOR = "Levi (levi0x0)"
MODULE_LICENSE = "GPL 3"
MODULE_VERSION = "0.2"
MODULE_DESC = "This module ExploitDB will search exploits, etc.."

import sqlite3 as sl
import os
import urllib2
from api.std import *
from api.auto import *
from api.lib import wget

class exploitDB(object):
    def __init__(self):
        self.exploitdb_path = "%s/output/exploit-db" %(home)
        self.database_url = "https://github.com/levi0x0/sb0x-project/wiki/Files/exploitdb-s0x.db"
        self.upd_date = "03-06-2014"
        self.databasemd5 = "09c70c1165dd1fffaba1865a762b0a7c"

    def help(self):
        notify("Exploit-DB Options:\n")
        notify("\tautohr - search by author.")
        notify("\t\tUsage: author Exploit_Author")
        notify("\tport - search exploit by port.")
        notify("\t\tUsage: port 22")
        notify("\tplatform -  search by platform")
        notify("\t\tUsage: platform linux")
        notify("\tdownload - download exploit by id")
        notify("\t\tUsage: download EXPLOIT_ID")
        notify("\tshow-all - dump all exploits.\n")

    def check_database(self):
        check_path(home)

        if not os.path.exists(self.exploitdb_path):
            os.mkdir(self.exploitdb_path)
            start("[*] We need to sync the local database, it may take a while..")
            notify("[*] Latest Updated: %s" %(self.upd_date))
            notify("[*] Verified by: levi (levi0x0)")
            notify("[*] Database MD5SUM: %s" %(self.databasemd5))
            os.chdir(self.exploitdb_path)
            try:
                wget.download(self.database_url)
            except Exception as e:
                error(e.message)
            os.chdir(home)
            notify("[*] Done..")
        else:
            if os.path.exists(self.exploitdb_path):
                pass

            else:
                error("[*] exploit-db dir not Found! ")
                raise Exception
    def search_ex(self, search):

        self.search = search
        os.chdir(self.exploitdb_path)
        self.conn = sl.connect("exploitdb-s0x.db")
        self.conn.commit()
        self.c = self.conn.cursor()

        if self.search == "show-all":
            start("[*] Fetching all from the data-base...")
            query = "SELECT field3,field6 FROM `exploitdb`"

            self.c.execute(query)
            self.conn.commit()
               
            i = 0
            for exploit in self.c:
                i += 1
                print "+%s+" %("-" * len(exploit[0]))
                print "| %s (%s)|" %(exploit[0], exploit[1])
                print "+%s+" %("-" * len(exploit[0]))
            notify("\nFound: %d." %(i)) 

        elif self.search == "help" or self.search == "?":
            self.help()

        elif "platform" in self.search:
            platform = self.search.replace("platform", "").strip()
                
            start("[*] Fetching information for: %s" %(platform))

            query = "SELECT field1,field3 FROM `exploitdb` WHERE field6 = \"%s\"" % (platform)


            self.c.execute(query)
            self.conn.commit()

            ret = self.c.fetchone()

            if ret:
                pass
            else:
                error("Platform: %s Not Found..\n" %(platform))

            i = 0
            for row in self.c:
                i += 1
                print "+%s+" %("-" * len(row[1]))
                print "| ID %s | %s " %(row[0], row[1])
                print "+%s+" %("-" * len(row[1]))

            notify("[*] Found %d" %(i))
        elif "port" in self.search:
            port = self.search.replace("port", "").strip()

            start("[*] Fetching information for port: %s" %(port))

            query = "SELECT field1,field3,field6 FROM `exploitdb` WHERE `field8` = \"%s\"" %(port)

            self.c.execute(query)
            self.conn.commit()
           
            ret = self.c.fetchone()

            if ret:
                pass
            else:
                error("Exploits for port: %s - Not Found" %(port))
            i = 0
            for row in self.c:
                 i += 1
                 print "+%s+" %("-" * len(row[1]))
                 print "| ID %s | %s (%s) |" %(row[0], row[1], row[2])
            print "+-------------------------------------+"
            notify("\nFound: %d." %(i))

        elif "author" in self.search:
            author = self.search.replace("author", "").strip()
            start("Fetching information for: %s" %(author))
            query = "SELECT  field1,field3 FROM `exploitdb` WHERE `field5` = \"%s\"" %(author) 

            self.c.execute(query)
                
            ret = self.c.fetchone()

            if ret:
                pass
            else:
                error("Exploits for author: %s - Not Found" %(author))
            i = 0
            for row in self.c:
                i += 1
                print "+%s+" %("-" * len(row[1]))
                print "| ID %s | %s |" %(row[0], row[1])
            print "+----------------------------------+"
            notify("Found: %d" %(i))

        elif "download" in self.search:
            ID = search.replace("download", "").strip()

            self.download_link = "http://www.exploit-db.com/download/%d" %(int(ID))
            os.chdir("%s/output/" %(home))

            try:
                notify("[*] Downloading exploit ID: %d" %(int(ID)))
                filename = wget.download(self.download_link)
                notify("\n[*] Done Saved to: %s/output/%s" %(home,filename))
            except Exception as e:
                error("Failed to Download exploit..")
            os.chdir(home)

        else:
            error("Option: %s Not exists.." %(search) )

def main():
        start = exploitDB()
        start.check_database()

        options_array = ["author", "platform", "download", "show-all", "port"]
        sb0x_complete(options_array)

        while True:
            search = raw_input("exploitDB => ")
            if not search:
                continue
            if "exit" in search:
                break
            else:
                start.search_ex(search)
