/** @file cmdlineEnumNG.h.in
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINEENUMNG_H
#define CMDLINEENUMNG_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "enumNG"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "enumNG"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.3.2"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * username_arg;	/**< @brief Activate username mode using the data in the given file.  */
  char * username_orig;	/**< @brief Activate username mode using the data in the given file original value given at command line.  */
  const char *username_help; /**< @brief Activate username mode using the data in the given file help description.  */
  char * simAtt_arg;	/**< @brief Execute a simulated attack against the given target file.  */
  char * simAtt_orig;	/**< @brief Execute a simulated attack against the given target file original value given at command line.  */
  const char *simAtt_help; /**< @brief Execute a simulated attack against the given target file help description.  */
  int pipeMode_flag;	/**< @brief Only print generated Passwords and nothing else (overrides any other mode!) (default=off).  */
  const char *pipeMode_help; /**< @brief Only print generated Passwords and nothing else (overrides any other mode!) help description.  */
  char * alpha_arg;	/**< @brief Apply boosting factor alpha. Read alpha values from filename. Alphas need to be in the same order as the hints..  */
  char * alpha_orig;	/**< @brief Apply boosting factor alpha. Read alpha values from filename. Alphas need to be in the same order as the hints. original value given at command line.  */
  const char *alpha_help; /**< @brief Apply boosting factor alpha. Read alpha values from filename. Alphas need to be in the same order as the hints. help description.  */
  char * hint_arg;	/**< @brief File containing the hints for alpha boosting. Need to be in the same order as the alpha values..  */
  char * hint_orig;	/**< @brief File containing the hints for alpha boosting. Need to be in the same order as the alpha values. original value given at command line.  */
  const char *hint_help; /**< @brief File containing the hints for alpha boosting. Need to be in the same order as the alpha values. help description.  */
  int boostEP_flag;	/**< @brief Controls wether EPs are boosted or not. (default=off).  */
  const char *boostEP_help; /**< @brief Controls wether EPs are boosted or not. help description.  */
  float llFactor_arg;	/**< @brief Apply the given level length factor. Factor should be in range 0.0 to 10.0 (default='0.0').  */
  char * llFactor_orig;	/**< @brief Apply the given level length factor. Factor should be in range 0.0 to 10.0 original value given at command line.  */
  const char *llFactor_help; /**< @brief Apply the given level length factor. Factor should be in range 0.0 to 10.0 help description.  */
  int llSet_arg;	/**< @brief Set all length level to the given value. Values should be in range 0 to 101 (default='0').  */
  char * llSet_orig;	/**< @brief Set all length level to the given value. Values should be in range 0 to 101 original value given at command line.  */
  const char *llSet_help; /**< @brief Set all length level to the given value. Values should be in range 0 to 101 help description.  */
  int optimizedLS_flag;	/**< @brief Activate optimized length scheduling (default=off).  */
  const char *optimizedLS_help; /**< @brief Activate optimized length scheduling help description.  */
  int fixedLength_arg;	/**< @brief Only generate Passwords of the given length between 3 and 19. Default disabled. (default='0').  */
  char * fixedLength_orig;	/**< @brief Only generate Passwords of the given length between 3 and 19. Default disabled. original value given at command line.  */
  const char *fixedLength_help; /**< @brief Only generate Passwords of the given length between 3 and 19. Default disabled. help description.  */
  #if defined(HAVE_LONG_LONG) || defined(HAVE_LONG_LONG_INT)
  long long int maxattempts_arg;	/**< @brief Set the amount of passwords created. The value should be in range 1 to 10^15.  */
  #else
  long maxattempts_arg;	/**< @brief Set the amount of passwords created. The value should be in range 1 to 10^15.  */
  #endif
  char * maxattempts_orig;	/**< @brief Set the amount of passwords created. The value should be in range 1 to 10^15 original value given at command line.  */
  const char *maxattempts_help; /**< @brief Set the amount of passwords created. The value should be in range 1 to 10^15 help description.  */
  int endless_flag;	/**< @brief Generate all possible passwords (this may take a while) (default=off).  */
  const char *endless_help; /**< @brief Generate all possible passwords (this may take a while) help description.  */
  int ignoreEP_flag;	/**< @brief Ignore the endProbs while generating Passwords (default=off).  */
  const char *ignoreEP_help; /**< @brief Ignore the endProbs while generating Passwords help description.  */
  int verbose_flag;	/**< @brief Gain information about settings and results during run time (default=off).  */
  const char *verbose_help; /**< @brief Gain information about settings and results during run time help description.  */
  int verboseFile_flag;	/**< @brief Stores the generated passwords on hard drive disc (independent of the used mode) (default=off).  */
  const char *verboseFile_help; /**< @brief Stores the generated passwords on hard drive disc (independent of the used mode) help description.  */
  int printWarnings_flag;	/**< @brief Prints any warning (if verbose mode is active). (default=off).  */
  const char *printWarnings_help; /**< @brief Prints any warning (if verbose mode is active). help description.  */
  char * config_arg;	/**< @brief Change the used config file.  */
  char * config_orig;	/**< @brief Change the used config file original value given at command line.  */
  const char *config_help; /**< @brief Change the used config file help description.  */

  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int username_given ;	/**< @brief Whether username was given.  */
  unsigned int simAtt_given ;	/**< @brief Whether simAtt was given.  */
  unsigned int pipeMode_given ;	/**< @brief Whether pipeMode was given.  */
  unsigned int alpha_given ;	/**< @brief Whether alpha was given.  */
  unsigned int hint_given ;	/**< @brief Whether hint was given.  */
  unsigned int boostEP_given ;	/**< @brief Whether boostEP was given.  */
  unsigned int llFactor_given ;	/**< @brief Whether llFactor was given.  */
  unsigned int llSet_given ;	/**< @brief Whether llSet was given.  */
  unsigned int optimizedLS_given ;	/**< @brief Whether optimizedLS was given.  */
  unsigned int fixedLength_given ;	/**< @brief Whether fixedLength was given.  */
  unsigned int maxattempts_given ;	/**< @brief Whether maxattempts was given.  */
  unsigned int endless_given ;	/**< @brief Whether endless was given.  */
  unsigned int ignoreEP_given ;	/**< @brief Whether ignoreEP was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int verboseFile_given ;	/**< @brief Whether verboseFile was given.  */
  unsigned int printWarnings_given ;	/**< @brief Whether printWarnings was given.  */
  unsigned int config_given ;	/**< @brief Whether config was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINEENUMNG_H */
